/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.upperdialog.toast;

import android.animation.Animator;
import android.app.Activity;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.zlylib.upperdialog.R;
import com.zlylib.upperdialog.common.AnimatorHelper;
import com.zlylib.upperdialog.manager.DecorLayer;
import com.zlylib.upperdialog.utils.Utils;

public class ToastLayer
extends DecorLayer
implements Runnable {
    public ToastLayer(Context context) {
        this(Utils.getActivity(Utils.requireNonNull(context, "context == null")));
    }

    public ToastLayer(Activity activity) {
        super(activity);
        this.interceptKeyEvent(false);
        this.cancelableOnKeyBack(false);
    }

    @Override
    protected DecorLayer.Level getLevel() {
        return DecorLayer.Level.TOAST;
    }

    @Override
    protected ViewHolder onCreateViewHolder() {
        return new ViewHolder();
    }

    @Override
    public ViewHolder getViewHolder() {
        return (ViewHolder)super.getViewHolder();
    }

    @Override
    protected Config onCreateConfig() {
        return new Config();
    }

    @Override
    public Config getConfig() {
        return (Config)super.getConfig();
    }

    @Override
    protected ListenerHolder onCreateListenerHolder() {
        return new ListenerHolder();
    }

    @Override
    public ListenerHolder getListenerHolder() {
        return (ListenerHolder)super.getListenerHolder();
    }

    @Override
    public void dismiss(boolean withAnim) {
        super.dismiss(withAnim);
    }

    public ToastLayer removeOthers(boolean removeOthers) {
        this.getConfig().mRemoveOthers = removeOthers;
        return this;
    }

    public ToastLayer duration(long duration) {
        this.getConfig().mDuration = duration;
        return this;
    }

    public ToastLayer message(CharSequence message) {
        Utils.requireNonNull(message, "message == null");
        this.getConfig().mMessage = message;
        return this;
    }

    public ToastLayer message(int message) {
        this.getConfig().mMessage = this.getActivity().getString(message);
        return this;
    }

    public ToastLayer icon(int icon) {
        this.getConfig().mIcon = icon;
        return this;
    }

    public ToastLayer gravity(int gravity) {
        this.getConfig().mGravity = gravity;
        return this;
    }

    public ToastLayer marginLeft(int marginLeft) {
        this.getConfig().mMarginLeft = marginLeft;
        return this;
    }

    public ToastLayer marginTop(int marginTop) {
        this.getConfig().mMarginTop = marginTop;
        return this;
    }

    public ToastLayer marginRight(int marginRight) {
        this.getConfig().mMarginRight = marginRight;
        return this;
    }

    public ToastLayer marginBottom(int marginBottom) {
        this.getConfig().mMarginBottom = marginBottom;
        return this;
    }

    public ToastLayer alpha(float alpha) {
        this.getConfig().mAlpha = alpha;
        return this;
    }

    public ToastLayer backgroundDrawable(Drawable drawable) {
        this.getConfig().mBackgroundDrawable = drawable;
        return this;
    }

    public ToastLayer backgroundDrawable(int drawableRes) {
        this.getConfig().mBackgroundDrawableRes = drawableRes;
        return this;
    }

    public ToastLayer backgroundColorInt(int colorInt) {
        this.getConfig().mBackgroundColor = colorInt;
        return this;
    }

    public ToastLayer backgroundColorRes(int colorRes) {
        this.getConfig().mBackgroundColor = this.getActivity().getResources().getColor(colorRes);
        return this;
    }

    @Override
    protected View onCreateChild(LayoutInflater inflater, ViewGroup parent) {
        return inflater.inflate(R.layout.anylayer_toast_layer, parent, false);
    }

    @Override
    protected Animator onCreateInAnimator(View view) {
        Animator animator = super.onCreateInAnimator(view);
        if (animator == null) {
            animator = AnimatorHelper.createZoomAlphaInAnim(view);
        }
        return animator;
    }

    @Override
    protected Animator onCreateOutAnimator(View view) {
        Animator animator = super.onCreateOutAnimator(view);
        if (animator == null) {
            animator = AnimatorHelper.createZoomAlphaOutAnim(view);
        }
        return animator;
    }

    private void bindData() {
        if (this.getConfig().mIcon > 0) {
            this.getViewHolder().getIcon().setVisibility(0);
            this.getViewHolder().getIcon().setImageResource(this.getConfig().mIcon);
        } else {
            this.getViewHolder().getIcon().setVisibility(8);
        }
        if (TextUtils.isEmpty((CharSequence)this.getConfig().mMessage)) {
            this.getViewHolder().getMessage().setVisibility(8);
            this.getViewHolder().getMessage().setText((CharSequence)"");
        } else {
            this.getViewHolder().getMessage().setVisibility(0);
            this.getViewHolder().getMessage().setText(this.getConfig().mMessage);
        }
        if (this.getConfig().mBackgroundDrawable != null) {
            this.getChild().setBackgroundDrawable(this.getConfig().mBackgroundDrawable);
        } else if (this.getConfig().mBackgroundDrawableRes != -1) {
            this.getChild().setBackgroundResource(this.getConfig().mBackgroundDrawableRes);
        } else {
            Drawable backgroundDrawable = this.getChild().getBackground();
            if (backgroundDrawable instanceof GradientDrawable) {
                backgroundDrawable.setColorFilter(this.getConfig().mBackgroundColor, PorterDuff.Mode.SRC_ATOP);
            }
        }
        this.getChild().setAlpha(this.getConfig().mAlpha);
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getChild().getLayoutParams();
        params.gravity = this.getConfig().mGravity;
        if (this.getConfig().mMarginLeft >= 0) {
            params.leftMargin = this.getConfig().mMarginLeft;
        }
        if (this.getConfig().mMarginTop >= 0) {
            params.topMargin = this.getConfig().mMarginTop;
        }
        if (this.getConfig().mMarginRight >= 0) {
            params.rightMargin = this.getConfig().mMarginRight;
        }
        if (this.getConfig().mMarginBottom >= 0) {
            params.bottomMargin = this.getConfig().mMarginBottom;
        }
        this.getChild().setLayoutParams((ViewGroup.LayoutParams)params);
    }

    @Override
    public void onAttach() {
        super.onAttach();
        this.getChild().setTag((Object)this);
        if (this.getConfig().mRemoveOthers) {
            ViewGroup parent = this.getParent();
            int count = parent.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                ToastLayer toastLayer;
                View child = parent.getChildAt(i);
                Object tag = child.getTag();
                if (!(tag instanceof ToastLayer) || (toastLayer = (ToastLayer)tag) == this) continue;
                toastLayer.dismiss(false);
            }
        }
        this.bindData();
    }

    @Override
    public void onPreDraw() {
        super.onPreDraw();
    }

    @Override
    public void onShow() {
        super.onShow();
        if (this.getConfig().mDuration > 0L) {
            this.getChild().postDelayed((Runnable)this, this.getConfig().mDuration);
        }
    }

    @Override
    public void onPreRemove() {
        this.getChild().removeCallbacks((Runnable)this);
        super.onPreRemove();
    }

    @Override
    public void onDetach() {
        this.getChild().setTag(null);
        super.onDetach();
    }

    @Override
    public void run() {
        if (this.isShow()) {
            this.dismiss();
        }
    }

    protected static class ListenerHolder
    extends DecorLayer.ListenerHolder {
        protected ListenerHolder() {
        }
    }

    protected static class Config
    extends DecorLayer.Config {
        private boolean mRemoveOthers = true;
        private long mDuration = 3000L;
        private CharSequence mMessage = "";
        private int mIcon = 0;
        private int mBackgroundDrawableRes = -1;
        private Drawable mBackgroundDrawable = null;
        private int mBackgroundColor = -16777216;
        private float mAlpha = 1.0f;
        private int mGravity = 81;
        private int mMarginLeft = -1;
        private int mMarginTop = -1;
        private int mMarginRight = -1;
        private int mMarginBottom = -1;

        protected Config() {
        }
    }

    public static class ViewHolder
    extends DecorLayer.ViewHolder {
        private ImageView mIcon;
        private TextView mMessage;

        @Override
        public void setChild(View child) {
            super.setChild(child);
            this.mIcon = (ImageView)child.findViewById(R.id.iv_icon);
            this.mMessage = (TextView)child.findViewById(R.id.tv_msg);
        }

        public ImageView getIcon() {
            return this.mIcon;
        }

        public TextView getMessage() {
            return this.mMessage;
        }
    }
}

