/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.upperdialog.manager;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.animation.DecelerateInterpolator;
import com.zlylib.upperdialog.utils.Utils;
import java.util.HashMap;
import java.util.Map;

public final class SoftInputHelper
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnGlobalFocusChangeListener {
    private final Window window;
    private final View rootView;
    private long duration = 300L;
    private View moveView = null;
    private Map<View, View> focusBottomMap = new HashMap<View, View>(1);
    private OnSoftInputListener onSoftInputListener = null;
    private boolean moveWithScroll = false;
    private boolean isOpened = false;
    private int moveHeight = 0;
    private boolean isFocusChange = false;
    private Runnable moveRunnable = new Runnable(){

        @Override
        public void run() {
            SoftInputHelper.this.calcToMove();
        }
    };

    public static SoftInputHelper attach(Activity activity) {
        Utils.requireNonNull(activity, "activity == null");
        return new SoftInputHelper(activity);
    }

    private SoftInputHelper(Activity activity) {
        Utils.requireNonNull(activity, "activity == null");
        this.window = activity.getWindow();
        this.rootView = this.window.getDecorView().getRootView();
        ViewTreeObserver observer = this.rootView.getViewTreeObserver();
        observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        observer.addOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this);
        this.window.setSoftInputMode(0);
    }

    public void detach() {
        if (this.rootView.getViewTreeObserver().isAlive()) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.rootView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                this.rootView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            this.rootView.getViewTreeObserver().removeOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this);
        }
    }

    public SoftInputHelper moveBy(View moveView) {
        Utils.requireNonNull(moveView, "moveView == null");
        this.moveView = moveView;
        return this;
    }

    public SoftInputHelper moveWith(View bottomView, View ... focusViews) {
        Utils.requireNonNull(bottomView, "bottomView == null");
        for (View focusView : focusViews) {
            this.focusBottomMap.put(focusView, bottomView);
        }
        return this;
    }

    public SoftInputHelper listener(OnSoftInputListener onSoftInputListener) {
        this.onSoftInputListener = onSoftInputListener;
        return this;
    }

    public SoftInputHelper duration(long duration) {
        this.duration = duration;
        return this;
    }

    public SoftInputHelper moveWithScroll() {
        this.moveWithScroll = true;
        return this;
    }

    public SoftInputHelper moveWithTranslation() {
        this.moveWithScroll = false;
        return this;
    }

    public void onGlobalLayout() {
        boolean isOpen = this.isSoftOpen();
        if (isOpen) {
            if (!this.isOpened) {
                this.isOpened = true;
                if (this.onSoftInputListener != null) {
                    this.onSoftInputListener.onOpen();
                }
            }
            if (this.moveView != null) {
                if (this.isFocusChange) {
                    this.isFocusChange = false;
                    this.rootView.removeCallbacks(this.moveRunnable);
                }
                this.calcToMove();
            }
        } else {
            if (this.isOpened) {
                this.isOpened = false;
                if (this.onSoftInputListener != null) {
                    this.onSoftInputListener.onClose();
                }
            }
            if (this.moveView != null) {
                this.moveHeight = 0;
                this.move();
            }
        }
    }

    private void calcToMove() {
        View focusView = this.isViewFocus();
        if (focusView != null) {
            View bottomView = this.focusBottomMap.get(focusView);
            if (bottomView != null) {
                Rect rect = this.getRootViewRect();
                int bottomViewY = this.getBottomViewY(bottomView);
                if (bottomViewY > rect.bottom) {
                    int offHeight = bottomViewY - rect.bottom;
                    this.moveHeight += offHeight;
                    this.move();
                } else if (bottomViewY < rect.bottom) {
                    int offHeight = -(bottomViewY - rect.bottom);
                    if (this.moveHeight > 0) {
                        this.moveHeight = this.moveHeight >= offHeight ? (this.moveHeight -= offHeight) : 0;
                        this.move();
                    }
                }
            }
        } else {
            this.moveHeight = 0;
            this.move();
        }
    }

    public void onGlobalFocusChanged(View oldFocus, View newFocus) {
        if (this.isOpened && this.moveView != null) {
            this.isFocusChange = true;
            this.rootView.postDelayed(this.moveRunnable, 100L);
        }
    }

    private int getBottomViewY(View bottomView) {
        int[] bottomLocation = new int[2];
        bottomView.getLocationOnScreen(bottomLocation);
        return bottomLocation[1] + bottomView.getHeight();
    }

    private Rect getRootViewRect() {
        Rect rect = new Rect();
        this.rootView.getWindowVisibleDisplayFrame(rect);
        return rect;
    }

    private void move() {
        if (this.moveWithScroll) {
            this.scrollTo(this.moveHeight);
        } else {
            this.translationTo(-this.moveHeight);
        }
    }

    private void translationTo(int to) {
        float translationY = this.moveView.getTranslationY();
        if (translationY == (float)to) {
            return;
        }
        ObjectAnimator anim = ObjectAnimator.ofFloat((Object)this.moveView, (String)"translationY", (float[])new float[]{translationY, to});
        anim.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        anim.setDuration(this.duration);
        anim.start();
    }

    private void scrollTo(int to) {
        int scrollY = this.moveView.getScrollY();
        if (scrollY == to) {
            return;
        }
        ObjectAnimator anim = ObjectAnimator.ofInt((Object)this.moveView, (String)"scrollY", (int[])new int[]{scrollY, to});
        anim.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        anim.setDuration(this.duration);
        anim.start();
    }

    private boolean isSoftOpen() {
        Rect rect = this.getRootViewRect();
        int usableHeightNow = rect.bottom - rect.top;
        int usableHeightSansKeyboard = this.rootView.getHeight();
        int heightDifference = usableHeightSansKeyboard - usableHeightNow;
        return heightDifference > usableHeightSansKeyboard / 4;
    }

    private View isViewFocus() {
        View focusView = this.window.getCurrentFocus();
        for (View view : this.focusBottomMap.keySet()) {
            if (focusView != view) continue;
            return view;
        }
        return null;
    }

    public static interface OnSoftInputListener {
        public void onOpen();

        public void onClose();
    }
}

