/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.upperdialog.manager;

import android.animation.Animator;
import android.content.Context;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zlylib.upperdialog.manager.ViewManager;
import com.zlylib.upperdialog.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class Layer
implements ViewManager.OnLifeListener,
ViewManager.OnKeyListener,
ViewManager.OnPreDrawListener {
    private final ViewManager mViewManager;
    private final ViewHolder mViewHolder;
    private final ListenerHolder mListenerHolder;
    private final Config mConfig = Utils.requireNonNull(this.onCreateConfig(), "onCreateConfig() == null");
    private SparseArray<View> mViewCaches = null;
    private boolean mShowWithAnim = false;
    private boolean mDismissWithAnim = false;
    private Animator mAnimatorIn = null;
    private Animator mAnimatorOut = null;
    private boolean mInitialized = false;

    public Layer() {
        this.mViewHolder = Utils.requireNonNull(this.onCreateViewHolder(), "onCreateViewHolder() == null");
        this.mListenerHolder = Utils.requireNonNull(this.onCreateListenerHolder(), "onCreateListenerHolder() == null");
        this.mViewManager = new ViewManager();
        this.mViewManager.setOnLifeListener(this);
        this.mViewManager.setOnPreDrawListener(this);
    }

    public ViewHolder getViewHolder() {
        Utils.requireNonNull(this.mViewHolder, "mViewHolder == null");
        return this.mViewHolder;
    }

    public Config getConfig() {
        Utils.requireNonNull(this.mConfig, "mConfig == null");
        return this.mConfig;
    }

    public ListenerHolder getListenerHolder() {
        Utils.requireNonNull(this.mListenerHolder, "mListenerHolder == null");
        return this.mListenerHolder;
    }

    protected Config onCreateConfig() {
        return new Config();
    }

    protected ViewHolder onCreateViewHolder() {
        return new ViewHolder();
    }

    protected ListenerHolder onCreateListenerHolder() {
        return new ListenerHolder();
    }

    protected ViewGroup onGetParent() {
        return this.mViewHolder.getParent();
    }

    protected View onCreateChild(LayoutInflater inflater, ViewGroup parent) {
        if (this.mViewHolder.getChild() == null) {
            this.mViewHolder.setChild(inflater.inflate(this.mConfig.mChildId, parent, false));
        }
        return this.mViewHolder.getChild();
    }

    protected Animator onCreateInAnimator(View view) {
        Utils.requireNonNull(view, "view == null");
        if (this.mConfig.mAnimatorCreator == null) {
            return null;
        }
        return this.mConfig.mAnimatorCreator.createInAnimator(view);
    }

    protected Animator onCreateOutAnimator(View view) {
        Utils.requireNonNull(view, "view == null");
        if (this.mConfig.mAnimatorCreator == null) {
            return null;
        }
        return this.mConfig.mAnimatorCreator.createOutAnimator(view);
    }

    @Override
    public void onAttach() {
        this.getViewHolder().getChild().setVisibility(0);
        this.mListenerHolder.bindClickListeners(this);
        this.mListenerHolder.notifyVisibleChangeOnShow(this);
        if (!this.mInitialized) {
            this.mInitialized = true;
            this.mListenerHolder.notifyOnInitialize(this);
        }
        this.mListenerHolder.notifyDataBinder(this);
    }

    @Override
    public void onPreDraw() {
        this.mListenerHolder.notifyLayerOnShowing(this);
        this.cancelAnimator();
        if (this.mShowWithAnim) {
            this.mAnimatorIn = this.onCreateInAnimator(this.mViewManager.getChild());
            if (this.mAnimatorIn != null) {
                this.mAnimatorIn.addListener(new Animator.AnimatorListener(){
                    private boolean beenCanceled = false;

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        if (!this.beenCanceled) {
                            Layer.this.onShow();
                        }
                    }

                    public void onAnimationCancel(Animator animation) {
                        this.beenCanceled = true;
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                this.mAnimatorIn.start();
            } else {
                this.onShow();
            }
        } else {
            this.onShow();
        }
    }

    public void onShow() {
        this.mListenerHolder.notifyLayerOnShown(this);
        if (this.mAnimatorIn != null) {
            this.mAnimatorIn = null;
        }
    }

    public void onPreRemove() {
        this.mListenerHolder.notifyLayerOnDismissing(this);
        this.cancelAnimator();
        if (this.mDismissWithAnim) {
            this.mAnimatorOut = this.onCreateOutAnimator(this.mViewManager.getChild());
            if (this.mAnimatorOut != null) {
                this.mAnimatorOut.addListener(new Animator.AnimatorListener(){
                    private boolean beenCanceled = false;

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        if (!this.beenCanceled) {
                            Layer.this.getViewHolder().getChild().setVisibility(4);
                            Layer.this.getViewHolder().getChild().post(new Runnable(){

                                @Override
                                public void run() {
                                    Layer.this.mViewManager.detach();
                                }
                            });
                        }
                    }

                    public void onAnimationCancel(Animator animation) {
                        this.beenCanceled = true;
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                this.mAnimatorOut.start();
            } else {
                this.mViewManager.detach();
            }
        } else {
            this.mViewManager.detach();
        }
    }

    @Override
    public void onDetach() {
        this.mListenerHolder.notifyVisibleChangeOnDismiss(this);
        this.mListenerHolder.notifyLayerOnDismissed(this);
        if (this.mAnimatorOut != null) {
            this.mAnimatorOut = null;
        }
    }

    private void cancelAnimator() {
        if (this.mAnimatorIn != null) {
            this.mAnimatorIn.cancel();
            this.mAnimatorIn = null;
        }
        if (this.mAnimatorOut != null) {
            this.mAnimatorOut.cancel();
            this.mAnimatorOut = null;
        }
    }

    @Override
    public boolean onKey(int keyCode, KeyEvent event) {
        if (event.getAction() == 0 && keyCode == 4) {
            if (this.mConfig.mCancelableOnKeyBack) {
                this.dismiss();
            }
            return true;
        }
        return false;
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean withAnim) {
        if (this.isShow()) {
            return;
        }
        this.mShowWithAnim = withAnim;
        this.mViewHolder.setParent(this.onGetParent());
        View view = this.onCreateChild(LayoutInflater.from((Context)this.mViewHolder.getParent().getContext()), this.mViewHolder.getParent());
        this.mViewHolder.setChild(Utils.requireNonNull(view, "onCreateChild() == null"));
        this.mViewManager.setParent(this.mViewHolder.getParent());
        this.mViewManager.setChild(this.mViewHolder.getChild());
        this.mViewManager.setOnKeyListener(this.mConfig.mInterceptKeyEvent ? this : null);
        this.mViewManager.attach();
    }

    public void dismiss() {
        this.dismiss(true);
    }

    public void dismiss(boolean withAnim) {
        if (!this.isShow()) {
            return;
        }
        this.mDismissWithAnim = withAnim;
        this.onPreRemove();
    }

    public boolean isShow() {
        return this.mViewManager.isAttached();
    }

    public ViewManager getViewManager() {
        return this.mViewManager;
    }

    public ViewGroup getParent() {
        return this.mViewHolder.getParent();
    }

    public View getChild() {
        return this.mViewHolder.getChild();
    }

    public <V extends View> V getView(int id2) {
        if (this.mViewCaches == null) {
            this.mViewCaches = new SparseArray();
        }
        if (this.mViewCaches.indexOfKey(id2) < 0) {
            View view = this.getChild().findViewById(id2);
            this.mViewCaches.put(id2, (Object)view);
            return (V)view;
        }
        return (V)((View)this.mViewCaches.get(id2));
    }

    public Layer parent(ViewGroup parent) {
        Utils.requireNonNull(parent, "parent == null");
        this.mViewHolder.setParent(parent);
        return this;
    }

    public Layer child(View child) {
        Utils.requireNonNull(child, "child == null");
        this.mViewHolder.setChild(child);
        return this;
    }

    public Layer child(int child) {
        this.mConfig.mChildId = child;
        return this;
    }

    public Layer animator(AnimatorCreator creator) {
        this.mConfig.mAnimatorCreator = creator;
        return this;
    }

    public Layer interceptKeyEvent(boolean intercept) {
        this.mConfig.mInterceptKeyEvent = intercept;
        return this;
    }

    public Layer cancelableOnKeyBack(boolean cancelable) {
        if (cancelable) {
            this.interceptKeyEvent(true);
        }
        this.mConfig.mCancelableOnKeyBack = cancelable;
        return this;
    }

    public Layer bindData(DataBinder dataBinder) {
        this.mListenerHolder.addDataBinder(dataBinder);
        return this;
    }

    public Layer onInitialize(OnInitialize onInitialize) {
        this.mListenerHolder.addOnInitialize(onInitialize);
        return this;
    }

    public Layer onVisibleChangeListener(OnVisibleChangeListener onVisibleChangeListener) {
        this.mListenerHolder.addOnVisibleChangeListener(onVisibleChangeListener);
        return this;
    }

    public Layer onShowListener(OnShowListener onShowListener) {
        this.mListenerHolder.addOnLayerShowListener(onShowListener);
        return this;
    }

    public Layer onDismissListener(OnDismissListener onDismissListener) {
        this.mListenerHolder.addOnLayerDismissListener(onDismissListener);
        return this;
    }

    public Layer onClickToDismiss(final OnClickListener listener, int ... viewIds) {
        this.onClick(new OnClickListener(){

            @Override
            public void onClick(Layer decorLayer, View v) {
                if (listener != null) {
                    listener.onClick(decorLayer, v);
                }
                Layer.this.dismiss();
            }
        }, viewIds);
        return this;
    }

    public Layer onClickToDismiss(int ... viewIds) {
        this.onClick(new OnClickListener(){

            @Override
            public void onClick(Layer decorLayer, View v) {
                Layer.this.dismiss();
            }
        }, viewIds);
        return this;
    }

    public Layer onClick(OnClickListener listener, int ... viewIds) {
        this.mListenerHolder.addOnClickListener(listener, viewIds);
        return this;
    }

    public static interface OnVisibleChangeListener {
        public void onShow(Layer var1);

        public void onDismiss(Layer var1);
    }

    public static interface OnShowListener {
        public void onShowing(Layer var1);

        public void onShown(Layer var1);
    }

    public static interface OnDismissListener {
        public void onDismissing(Layer var1);

        public void onDismissed(Layer var1);
    }

    public static interface OnClickListener {
        public void onClick(Layer var1, View var2);
    }

    public static interface OnInitialize {
        public void onInit(Layer var1);
    }

    public static interface DataBinder {
        public void bindData(Layer var1);
    }

    public static interface AnimatorCreator {
        public Animator createInAnimator(View var1);

        public Animator createOutAnimator(View var1);
    }

    protected static class ListenerHolder {
        private SparseArray<OnClickListener> mOnClickListeners = null;
        private List<OnInitialize> mOnInitializes = null;
        private List<DataBinder> mDataBinders = null;
        private List<OnVisibleChangeListener> mOnVisibleChangeListeners = null;
        private List<OnShowListener> mOnShowListeners = null;
        private List<OnDismissListener> mOnDismissListeners = null;

        protected ListenerHolder() {
        }

        private void bindClickListeners(final Layer layer) {
            Utils.requireNonNull(layer, "layer == null");
            if (this.mOnClickListeners == null) {
                return;
            }
            for (int i = 0; i < this.mOnClickListeners.size(); ++i) {
                int viewId = this.mOnClickListeners.keyAt(i);
                final OnClickListener listener = (OnClickListener)this.mOnClickListeners.valueAt(i);
                layer.getView(viewId).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        listener.onClick(layer, v);
                    }
                });
            }
        }

        public void addOnClickListener(OnClickListener listener, int ... viewIds) {
            if (this.mOnClickListeners == null) {
                this.mOnClickListeners = new SparseArray();
            }
            if (viewIds != null && viewIds.length > 0) {
                for (int id2 : viewIds) {
                    if (this.mOnClickListeners.indexOfKey(id2) >= 0) continue;
                    this.mOnClickListeners.put(id2, (Object)listener);
                }
            }
        }

        private void addDataBinder(DataBinder dataBinder) {
            if (this.mDataBinders == null) {
                this.mDataBinders = new ArrayList<DataBinder>(1);
            }
            this.mDataBinders.add(dataBinder);
        }

        private void addOnInitialize(OnInitialize onInitialize) {
            if (this.mOnInitializes == null) {
                this.mOnInitializes = new ArrayList<OnInitialize>(1);
            }
            this.mOnInitializes.add(onInitialize);
        }

        private void addOnVisibleChangeListener(OnVisibleChangeListener onVisibleChangeListener) {
            if (this.mOnVisibleChangeListeners == null) {
                this.mOnVisibleChangeListeners = new ArrayList<OnVisibleChangeListener>(1);
            }
            this.mOnVisibleChangeListeners.add(onVisibleChangeListener);
        }

        private void addOnLayerShowListener(OnShowListener onShowListener) {
            if (this.mOnShowListeners == null) {
                this.mOnShowListeners = new ArrayList<OnShowListener>(1);
            }
            this.mOnShowListeners.add(onShowListener);
        }

        private void addOnLayerDismissListener(OnDismissListener onDismissListener) {
            if (this.mOnDismissListeners == null) {
                this.mOnDismissListeners = new ArrayList<OnDismissListener>(1);
            }
            this.mOnDismissListeners.add(onDismissListener);
        }

        private void notifyDataBinder(Layer layer) {
            Utils.requireNonNull(layer, "layer == null");
            if (this.mDataBinders != null) {
                for (DataBinder dataBinder : this.mDataBinders) {
                    dataBinder.bindData(layer);
                }
            }
        }

        private void notifyOnInitialize(Layer layer) {
            Utils.requireNonNull(layer, "layer == null");
            if (this.mOnInitializes != null) {
                for (OnInitialize onInitialize : this.mOnInitializes) {
                    onInitialize.onInit(layer);
                }
            }
        }

        private void notifyVisibleChangeOnShow(Layer layer) {
            Utils.requireNonNull(layer, "layer == null");
            if (this.mOnVisibleChangeListeners != null) {
                for (OnVisibleChangeListener onVisibleChangeListener : this.mOnVisibleChangeListeners) {
                    onVisibleChangeListener.onShow(layer);
                }
            }
        }

        private void notifyVisibleChangeOnDismiss(Layer layer) {
            Utils.requireNonNull(layer, "layer == null");
            if (this.mOnVisibleChangeListeners != null) {
                for (OnVisibleChangeListener onVisibleChangeListener : this.mOnVisibleChangeListeners) {
                    onVisibleChangeListener.onDismiss(layer);
                }
            }
        }

        private void notifyLayerOnShowing(Layer layer) {
            Utils.requireNonNull(layer, "layer == null");
            if (this.mOnShowListeners != null) {
                for (OnShowListener onShowListener : this.mOnShowListeners) {
                    onShowListener.onShowing(layer);
                }
            }
        }

        private void notifyLayerOnShown(Layer layer) {
            Utils.requireNonNull(layer, "layer == null");
            if (this.mOnShowListeners != null) {
                for (OnShowListener onShowListener : this.mOnShowListeners) {
                    onShowListener.onShown(layer);
                }
            }
        }

        private void notifyLayerOnDismissing(Layer layer) {
            Utils.requireNonNull(layer, "layer == null");
            if (this.mOnDismissListeners != null) {
                for (OnDismissListener onDismissListener : this.mOnDismissListeners) {
                    onDismissListener.onDismissing(layer);
                }
            }
        }

        private void notifyLayerOnDismissed(Layer layer) {
            Utils.requireNonNull(layer, "layer == null");
            if (this.mOnDismissListeners != null) {
                for (OnDismissListener onDismissListener : this.mOnDismissListeners) {
                    onDismissListener.onDismissed(layer);
                }
            }
        }
    }

    public static class ViewHolder {
        private ViewGroup mParent;
        private View mChild;

        public void setParent(ViewGroup parent) {
            this.mParent = Utils.requireNonNull(parent, "parent == null");
        }

        public ViewGroup getParent() {
            return Utils.requireNonNull(this.mParent, "parent == null, You have to call it after the show method");
        }

        public void setChild(View child) {
            this.mChild = Utils.requireNonNull(child, "child == null");
        }

        public View getChild() {
            return Utils.requireNonNull(this.mChild, "child == null, You have to call it after the show method");
        }
    }

    protected static class Config {
        private int mChildId;
        private boolean mInterceptKeyEvent = true;
        private boolean mCancelableOnKeyBack = true;
        private AnimatorCreator mAnimatorCreator = null;

        protected Config() {
        }
    }
}

