/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.upperdialog.manager;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.zlylib.upperdialog.manager.Layer;
import com.zlylib.upperdialog.utils.Utils;

public class DecorLayer
extends Layer
implements ComponentCallbacks,
ViewTreeObserver.OnGlobalLayoutListener {
    private final Activity mActivity;

    public DecorLayer(Activity activity) {
        Utils.requireNonNull(activity, "activity == null");
        this.mActivity = activity;
        this.getViewHolder().setDecor((FrameLayout)activity.getWindow().getDecorView());
    }

    protected Level getLevel() {
        return Level.DIALOG;
    }

    public Activity getActivity() {
        Utils.requireNonNull(this.mActivity, "activity == null");
        return this.mActivity;
    }

    @Override
    protected ViewHolder onCreateViewHolder() {
        return new ViewHolder();
    }

    @Override
    public ViewHolder getViewHolder() {
        return (ViewHolder)super.getViewHolder();
    }

    @Override
    protected Config onCreateConfig() {
        return new Config();
    }

    @Override
    public Config getConfig() {
        return (Config)super.getConfig();
    }

    @Override
    protected ListenerHolder onCreateListenerHolder() {
        return new ListenerHolder();
    }

    @Override
    public ListenerHolder getListenerHolder() {
        return (ListenerHolder)super.getListenerHolder();
    }

    @Override
    protected ViewGroup onGetParent() {
        LayerLayout group = this.findLayerLayoutFromDecor();
        if (group == null) {
            group = this.addNewLayerLayoutToDecor();
        }
        LevelLayout parent = null;
        int lastIndex = -1;
        int count = group.getChildCount();
        for (int i = 0; i < count; ++i) {
            lastIndex = i;
            View child = group.getChildAt(i);
            if (!(child instanceof LevelLayout)) continue;
            LevelLayout levelLayout = (LevelLayout)child;
            if (this.getLevel() == levelLayout.getLevel()) {
                parent = levelLayout;
                break;
            }
            if (this.getLevel().level() <= levelLayout.getLevel().level()) continue;
            --lastIndex;
            break;
        }
        if (parent == null) {
            parent = new LevelLayout(group.getContext(), this.getLevel());
            parent.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            group.addView((View)parent, lastIndex + 1);
        }
        this.getViewHolder().setParent((ViewGroup)parent);
        return parent;
    }

    @Override
    public void onAttach() {
        super.onAttach();
        this.getActivity().registerComponentCallbacks((ComponentCallbacks)this);
        this.getViewHolder().getDecor().getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    @Override
    public void onPreDraw() {
        super.onPreDraw();
    }

    @Override
    public void onShow() {
        super.onShow();
    }

    @Override
    public void onPreRemove() {
        super.onPreRemove();
    }

    @Override
    public void onDetach() {
        this.getViewHolder().getDecor().getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.getActivity().unregisterComponentCallbacks((ComponentCallbacks)this);
        super.onDetach();
        LayerLayout group = this.findLayerLayoutFromDecor();
        if (group == null) {
            return;
        }
        LevelLayout parent = this.findLevelLayoutFromGroup(group);
        if (parent == null) {
            return;
        }
        if (parent.getChildCount() == 0) {
            group.removeView((View)parent);
        }
        if (group.getChildCount() == 0) {
            this.removeLayerLayoutFromDecor(group);
        }
    }

    public void onGlobalLayout() {
        FrameLayout decor = this.getViewHolder().getDecor();
        int count = decor.getChildCount();
        if (count < 2) {
            return;
        }
        LayerLayout layerLayout = this.findLayerLayoutFromDecor();
        if (layerLayout == null) {
            return;
        }
        int index = decor.indexOfChild((View)layerLayout);
        if (index < 0) {
            return;
        }
        if (index == count - 1) {
            return;
        }
        layerLayout.bringToFront();
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onLowMemory() {
    }

    private LayerLayout findLayerLayoutFromDecor() {
        int count;
        FrameLayout decor = this.getViewHolder().getDecor();
        LayerLayout layerLayout = null;
        for (int i = count = decor.getChildCount(); i >= 0; --i) {
            View child = decor.getChildAt(i);
            if (!(child instanceof LayerLayout)) continue;
            layerLayout = (LayerLayout)child;
            break;
        }
        return layerLayout;
    }

    private LevelLayout findLevelLayoutFromGroup(LayerLayout group) {
        LevelLayout parent = null;
        int count = group.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = group.getChildAt(i);
            if (!(child instanceof LevelLayout)) continue;
            LevelLayout levelLayout = (LevelLayout)child;
            if (this.getLevel() != levelLayout.getLevel()) continue;
            parent = levelLayout;
            break;
        }
        return parent;
    }

    private LayerLayout addNewLayerLayoutToDecor() {
        FrameLayout decor = this.getViewHolder().mDecor;
        LayerLayout layerLayout = new LayerLayout(decor.getContext());
        layerLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        decor.addView((View)layerLayout, decor.getChildCount());
        return layerLayout;
    }

    private void removeLayerLayoutFromDecor(LayerLayout layerLayout) {
        FrameLayout decor = this.getViewHolder().mDecor;
        decor.removeView((View)layerLayout);
    }

    public DecorLayer cancelableOnClickKeyBack(boolean cancelable) {
        this.cancelableOnKeyBack(cancelable);
        return this;
    }

    @SuppressLint(value={"ViewConstructor"})
    public static class LevelLayout
    extends FrameLayout {
        private final Level mLevel;

        public LevelLayout(Context context, Level level) {
            super(context);
            this.mLevel = level;
        }

        public Level getLevel() {
            return this.mLevel;
        }
    }

    @SuppressLint(value={"ViewConstructor"})
    public static class LayerLayout
    extends FrameLayout {
        public LayerLayout(Context context) {
            super(context);
        }
    }

    protected static enum Level {
        FLOAT(1),
        TOAST(2),
        DIALOG(3),
        POPUP(4),
        GUIDE(5);

        private final int level;

        private Level(int level) {
            this.level = level;
        }

        public int level() {
            return this.level;
        }

        public boolean isTopThan(Level other) {
            return this.level < other.level;
        }
    }

    protected static class ListenerHolder
    extends Layer.ListenerHolder {
        protected ListenerHolder() {
        }
    }

    protected static class Config
    extends Layer.Config {
        protected Config() {
        }
    }

    public static class ViewHolder
    extends Layer.ViewHolder {
        private FrameLayout mDecor;

        public void setDecor(FrameLayout decor) {
            this.mDecor = decor;
        }

        public FrameLayout getDecor() {
            return this.mDecor;
        }

        public LevelLayout getParent() {
            return (LevelLayout)super.getParent();
        }
    }
}

