/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.upperdialog.manager;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.text.TextUtils;
import com.zlylib.upperdialog.utils.Utils;
import java.util.LinkedList;
import java.util.List;

public final class ActivityHolder
implements Application.ActivityLifecycleCallbacks {
    private static ActivityHolder INSTANCE = null;
    private final Application mApplication;
    private final List<Activity> mActivityStack = new LinkedList<Activity>();

    private ActivityHolder(Application application) {
        this.mApplication = Utils.requireNonNull(application, "application == null");
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public static void init(Application application) {
        if (INSTANCE == null) {
            INSTANCE = new ActivityHolder(application);
        }
    }

    public static Application getApplication() {
        if (INSTANCE == null) {
            return null;
        }
        return ActivityHolder.INSTANCE.mApplication;
    }

    public static Activity getActivity(Class<Activity> clazz) {
        Utils.requireNonNull(clazz, "clazz == null");
        if (INSTANCE == null) {
            return null;
        }
        if (ActivityHolder.INSTANCE.mActivityStack.isEmpty()) {
            return null;
        }
        int size = ActivityHolder.INSTANCE.mActivityStack.size();
        for (int i = size - 1; i >= 0; --i) {
            Activity activity = ActivityHolder.INSTANCE.mActivityStack.get(i);
            if (!TextUtils.equals((CharSequence)clazz.getName(), (CharSequence)activity.getClass().getName())) continue;
            return activity;
        }
        return null;
    }

    public static Activity getCurrentActivity() {
        if (INSTANCE == null) {
            return null;
        }
        if (ActivityHolder.INSTANCE.mActivityStack.isEmpty()) {
            return null;
        }
        return ActivityHolder.INSTANCE.mActivityStack.get(ActivityHolder.INSTANCE.mActivityStack.size() - 1);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.mActivityStack.add(activity);
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.mActivityStack.remove(activity);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }
}

