/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.titlebarlib.widget;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.CallSuper;
import androidx.annotation.ColorInt;
import androidx.annotation.IdRes;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import com.zlylib.titlebarlib.R;
import com.zlylib.titlebarlib.widget.StatusBarView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import per.goweii.statusbarcompat.StatusBarCompat;

public class ActionBarEx
extends FrameLayout {
    private int mImmersion = 0;
    private int mStatusBarVisible = 0;
    private int mStatusBarMode = 0;
    @ColorInt
    private int mStatusBarColor = 0;
    private int mTitleBarHeight = -1;
    private int mTitleBarLayoutRes = 0;
    @ColorInt
    private int mBottomLineColor = 0;
    private int mBottomLineResId = 0;
    private int mBottomLineHeight = 0;
    private boolean mBottomLineOutside = false;
    private int mForegroundLayerLayoutRes = 0;
    private int mBackgroundLayerLayoutRes = 0;
    private int mBackgroundLayerImageRes = 0;
    private int mClickToFinishViewId = 0;
    private Activity mActivity = null;
    private LinearLayout mActionBar;
    private StatusBarView mStatusBar;
    private FrameLayout mTitleBar;
    private View mBottomLine;
    private View mForegroundLayer;
    private View mBackgroundLayer;
    private SparseArray<View> views = null;

    public ActionBarEx(Context context) {
        this(context, null);
    }

    public ActionBarEx(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ActionBarEx(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.hintSystemActionBar();
        this.initAttrs(attrs);
        this.initView();
        this.refresh();
    }

    @CallSuper
    protected void initAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ActionBarEx);
        this.mImmersion = typedArray.getInt(R.styleable.ActionBarEx_ab_immersion, this.mImmersion);
        this.mBackgroundLayerLayoutRes = typedArray.getResourceId(R.styleable.ActionBarEx_ab_backgroundLayerLayout, this.mBackgroundLayerLayoutRes);
        this.mBackgroundLayerImageRes = typedArray.getResourceId(R.styleable.ActionBarEx_ab_backgroundLayerImageRes, this.mBackgroundLayerLayoutRes);
        this.mStatusBarVisible = typedArray.getInt(R.styleable.ActionBarEx_ab_statusBarVisible, this.mStatusBarVisible);
        this.mStatusBarMode = typedArray.getInt(R.styleable.ActionBarEx_ab_statusBarMode, this.mStatusBarMode);
        this.mStatusBarColor = typedArray.getColor(R.styleable.ActionBarEx_ab_statusBarColor, this.mStatusBarColor);
        this.mTitleBarHeight = (int)typedArray.getDimension(R.styleable.ActionBarEx_ab_titleBarHeight, (float)this.mTitleBarHeight);
        this.mTitleBarLayoutRes = typedArray.getResourceId(R.styleable.ActionBarEx_ab_titleBarLayout, this.mTitleBarLayoutRes);
        this.mBottomLineHeight = (int)typedArray.getDimension(R.styleable.ActionBarEx_ab_bottomLineHeight, (float)this.mBottomLineHeight);
        this.mBottomLineColor = typedArray.getColor(R.styleable.ActionBarEx_ab_bottomLineColor, this.mBottomLineColor);
        this.mBottomLineResId = typedArray.getResourceId(R.styleable.ActionBarEx_ab_bottomLineResId, this.mBottomLineResId);
        this.mBottomLineOutside = typedArray.getBoolean(R.styleable.ActionBarEx_ab_bottomLineOutside, this.mBottomLineOutside);
        this.mForegroundLayerLayoutRes = typedArray.getResourceId(R.styleable.ActionBarEx_ab_foregroundLayerLayout, this.mForegroundLayerLayoutRes);
        this.mClickToFinishViewId = typedArray.getResourceId(R.styleable.ActionBarEx_ab_clickToFinish, this.mClickToFinishViewId);
        typedArray.recycle();
    }

    @CallSuper
    protected void initView() {
        if (this.mBackgroundLayerLayoutRes > 0) {
            this.mBackgroundLayer = ActionBarEx.inflate((Context)this.getContext(), (int)this.mBackgroundLayerLayoutRes, null);
            this.addViewInLayout(this.mBackgroundLayer, this.getChildCount(), (ViewGroup.LayoutParams)this.makeLayerLayoutParamsMatch(), true);
        } else if (this.mBackgroundLayerImageRes > 0) {
            ImageView actionBarImageView = new ImageView(this.getContext());
            this.mBackgroundLayer = actionBarImageView;
            this.addViewInLayout(this.mBackgroundLayer, this.getChildCount(), (ViewGroup.LayoutParams)this.makeLayerLayoutParamsMatch(), true);
            actionBarImageView.setImageResource(this.mBackgroundLayerImageRes);
            actionBarImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        }
        this.mActionBar = (LinearLayout)ActionBarEx.inflate((Context)this.getContext(), (int)R.layout.actionbarex_action_bar, null);
        this.addViewInLayout((View)this.mActionBar, this.getChildCount(), (ViewGroup.LayoutParams)this.makeLayerLayoutParamsWrap(), true);
        this.mStatusBar = (StatusBarView)this.mActionBar.findViewById(R.id.actionbarex_status_bar);
        this.mTitleBar = (FrameLayout)this.mActionBar.findViewById(R.id.actionbarex_title_bar);
        this.mTitleBar.setClickable(true);
        this.mTitleBar.setFocusable(true);
        this.mTitleBar.setFocusableInTouchMode(true);
        if (this.mTitleBarHeight >= 0) {
            this.mTitleBar.getLayoutParams().height = this.mTitleBarHeight;
        }
        this.setTitleBarChild(this.inflateTitleBar());
        this.mBottomLine = this.mActionBar.findViewById(R.id.actionbarex_bottom_line);
        this.mBottomLine.getLayoutParams().height = this.mBottomLineHeight;
        if (this.mBottomLineResId > 0) {
            this.mBottomLine.setBackgroundResource(this.mBottomLineResId);
        } else {
            this.mBottomLine.setBackgroundColor(this.mBottomLineColor);
        }
        if (this.mBottomLineOutside) {
            this.mActionBar.setClipChildren(false);
            this.setClipChildren(false);
        }
        if (this.mForegroundLayerLayoutRes > 0) {
            this.mForegroundLayer = ActionBarEx.inflate((Context)this.getContext(), (int)this.mForegroundLayerLayoutRes, null);
            this.addViewInLayout(this.mForegroundLayer, this.getChildCount(), (ViewGroup.LayoutParams)this.makeLayerLayoutParamsMatch(), true);
        }
        this.performClickToFinish();
    }

    protected View inflateTitleBar() {
        if (this.getTitleBarRes() > 0) {
            return LayoutInflater.from((Context)this.getContext()).inflate(this.getTitleBarRes(), (ViewGroup)this.mTitleBar, false);
        }
        return null;
    }

    protected int getTitleBarRes() {
        return this.mTitleBarLayoutRes;
    }

    protected void onAttachedToWindow() {
        ViewParent parent;
        super.onAttachedToWindow();
        if (this.mBottomLineOutside && (parent = this.getParent()) instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)parent;
            viewGroup.setClipChildren(false);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child == this.mForegroundLayer || child == this.mActionBar || child == this.mBackgroundLayer) continue;
            this.removeView(child);
            this.mTitleBar.addView(child, 0);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mActionBar.measure(widthMeasureSpec, heightMeasureSpec);
        int width = this.mActionBar.getMeasuredWidth();
        int height = this.mBottomLineOutside ? this.mStatusBar.getMeasuredHeight() + this.mTitleBar.getMeasuredHeight() : this.mActionBar.getMeasuredHeight();
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        super.onMeasure(widthSpec, heightSpec);
    }

    public View getBackgroundLayer() {
        return this.mBackgroundLayer;
    }

    public LinearLayout getActionBar() {
        return this.mActionBar;
    }

    public StatusBarView getStatusBar() {
        return this.mStatusBar;
    }

    public FrameLayout getTitleBar() {
        return this.mTitleBar;
    }

    public View getBottomLine() {
        return this.mBottomLine;
    }

    public View getForegroundLayer() {
        return this.mForegroundLayer;
    }

    public void setTitleBarChild(View titleBarChild) {
        this.mTitleBar.removeAllViewsInLayout();
        if (titleBarChild != null) {
            ViewGroup.LayoutParams titleBarChildParams = titleBarChild.getLayoutParams();
            if (titleBarChildParams == null) {
                titleBarChildParams = new LinearLayout.LayoutParams(-1, -2);
            }
            if (this.mTitleBarHeight >= 0) {
                titleBarChildParams.height = -1;
            }
            this.mTitleBar.addView(titleBarChild, titleBarChildParams);
        }
    }

    public <V extends View> V getView(@IdRes int id2) {
        View view;
        if (this.views == null) {
            this.views = new SparseArray();
        }
        if ((view = (View)this.views.get(id2)) == null) {
            view = this.findViewById(id2);
            this.views.put(id2, (Object)view);
        }
        return (V)view;
    }

    public void setImmersion(int immersion) {
        this.mImmersion = immersion;
    }

    public void setStatusBarVisible(int statusBarVisible) {
        this.mStatusBarVisible = statusBarVisible;
    }

    public void setStatusBarMode(int statusBarMode) {
        this.mStatusBarMode = statusBarMode;
    }

    public void setStatusBarColor(@ColorInt int statusBarColor) {
        this.mStatusBarColor = statusBarColor;
    }

    public void refresh() {
        this.refreshImmersion();
        this.refreshStatusBarVisible();
        this.refreshStatusBarMode();
        this.refreshStatusBarColor();
    }

    public void refreshImmersion() {
        switch (this.mImmersion) {
            case 1: {
                StatusBarCompat.unTransparent((Context)this.getContext());
                break;
            }
            case 2: {
                StatusBarCompat.transparent((Context)this.getContext());
                break;
            }
        }
    }

    public void refreshStatusBarVisible() {
        switch (this.mStatusBarVisible) {
            case 0: {
                this.mStatusBar.setVisibility(StatusBarCompat.isTransparent((Context)this.getContext()));
                break;
            }
            case 1: {
                this.mStatusBar.setVisibility(true);
                break;
            }
            case 2: {
                this.mStatusBar.setVisibility(false);
                break;
            }
        }
    }

    public void refreshStatusBarMode() {
        StatusBarCompat.unregisterToAutoChangeIconMode((Context)this.getContext());
        switch (this.mStatusBarMode) {
            case 1: {
                StatusBarCompat.setIconMode((Context)this.getContext(), (boolean)false);
                break;
            }
            case 2: {
                StatusBarCompat.setIconMode((Context)this.getContext(), (boolean)true);
                break;
            }
            case 3: {
                this.refreshStatusBarModeAuto();
                break;
            }
            case 4: {
                StatusBarCompat.registerToAutoChangeIconMode((Context)this.getContext());
                break;
            }
        }
    }

    private void refreshStatusBarModeAuto() {
        this.post(new Runnable(){

            @Override
            public void run() {
                StatusBarCompat.setIconModeAuto((Context)ActionBarEx.this.getContext());
            }
        });
    }

    public void refreshStatusBarColor() {
        this.mStatusBar.setBackgroundColor(this.mStatusBarColor);
        if (StatusBarCompat.isTransparent((Context)this.getContext()) && this.mStatusBar.isVisibility()) {
            StatusBarCompat.setColor((Context)this.getContext(), (int)0);
        } else {
            StatusBarCompat.setColor((Context)this.getContext(), (int)this.mStatusBarColor);
        }
    }

    public boolean isStatusBarIconDark() {
        return StatusBarCompat.isIconDark((Context)this.getContext());
    }

    public boolean isStatusBarBgLight() {
        return StatusBarCompat.isBgLight((Context)this.getContext());
    }

    public double calculateStatusBarBgLuminance() {
        return StatusBarCompat.calcBgLuminance((Context)this.getContext());
    }

    public void finishActivity() {
        Activity activity = this.getActivity();
        if (activity != null && !activity.isFinishing()) {
            activity.finish();
        }
    }

    private void performClickToFinish() {
        Object clickToFinishView = this.getView(this.mClickToFinishViewId);
        if (clickToFinishView == null) {
            return;
        }
        clickToFinishView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ActionBarEx.this.finishActivity();
            }
        });
    }

    private FrameLayout.LayoutParams makeLayerLayoutParamsWrap() {
        return new FrameLayout.LayoutParams(-1, -2);
    }

    private FrameLayout.LayoutParams makeLayerLayoutParamsMatch() {
        return new FrameLayout.LayoutParams(-1, -1);
    }

    private void hintSystemActionBar() {
        AppCompatActivity compatActivity;
        Activity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        if (activity.getActionBar() != null) {
            activity.getActionBar().hide();
        }
        if (activity instanceof AppCompatActivity && (compatActivity = (AppCompatActivity)activity).getSupportActionBar() != null) {
            compatActivity.getSupportActionBar().hide();
        }
    }

    @Nullable
    private Activity getActivity() {
        Context baseContext;
        if (this.mActivity != null) {
            return this.mActivity;
        }
        Context context = this.getContext();
        if (context instanceof Activity) {
            this.mActivity = (Activity)context;
        }
        if (context instanceof ContextWrapper && (baseContext = ((ContextWrapper)context).getBaseContext()) instanceof Activity) {
            this.mActivity = (Activity)baseContext;
        }
        return this.mActivity;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Immersion {
        public static final int UNCHANGED = 0;
        public static final int ORDINARY = 1;
        public static final int IMMERSED = 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StatusBarVisible {
        public static final int AUTO = 0;
        public static final int VISIBLE = 1;
        public static final int GONE = 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StatusBarMode {
        public static final int UNCHANGED = 0;
        public static final int LIGHT = 1;
        public static final int DARK = 2;
        public static final int AUTO = 3;
        public static final int REAL_TIME = 4;
    }
}

