/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.titlebarlib;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.IBinder;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import java.lang.reflect.Field;

public class ScreenUtils {
    public static float dp2Px(Context context, float dp) {
        if (context == null) {
            return -1.0f;
        }
        return dp * ScreenUtils.density(context);
    }

    public static float px2Dp(Context context, float px) {
        if (context == null) {
            return -1.0f;
        }
        return px / ScreenUtils.density(context);
    }

    public static float density(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public static int dp2PxInt(Context context, float dp) {
        return (int)(ScreenUtils.dp2Px(context, dp) + 0.5f);
    }

    public static float px2DpCeilInt(Context context, float px) {
        return (int)(ScreenUtils.px2Dp(context, px) + 0.5f);
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        Activity activity = !(context instanceof Activity) && context instanceof ContextWrapper ? (Activity)((ContextWrapper)context).getBaseContext() : (Activity)context;
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return metrics;
    }

    public static int[] getScreenPixelSize(Context context) {
        DisplayMetrics metrics = ScreenUtils.getDisplayMetrics(context);
        return new int[]{metrics.widthPixels, metrics.heightPixels};
    }

    public static void hideSoftInputKeyBoard(Context context, View focusView) {
        IBinder binder;
        if (focusView != null && (binder = focusView.getWindowToken()) != null) {
            InputMethodManager imd = (InputMethodManager)context.getSystemService("input_method");
            imd.hideSoftInputFromWindow(binder, 1);
        }
    }

    public static void showSoftInputKeyBoard(Context context, View focusView) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.showSoftInput(focusView, 2);
    }

    public static int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static int getStatusBarHeight(Context context) {
        int statusBarHeight = 0;
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object obj = c.newInstance();
            Field field = c.getField("status_bar_height");
            int x = Integer.parseInt(field.get(obj).toString());
            statusBarHeight = context.getResources().getDimensionPixelSize(x);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return statusBarHeight;
    }

    public static int getAppInScreenheight(Context context) {
        return ScreenUtils.getScreenHeight(context) - ScreenUtils.getStatusBarHeight(context);
    }
}

