/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.mypermissionlib;

import android.content.Context;
import androidx.annotation.NonNull;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.AndPermission;
import com.yanzhenjie.permission.option.Option;
import com.zlylib.mypermissionlib.RequestInterceptor;
import com.zlylib.mypermissionlib.RequestListener;
import com.zlylib.mypermissionlib.Requester;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class RuntimeRequester
implements Requester<RuntimeRequester> {
    private final Option mOption;
    private final Context mContext;
    private final int mRequestCode;
    private String[] mAllNeededPermissions = null;
    private Queue<String> mUnGrantedPermissions = null;
    private RequestListener mListener = null;
    private RequestInterceptor<String> mOnBeforeRequest = null;
    private RequestInterceptor<String> mOnBeenDenied = null;
    private RequestInterceptor<String> mOnGoSetting = null;

    RuntimeRequester(Option option, Context context, int requestCodeWhenGoSetting) {
        this.mOption = option;
        this.mContext = context;
        this.mRequestCode = requestCodeWhenGoSetting;
    }

    public RuntimeRequester permissions(String ... permissions) {
        this.mAllNeededPermissions = permissions;
        return this;
    }

    public RuntimeRequester onBeforeRequest(RequestInterceptor<String> onBeforeRequest) {
        this.mOnBeforeRequest = onBeforeRequest;
        return this;
    }

    public RuntimeRequester onBeenDenied(RequestInterceptor<String> onBeenDenied) {
        this.mOnBeenDenied = onBeenDenied;
        return this;
    }

    public RuntimeRequester onGoSetting(RequestInterceptor<String> onGoSetting) {
        this.mOnGoSetting = onGoSetting;
        return this;
    }

    @Override
    public RuntimeRequester request(@NonNull RequestListener listener) {
        this.mListener = listener;
        this.findUnGrantedPermissions();
        this.next();
        return this;
    }

    public void onActivityResult(int requestCode) {
        if (requestCode == this.mRequestCode) {
            if (AndPermission.hasPermissions((Context)this.mContext, (String[])new String[]{this.mUnGrantedPermissions.peek()})) {
                this.mUnGrantedPermissions.poll();
                this.next();
            } else {
                this.again();
            }
        }
    }

    private void findUnGrantedPermissions() {
        if (this.mUnGrantedPermissions == null) {
            this.mUnGrantedPermissions = new LinkedList<String>();
        }
        for (String permission : this.mAllNeededPermissions) {
            if (AndPermission.hasPermissions((Context)this.mContext, (String[])new String[]{permission})) {
                this.mUnGrantedPermissions.remove(permission);
                continue;
            }
            if (this.mUnGrantedPermissions.contains(permission)) continue;
            this.mUnGrantedPermissions.offer(permission);
        }
    }

    private void onSuccess() {
        if (this.mListener != null) {
            this.mListener.onSuccess();
        }
    }

    private void onFailed() {
        if (this.mListener != null) {
            this.mListener.onFailed();
        }
    }

    private void onBeforeRequest() {
        if (this.mOnBeforeRequest == null) {
            this.request();
            return;
        }
        this.mOnBeforeRequest.intercept(this.mUnGrantedPermissions.peek(), new RequestInterceptor.Executor(){

            @Override
            public void execute() {
                RuntimeRequester.this.request();
            }

            @Override
            public void cancel() {
                RuntimeRequester.this.onFailed();
            }
        });
    }

    private void onBeenDenied() {
        if (this.mOnBeenDenied == null) {
            this.request();
            return;
        }
        this.mOnBeenDenied.intercept(this.mUnGrantedPermissions.peek(), new RequestInterceptor.Executor(){

            @Override
            public void execute() {
                RuntimeRequester.this.request();
            }

            @Override
            public void cancel() {
                RuntimeRequester.this.onFailed();
            }
        });
    }

    private void onGoSetting() {
        if (this.mOnGoSetting == null) {
            this.setting();
            return;
        }
        this.mOnGoSetting.intercept(this.mUnGrantedPermissions.peek(), new RequestInterceptor.Executor(){

            @Override
            public void execute() {
                RuntimeRequester.this.setting();
            }

            @Override
            public void cancel() {
                RuntimeRequester.this.onFailed();
            }
        });
    }

    private void setting() {
        this.mOption.runtime().setting().start(this.mRequestCode);
    }

    private void request() {
        this.mOption.runtime().permission(new String[]{this.mUnGrantedPermissions.peek()}).onGranted((Action)new Action<List<String>>(){

            public void onAction(List<String> data) {
                RuntimeRequester.this.mUnGrantedPermissions.poll();
                RuntimeRequester.this.next();
            }
        }).onDenied((Action)new Action<List<String>>(){

            public void onAction(List<String> data) {
                RuntimeRequester.this.again();
            }
        }).start();
    }

    private void next() {
        if (this.mUnGrantedPermissions.peek() == null) {
            this.onSuccess();
            return;
        }
        if (AndPermission.hasPermissions((Context)this.mContext, (String[])new String[]{this.mUnGrantedPermissions.peek()})) {
            this.mUnGrantedPermissions.poll();
            this.next();
            return;
        }
        this.onBeforeRequest();
    }

    private void again() {
        if (this.mUnGrantedPermissions.peek() == null) {
            this.onSuccess();
            return;
        }
        if (AndPermission.hasPermissions((Context)this.mContext, (String[])new String[]{this.mUnGrantedPermissions.peek()})) {
            this.mUnGrantedPermissions.poll();
            this.next();
            return;
        }
        if (AndPermission.hasAlwaysDeniedPermission((Context)this.mContext, (String[])new String[]{this.mUnGrantedPermissions.peek()})) {
            this.onGoSetting();
        } else {
            this.onBeenDenied();
        }
    }
}

