/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.mypermissionlib;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import com.yanzhenjie.permission.AndPermission;
import com.yanzhenjie.permission.checker.StandardChecker;
import com.yanzhenjie.permission.option.Option;
import java.lang.reflect.Field;

public class ContextHolder {
    private final Context mContext;
    private final Activity mActivity;
    private final androidx.fragment.app.Fragment mSupportFragment;
    private final Fragment mFragment;

    ContextHolder(@NonNull Context context) {
        this.mContext = context;
        this.mActivity = null;
        this.mSupportFragment = null;
        this.mFragment = null;
    }

    ContextHolder(@NonNull Activity activity) {
        this.mContext = null;
        this.mActivity = activity;
        this.mSupportFragment = null;
        this.mFragment = null;
    }

    ContextHolder(@NonNull androidx.fragment.app.Fragment fragment) {
        this.mContext = null;
        this.mActivity = null;
        this.mSupportFragment = fragment;
        this.mFragment = null;
    }

    ContextHolder(@NonNull Fragment fragment) {
        this.mContext = null;
        this.mActivity = null;
        this.mSupportFragment = null;
        this.mFragment = fragment;
    }

    public Option getOption() {
        this.hookAndPermission();
        if (this.mContext != null) {
            return AndPermission.with((Context)this.mContext);
        }
        if (this.mActivity != null) {
            return AndPermission.with((Activity)this.mActivity);
        }
        if (this.mSupportFragment != null) {
            return AndPermission.with((androidx.fragment.app.Fragment)this.mSupportFragment);
        }
        if (this.mFragment != null) {
            return AndPermission.with((Fragment)this.mFragment);
        }
        return null;
    }

    public Context getContext() {
        if (this.mContext != null) {
            return this.mContext;
        }
        if (this.mActivity != null) {
            return this.mActivity;
        }
        if (this.mSupportFragment != null) {
            return this.mSupportFragment.getContext();
        }
        if (this.mFragment != null) {
            if (Build.VERSION.SDK_INT >= 23) {
                return this.mFragment.getContext();
            }
            return this.mFragment.getActivity();
        }
        return null;
    }

    private void hookAndPermission() {
        if (Build.VERSION.SDK_INT >= 28) {
            this.hookAndPermissionDoubleChecker();
        }
    }

    private void hookAndPermissionDoubleChecker() {
        try {
            Class<?> andPermission = Class.forName("com.yanzhenjie.permission.checker.DoubleChecker");
            Field strictChecker = andPermission.getDeclaredField("STRICT_CHECKER");
            strictChecker.setAccessible(true);
            Object fieldObj = strictChecker.get(null);
            strictChecker.set(fieldObj, new StandardChecker());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

