/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.horizontalviewlib.core;

import android.view.View;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Pivot {
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    private static final int PIVOT_CENTER = -1;
    private static final int PIVOT_MAX = -2;
    private int axis;
    private int pivotPoint;

    public Pivot(int axis, int pivotPoint) {
        this.axis = axis;
        this.pivotPoint = pivotPoint;
    }

    public void setOn(View view) {
        if (this.axis == 0) {
            switch (this.pivotPoint) {
                case -1: {
                    view.setPivotX((float)view.getWidth() * 0.5f);
                    break;
                }
                case -2: {
                    view.setPivotX((float)view.getWidth());
                    break;
                }
                default: {
                    view.setPivotX((float)this.pivotPoint);
                }
            }
            return;
        }
        if (this.axis == 1) {
            switch (this.pivotPoint) {
                case -1: {
                    view.setPivotY((float)view.getHeight() * 0.5f);
                    break;
                }
                case -2: {
                    view.setPivotY((float)view.getHeight());
                    break;
                }
                default: {
                    view.setPivotY((float)this.pivotPoint);
                }
            }
        }
    }

    public int getAxis() {
        return this.axis;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Axis {
    }

    public static enum Y {
        TOP{

            @Override
            public Pivot create() {
                return new Pivot(1, 0);
            }
        }
        ,
        CENTER{

            @Override
            public Pivot create() {
                return new Pivot(1, -1);
            }
        }
        ,
        BOTTOM{

            @Override
            public Pivot create() {
                return new Pivot(1, -2);
            }
        };


        public abstract Pivot create();
    }

    public static enum X {
        LEFT{

            @Override
            public Pivot create() {
                return new Pivot(0, 0);
            }
        }
        ,
        CENTER{

            @Override
            public Pivot create() {
                return new Pivot(0, -1);
            }
        }
        ,
        RIGHT{

            @Override
            public Pivot create() {
                return new Pivot(0, -2);
            }
        };


        public abstract Pivot create();
    }
}

