/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.horizontalviewlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.zlylib.horizontalviewlib.DSVOrientation;
import com.zlylib.horizontalviewlib.HorizontalLayoutManager;
import com.zlylib.horizontalviewlib.R;
import com.zlylib.horizontalviewlib.adapter.ScrollListenerAdapter;
import com.zlylib.horizontalviewlib.transform.HorizontalScrollItemTransformer;
import java.util.ArrayList;
import java.util.List;

public class HorizontalView
extends RecyclerView {
    public static final int NO_POSITION = -1;
    private static final int DEFAULT_ORIENTATION = DSVOrientation.HORIZONTAL.ordinal();
    private HorizontalLayoutManager layoutManager;
    private List<ScrollStateChangeListener> scrollStateChangeListeners;
    private List<OnItemChangedListener> onItemChangedListeners;
    private boolean isOverScrollEnabled;

    public HorizontalView(Context context) {
        super(context);
        this.init(null);
    }

    public HorizontalView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public HorizontalView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.scrollStateChangeListeners = new ArrayList<ScrollStateChangeListener>();
        this.onItemChangedListeners = new ArrayList<OnItemChangedListener>();
        int orientation = DEFAULT_ORIENTATION;
        if (attrs != null) {
            TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.HorizontalView);
            orientation = ta.getInt(R.styleable.HorizontalView_dsv_orientation, DEFAULT_ORIENTATION);
            ta.recycle();
        }
        this.isOverScrollEnabled = this.getOverScrollMode() != 2;
        this.layoutManager = new HorizontalLayoutManager(this.getContext(), new ScrollStateListener(), DSVOrientation.values()[orientation]);
        this.setLayoutManager(this.layoutManager);
    }

    public void setLayoutManager(RecyclerView.LayoutManager layout) {
        if (!(layout instanceof HorizontalLayoutManager)) {
            throw new IllegalArgumentException(this.getContext().getString(R.string.dsv_ex_msg_dont_set_lm));
        }
        super.setLayoutManager(layout);
    }

    public boolean fling(int velocityX, int velocityY) {
        boolean isFling = super.fling(velocityX, velocityY);
        if (isFling) {
            this.layoutManager.onFling(velocityX, velocityY);
        } else {
            this.layoutManager.returnToCurrentPosition();
        }
        return isFling;
    }

    @Nullable
    public RecyclerView.ViewHolder getViewHolder(int position) {
        View view = this.layoutManager.findViewByPosition(position);
        return view != null ? this.getChildViewHolder(view) : null;
    }

    public int getCurrentItem() {
        return this.layoutManager.getCurrentPosition();
    }

    public void setItemTransformer(HorizontalScrollItemTransformer transformer) {
        this.layoutManager.setItemTransformer(transformer);
    }

    public void setItemTransitionTimeMillis(@IntRange(from=10L) int millis) {
        this.layoutManager.setTimeForItemSettle(millis);
    }

    public void setSlideOnFling(boolean result) {
        this.layoutManager.setShouldSlideOnFling(result);
    }

    public void setSlideOnFlingThreshold(int threshold) {
        this.layoutManager.setSlideOnFlingThreshold(threshold);
    }

    public void setOrientation(DSVOrientation orientation) {
        this.layoutManager.setOrientation(orientation);
    }

    public void setOffscreenItems(int items) {
        this.layoutManager.setOffscreenItems(items);
    }

    public void setClampTransformProgressAfter(@IntRange(from=1L) int itemCount) {
        if (itemCount <= 1) {
            throw new IllegalArgumentException("must be >= 1");
        }
        this.layoutManager.setTransformClampItemCount(itemCount);
    }

    public void setOverScrollEnabled(boolean overScrollEnabled) {
        this.isOverScrollEnabled = overScrollEnabled;
        this.setOverScrollMode(2);
    }

    public void addScrollStateChangeListener(@NonNull ScrollStateChangeListener<?> scrollStateChangeListener) {
        this.scrollStateChangeListeners.add(scrollStateChangeListener);
    }

    public void addScrollListener(@NonNull ScrollListener<?> scrollListener) {
        this.addScrollStateChangeListener(new ScrollListenerAdapter(scrollListener));
    }

    public void addOnItemChangedListener(@NonNull OnItemChangedListener<?> onItemChangedListener) {
        this.onItemChangedListeners.add(onItemChangedListener);
    }

    public void removeScrollStateChangeListener(@NonNull ScrollStateChangeListener<?> scrollStateChangeListener) {
        this.scrollStateChangeListeners.remove(scrollStateChangeListener);
    }

    public void removeScrollListener(@NonNull ScrollListener<?> scrollListener) {
        this.removeScrollStateChangeListener(new ScrollListenerAdapter(scrollListener));
    }

    public void removeItemChangedListener(@NonNull OnItemChangedListener<?> onItemChangedListener) {
        this.onItemChangedListeners.remove(onItemChangedListener);
    }

    private void notifyScrollStart(RecyclerView.ViewHolder holder, int current) {
        for (ScrollStateChangeListener listener : this.scrollStateChangeListeners) {
            listener.onScrollStart(holder, current);
        }
    }

    private void notifyScrollEnd(RecyclerView.ViewHolder holder, int current) {
        for (ScrollStateChangeListener listener : this.scrollStateChangeListeners) {
            listener.onScrollEnd(holder, current);
        }
    }

    private void notifyScroll(float position, int currentIndex, int newIndex, RecyclerView.ViewHolder currentHolder, RecyclerView.ViewHolder newHolder) {
        for (ScrollStateChangeListener listener : this.scrollStateChangeListeners) {
            listener.onScroll(position, currentIndex, newIndex, currentHolder, newHolder);
        }
    }

    private void notifyCurrentItemChanged(RecyclerView.ViewHolder holder, int current) {
        for (OnItemChangedListener listener : this.onItemChangedListeners) {
            listener.onCurrentItemChanged(holder, current);
        }
    }

    private void notifyCurrentItemChanged() {
        if (this.onItemChangedListeners.isEmpty()) {
            return;
        }
        int current = this.layoutManager.getCurrentPosition();
        RecyclerView.ViewHolder currentHolder = this.getViewHolder(current);
        this.notifyCurrentItemChanged(currentHolder, current);
    }

    public static interface OnItemChangedListener<T extends RecyclerView.ViewHolder> {
        public void onCurrentItemChanged(@Nullable T var1, int var2);
    }

    public static interface ScrollListener<T extends RecyclerView.ViewHolder> {
        public void onScroll(float var1, int var2, int var3, @Nullable T var4, @Nullable T var5);
    }

    public static interface ScrollStateChangeListener<T extends RecyclerView.ViewHolder> {
        public void onScrollStart(@NonNull T var1, int var2);

        public void onScrollEnd(@NonNull T var1, int var2);

        public void onScroll(float var1, int var2, int var3, @Nullable T var4, @Nullable T var5);
    }

    private class ScrollStateListener
    implements HorizontalLayoutManager.ScrollStateListener {
        private ScrollStateListener() {
        }

        @Override
        public void onIsBoundReachedFlagChange(boolean isBoundReached) {
            if (HorizontalView.this.isOverScrollEnabled) {
                HorizontalView.this.setOverScrollMode(isBoundReached ? 0 : 2);
            }
        }

        @Override
        public void onScrollStart() {
            if (HorizontalView.this.scrollStateChangeListeners.isEmpty()) {
                return;
            }
            int current = HorizontalView.this.layoutManager.getCurrentPosition();
            RecyclerView.ViewHolder holder = HorizontalView.this.getViewHolder(current);
            if (holder != null) {
                HorizontalView.this.notifyScrollStart(holder, current);
            }
        }

        @Override
        public void onScrollEnd() {
            if (HorizontalView.this.onItemChangedListeners.isEmpty() && HorizontalView.this.scrollStateChangeListeners.isEmpty()) {
                return;
            }
            int current = HorizontalView.this.layoutManager.getCurrentPosition();
            RecyclerView.ViewHolder holder = HorizontalView.this.getViewHolder(current);
            if (holder != null) {
                HorizontalView.this.notifyScrollEnd(holder, current);
                HorizontalView.this.notifyCurrentItemChanged(holder, current);
            }
        }

        @Override
        public void onScroll(float currentViewPosition) {
            int newIndex;
            if (HorizontalView.this.scrollStateChangeListeners.isEmpty()) {
                return;
            }
            int currentIndex = HorizontalView.this.getCurrentItem();
            if (currentIndex != (newIndex = HorizontalView.this.layoutManager.getNextPosition())) {
                HorizontalView.this.notifyScroll(currentViewPosition, currentIndex, newIndex, HorizontalView.this.getViewHolder(currentIndex), HorizontalView.this.getViewHolder(newIndex));
            }
        }

        @Override
        public void onCurrentViewFirstLayout() {
            HorizontalView.this.post(new Runnable(){

                @Override
                public void run() {
                    HorizontalView.this.notifyCurrentItemChanged();
                }
            });
        }

        @Override
        public void onDataSetChangeChangedPosition() {
            HorizontalView.this.notifyCurrentItemChanged();
        }
    }
}

