/*
 * Decompiled with CFR 0.152.
 */
package com.github.yvescheung.whisperlint;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.github.yvescheung.whisperlint.support.api2.AnnotationUsageTypeCompat;
import com.github.yvescheung.whisperlint.support.api6.AnnotationCompat;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\rH\u0002Jr\u0010\u0018\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170\u00052\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005H\u0016\u00a8\u0006#"}, d2={"Lcom/github/yvescheung/whisperlint/WhisperHintDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "applicableAnnotations", "", "", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "reportAnnotation", "", "anno", "Lcom/intellij/psi/PsiAnnotation;", "node", "Lorg/jetbrains/uast/UAnnotation;", "visitAnnotationUsage", "usage", "annotation", "qualifiedName", "method", "Lcom/intellij/psi/PsiMethod;", "annotations", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "Companion", "whisperLint"})
public final class WhisperHintDetector
extends Detector
implements Detector.UastScanner {
    @NotNull
    private static final Issue ISSUE_WHISPER_WARNING;
    @NotNull
    private static final Issue ISSUE_WHISPER_ERROR;
    @NotNull
    private static final Issue ISSUE_WHISPER_INFO;
    private static final String needWarningAnnotation = "com.github.yvescheung.whisper.NeedWarning";
    private static final String needErrorAnnotation = "com.github.yvescheung.whisper.NeedError";
    private static final String needInfoAnnotation = "com.github.yvescheung.whisper.NeedInfo";
    public static final Companion Companion;

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return AnnotationUsageTypeCompat.Companion.setOf(AnnotationUsageTypeCompat.METHOD_CALL, AnnotationUsageTypeCompat.METHOD_CALL_PARAMETER, AnnotationUsageTypeCompat.ANNOTATION_REFERENCE).contains(type);
    }

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{needWarningAnnotation, needErrorAnnotation, needInfoAnnotation});
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        if (method == null) {
            return;
        }
        this.reportAnnotation(context, annotation, usage);
    }

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(USimpleNameReferenceExpression.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ WhisperHintDetector this$0;
            final /* synthetic */ JavaContext $context;

            public void visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                PsiAnnotation psiAnnotation;
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                PsiElement psiElement = node.resolve();
                if (!(psiElement instanceof PsiField)) {
                    psiElement = null;
                }
                PsiField psiField = (PsiField)psiElement;
                if (psiField == null) {
                    return;
                }
                PsiField psiField2 = psiField;
                PsiModifierList psiModifierList = psiField2.getModifierList();
                if (psiModifierList == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList, (String)"psiField.modifierList ?: return");
                PsiModifierList modifierList = psiModifierList;
                PsiAnnotation psiAnnotation2 = modifierList.findAnnotation("com.github.yvescheung.whisper.NeedError");
                if (psiAnnotation2 == null) {
                    psiAnnotation2 = psiAnnotation = modifierList.findAnnotation("com.github.yvescheung.whisper.NeedWarning");
                }
                if (psiAnnotation2 == null) {
                    psiAnnotation = modifierList.findAnnotation("com.github.yvescheung.whisper.NeedInfo");
                }
                if (psiAnnotation == null) {
                    return;
                }
                PsiAnnotation anno = psiAnnotation;
                WhisperHintDetector.access$reportAnnotation(this.this$0, this.$context, anno, (UElement)node);
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
            }
        };
    }

    private final void reportAnnotation(JavaContext context, PsiAnnotation anno, UElement node) {
        UAnnotation uAnnotation = (UAnnotation)UastContextKt.getUastParentOfType$default((PsiElement)((PsiElement)anno), UAnnotation.class, (boolean)false, (int)2, null);
        if (uAnnotation == null) {
            return;
        }
        UAnnotation uast = uAnnotation;
        if (Intrinsics.areEqual((Object)uast.getQualifiedName(), (Object)anno.getQualifiedName())) {
            this.reportAnnotation(context, uast, node);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void reportAnnotation(JavaContext context, UAnnotation anno, UElement node) {
        Issue issue;
        String string = AnnotationCompat.getAnnotationStringValue(anno, "value");
        if (string == null) {
            return;
        }
        String hint = string;
        String string2 = anno.getQualifiedName();
        if (string2 == null) return;
        switch (string2) {
            case "com.github.yvescheung.whisper.NeedWarning": {
                issue = ISSUE_WHISPER_WARNING;
                break;
            }
            case "com.github.yvescheung.whisper.NeedError": {
                issue = ISSUE_WHISPER_ERROR;
                break;
            }
            case "com.github.yvescheung.whisper.NeedInfo": {
                issue = ISSUE_WHISPER_INFO;
                break;
            }
            default: {
                return;
            }
        }
        Issue issue2 = issue;
        JavaContext.report$default((JavaContext)context, (Issue)issue2, (UElement)node, (Location)context.getLocation(node), (String)hint, null, (int)16, null);
    }

    static {
        Companion = new Companion(null);
        ISSUE_WHISPER_WARNING = Issue.Companion.create("WhisperWarning", "Warning hints provided by the whisper lib.", "The corresponding message is provided by @NeedWarning annotation method or field", Category.USABILITY, 1, Severity.WARNING, new Implementation(WhisperHintDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));
        ISSUE_WHISPER_ERROR = Issue.Companion.create("WhisperError", "Error message provided by the whisper lib.", "The corresponding message is provided by @NeedError annotation method or field", Category.USABILITY, 1, Severity.ERROR, new Implementation(WhisperHintDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));
        ISSUE_WHISPER_INFO = Issue.Companion.create("WhisperInfo", "Message provided by the whisper lib.", "The corresponding message is provided by @NeedInfo annotation method or field", Category.USABILITY, 1, Severity.INFORMATIONAL, new Implementation(WhisperHintDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));
    }

    public static final /* synthetic */ void access$reportAnnotation(WhisperHintDetector $this, JavaContext context, PsiAnnotation anno, UElement node) {
        $this.reportAnnotation(context, anno, node);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\u0002\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/github/yvescheung/whisperlint/WhisperHintDetector$Companion;", "", "()V", "ISSUE_WHISPER_ERROR", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE_WHISPER_ERROR", "()Lcom/android/tools/lint/detector/api/Issue;", "ISSUE_WHISPER_INFO", "getISSUE_WHISPER_INFO", "ISSUE_WHISPER_WARNING", "getISSUE_WHISPER_WARNING", "needErrorAnnotation", "", "needInfoAnnotation", "needWarningAnnotation", "getIssue", "", "()[Lcom/android/tools/lint/detector/api/Issue;", "whisperLint"})
    public static final class Companion {
        @NotNull
        public final Issue getISSUE_WHISPER_WARNING() {
            return ISSUE_WHISPER_WARNING;
        }

        @NotNull
        public final Issue getISSUE_WHISPER_ERROR() {
            return ISSUE_WHISPER_ERROR;
        }

        @NotNull
        public final Issue getISSUE_WHISPER_INFO() {
            return ISSUE_WHISPER_INFO;
        }

        @NotNull
        public final Issue[] getIssue() {
            return new Issue[]{this.getISSUE_WHISPER_WARNING(), this.getISSUE_WHISPER_ERROR(), this.getISSUE_WHISPER_INFO()};
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

