/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.optional;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import androidx.annotation.RestrictTo;
import androidx.startup.Initializer;
import com.pitaya.mobile.uinspector.UInspector;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00010\t0\bH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0003\u00a8\u0006\f"}, d2={"Lcom/pitaya/mobile/uinspector/optional/UInspectorInstaller;", "Landroidx/startup/Initializer;", "Lcom/pitaya/mobile/uinspector/UInspector;", "()V", "create", "context", "Landroid/content/Context;", "dependencies", "", "Ljava/lang/Class;", "getCurrentProcessName", "", "com.github.YvesCheung.Uinspector-optional-autoinstall"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class UInspectorInstaller
implements Initializer<UInspector> {
    @NotNull
    public UInspector create(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String processName = this.getCurrentProcessName(context);
        if (processName == null || Intrinsics.areEqual((Object)processName, (Object)context.getPackageName())) {
            UInspector.create((Context)context);
        }
        return UInspector.INSTANCE;
    }

    @NotNull
    public List<Class<? extends Initializer<?>>> dependencies() {
        return CollectionsKt.emptyList();
    }

    @SuppressLint(value={"DiscouragedPrivateApi", "PrivateApi"})
    private final String getCurrentProcessName(Context context) {
        String string;
        return Build.VERSION.SDK_INT >= 28 ? Application.getProcessName() : ((string = UInspectorInstaller.getCurrentProcessName$getCurrentProcessNameByActivityThread()) == null ? UInspectorInstaller.getCurrentProcessName$getCurrentProcessNameByActivityManager(context) : string);
    }

    private static final String getCurrentProcessName$getCurrentProcessNameByActivityThread() {
        String processName = null;
        try {
            Method declaredMethod = Class.forName("android.app.ActivityThread", false, Application.class.getClassLoader()).getDeclaredMethod("currentProcessName", new Class[0]);
            declaredMethod.setAccessible(true);
            Object object = declaredMethod.invoke(null, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            processName = (String)object;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return processName;
    }

    private static final String getCurrentProcessName$getCurrentProcessNameByActivityManager(Context context) {
        List runningAppList;
        ActivityManager am;
        int pid = Process.myPid();
        Object object = context.getSystemService("activity");
        ActivityManager activityManager = am = object instanceof ActivityManager ? (ActivityManager)object : null;
        if (am != null && (runningAppList = am.getRunningAppProcesses()) != null) {
            for (ActivityManager.RunningAppProcessInfo processInfo : runningAppList) {
                if (processInfo.pid != pid) continue;
                return processInfo.processName;
            }
        }
        return null;
    }
}

