/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.notification;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.widget.RemoteViews;
import androidx.annotation.DrawableRes;
import androidx.annotation.RestrictTo;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.pitaya.mobile.uinspector.R;
import com.pitaya.mobile.uinspector.UInspector;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\"\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\b\u0001\u0010\u0017\u001a\u00020\tH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/pitaya/mobile/uinspector/notification/UInspectorNotificationService;", "Landroid/app/Service;", "<init>", "()V", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onStartCommand", "", "flags", "startId", "onDestroy", "", "createNotification", "Landroid/app/Notification;", "isRunning", "", "createView", "Landroid/widget/RemoteViews;", "title", "", "info", "icon", "Companion", "com.github.YvesCheung.Uinspector-api"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class UInspectorNotificationService
extends Service {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PENDING_RUNNING = "pending_start";
    private static final int notificationId = 23333;

    @Nullable
    public IBinder onBind(@Nullable Intent intent) {
        return null;
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        boolean currentState = UInspector.currentState.isRunning();
        Intent intent2 = intent;
        boolean pendingState = intent2 != null ? intent2.getBooleanExtra(PENDING_RUNNING, currentState) : currentState;
        this.startForeground(23333, this.createNotification(pendingState));
        Runnable changeState = () -> UInspectorNotificationService.onStartCommand$lambda$0(pendingState);
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            changeState.run();
        } else {
            new Handler(Looper.getMainLooper()).post(changeState);
        }
        return super.onStartCommand(intent, flags, startId);
    }

    public void onDestroy() {
        this.stopForeground(true);
        super.onDestroy();
    }

    @SuppressLint(value={"LaunchActivityFromNotification"})
    private final Notification createNotification(boolean isRunning) {
        NotificationCompat.Builder builder;
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel("UInspector", (CharSequence)this.getString(R.string.uinspector_notification_channel_name), 4);
            NotificationManagerCompat.from((Context)((Context)this)).createNotificationChannel(channel);
            builder = new NotificationCompat.Builder((Context)this, channel.getId());
        } else {
            builder = new NotificationCompat.Builder((Context)this);
        }
        NotificationCompat.Builder notificationBuilder = builder;
        ApplicationInfo app = this.getApplicationInfo();
        CharSequence charSequence = this.getPackageManager().getApplicationLabel(this.getApplicationInfo());
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getApplicationLabel(...)");
        CharSequence appName = charSequence;
        Object[] objectArray = new Object[]{appName};
        String string2 = this.getString(isRunning ? R.string.uinspector_notification_channel_stop_title : R.string.uinspector_notification_channel_start_title, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String title = string2;
        String string3 = this.getString(isRunning ? R.string.uinspector_notification_channel_stop_message : R.string.uinspector_notification_channel_start_message);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        String info = string3;
        RemoteViews view = this.createView(title, info, isRunning ? R.drawable.notification_stop : R.drawable.notification_start);
        int flag = Build.VERSION.SDK_INT >= 23 ? 0x4C000000 : 0x48000000;
        notificationBuilder.setSmallIcon(app.icon).setContentTitle((CharSequence)title).setContentInfo((CharSequence)info).setCustomContentView(view).setContent(view).setStyle((NotificationCompat.Style)new NotificationCompat.DecoratedCustomViewStyle()).setPriority(1).setContentIntent(PendingIntent.getService((Context)((Context)this), (int)0, (Intent)new Intent((Context)this, UInspectorNotificationService.class).putExtra(PENDING_RUNNING, !isRunning), (int)flag));
        try {
            notificationBuilder.setSilent(true);
        }
        catch (NoSuchMethodError e) {
            notificationBuilder.setVibrate(null).setSound(null);
        }
        Notification notification = notificationBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"build(...)");
        return notification;
    }

    private final RemoteViews createView(String title, String info, @DrawableRes int icon) {
        RemoteViews root = new RemoteViews(this.getPackageName(), R.layout.uinspector_notification_channel_view);
        root.setTextViewText(R.id.notification_title, (CharSequence)title);
        root.setTextViewText(R.id.notification_info, (CharSequence)info);
        root.setImageViewResource(R.id.notification_btn, icon);
        return root;
    }

    private static final void onStartCommand$lambda$0(boolean $pendingState) {
        UInspector.INSTANCE.changeStateInner$com_github_YvesCheung_Uinspector_api($pendingState);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/pitaya/mobile/uinspector/notification/UInspectorNotificationService$Companion;", "", "<init>", "()V", "PENDING_RUNNING", "", "notificationId", "", "com.github.YvesCheung.Uinspector-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

