/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.ui.decoration;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import com.pitaya.mobile.uinspector.hierarchy.AndroidView;
import com.pitaya.mobile.uinspector.hierarchy.Layer;
import com.pitaya.mobile.uinspector.ui.decoration.UInspectorDecoration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/pitaya/mobile/uinspector/ui/decoration/ViewDecoration;", "Lcom/pitaya/mobile/uinspector/ui/decoration/UInspectorDecoration;", "layer", "Lcom/pitaya/mobile/uinspector/hierarchy/Layer;", "(Lcom/pitaya/mobile/uinspector/hierarchy/Layer;)V", "getLayer", "()Lcom/pitaya/mobile/uinspector/hierarchy/Layer;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "equals", "", "other", "", "hashCode", "", "Companion", "com.github.YvesCheung.Uinspector-api"})
@SourceDebugExtension(value={"SMAP\nViewDecoration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewDecoration.kt\ncom/pitaya/mobile/uinspector/ui/decoration/ViewDecoration\n+ 2 CanvasUtil.kt\ncom/pitaya/mobile/uinspector/util/CanvasUtilKt\n*L\n1#1,86:1\n17#2,15:87\n17#2,15:102\n*S KotlinDebug\n*F\n+ 1 ViewDecoration.kt\ncom/pitaya/mobile/uinspector/ui/decoration/ViewDecoration\n*L\n37#1:87,15\n50#1:102,15\n*E\n"})
public class ViewDecoration
implements UInspectorDecoration {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Layer layer;
    @NotNull
    private static final Paint boundPaint;
    @NotNull
    private static final Paint paddingPaint;
    @NotNull
    private static final Paint marginPaint;

    public ViewDecoration(@NotNull Layer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        this.layer = layer;
    }

    @NotNull
    public final Layer getLayer() {
        return this.layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int[] location = this.layer.getLocation();
        Rect viewBounds = new Rect(location[0], location[1], location[0] + this.layer.getWidth(), location[1] + this.layer.getHeight());
        if (this.layer instanceof AndroidView) {
            Rect paddingBound;
            View view = ((AndroidView)this.layer).getView();
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            ViewGroup.MarginLayoutParams marginLayoutParams = layoutParams instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)layoutParams : null;
            if (marginLayoutParams != null) {
                ViewGroup.MarginLayoutParams lp = marginLayoutParams;
                boolean bl = false;
                Rect marginBounds = new Rect(viewBounds.left - lp.leftMargin, viewBounds.top - lp.topMargin, viewBounds.right + lp.rightMargin, viewBounds.bottom + lp.bottomMargin);
                if (!Intrinsics.areEqual((Object)viewBounds, (Object)marginBounds)) {
                    Canvas $this$difference$iv = canvas;
                    boolean $i$f$difference = false;
                    int c$iv = $this$difference$iv.save();
                    try {
                        if (Build.VERSION.SDK_INT >= 26) {
                            $this$difference$iv.clipRect(marginBounds);
                            $this$difference$iv.clipOutRect(viewBounds);
                            Canvas $this$draw_u24lambda_u241_u24lambda_u240 = $this$difference$iv;
                            boolean bl2 = false;
                            $this$draw_u24lambda_u241_u24lambda_u240.drawRect(marginBounds, marginPaint);
                        }
                        $this$difference$iv.clipRect(marginBounds);
                        $this$difference$iv.clipRect(viewBounds, Region.Op.DIFFERENCE);
                        Canvas $this$draw_u24lambda_u241_u24lambda_u240 = $this$difference$iv;
                        boolean bl3 = false;
                        $this$draw_u24lambda_u241_u24lambda_u240.drawRect(marginBounds, marginPaint);
                    }
                    finally {
                        $this$difference$iv.restoreToCount(c$iv);
                    }
                }
            }
            if (!Intrinsics.areEqual((Object)viewBounds, (Object)(paddingBound = new Rect(viewBounds.left + view.getPaddingLeft(), viewBounds.top + view.getPaddingTop(), viewBounds.right - view.getPaddingRight(), viewBounds.bottom - view.getPaddingBottom())))) {
                Canvas $this$difference$iv = canvas;
                boolean $i$f$difference = false;
                int c$iv = $this$difference$iv.save();
                try {
                    Canvas $this$draw_u24lambda_u242;
                    if (Build.VERSION.SDK_INT >= 26) {
                        $this$difference$iv.clipRect(viewBounds);
                        $this$difference$iv.clipOutRect(paddingBound);
                        $this$draw_u24lambda_u242 = $this$difference$iv;
                        boolean bl = false;
                        $this$draw_u24lambda_u242.drawRect(viewBounds, paddingPaint);
                    } else {
                        $this$difference$iv.clipRect(viewBounds);
                        $this$difference$iv.clipRect(paddingBound, Region.Op.DIFFERENCE);
                        $this$draw_u24lambda_u242 = $this$difference$iv;
                        boolean bl = false;
                        $this$draw_u24lambda_u242.drawRect(viewBounds, paddingPaint);
                    }
                }
                finally {
                    $this$difference$iv.restoreToCount(c$iv);
                }
                canvas.drawRect(paddingBound, boundPaint);
            } else {
                canvas.drawRect(viewBounds, boundPaint);
            }
        } else {
            canvas.drawRect(viewBounds, boundPaint);
        }
    }

    public int hashCode() {
        return this.layer.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ViewDecoration && this.layer == ((ViewDecoration)other).layer;
    }

    static {
        Paint paint;
        Companion = new Companion(null);
        Paint $this$boundPaint_u24lambda_u243 = paint = new Paint();
        boolean bl = false;
        $this$boundPaint_u24lambda_u243.setAntiAlias(true);
        $this$boundPaint_u24lambda_u243.setStyle(Paint.Style.FILL);
        $this$boundPaint_u24lambda_u243.setColor(Color.parseColor((String)"#80FFED97"));
        boundPaint = paint;
        Paint $this$paddingPaint_u24lambda_u244 = paint = new Paint();
        boolean bl2 = false;
        $this$paddingPaint_u24lambda_u244.setAntiAlias(true);
        $this$paddingPaint_u24lambda_u244.setStyle(Paint.Style.FILL);
        $this$paddingPaint_u24lambda_u244.setColor(Color.parseColor((String)"#8066B3FF"));
        paddingPaint = paint;
        Paint $this$marginPaint_u24lambda_u245 = paint = new Paint();
        boolean bl3 = false;
        $this$marginPaint_u24lambda_u245.setAntiAlias(true);
        $this$marginPaint_u24lambda_u245.setStyle(Paint.Style.FILL);
        $this$marginPaint_u24lambda_u245.setColor(Color.parseColor((String)"#8093FF93"));
        marginPaint = paint;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/pitaya/mobile/uinspector/ui/decoration/ViewDecoration$Companion;", "", "()V", "boundPaint", "Landroid/graphics/Paint;", "getBoundPaint", "()Landroid/graphics/Paint;", "marginPaint", "getMarginPaint", "paddingPaint", "getPaddingPaint", "com.github.YvesCheung.Uinspector-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Paint getBoundPaint() {
            return boundPaint;
        }

        @NotNull
        public final Paint getPaddingPaint() {
            return paddingPaint;
        }

        @NotNull
        public final Paint getMarginPaint() {
            return marginPaint;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

