/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.hierarchy;

import android.app.Activity;
import android.app.Dialog;
import android.app.Fragment;
import android.os.Build;
import android.view.View;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\rH\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000e2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\rH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/pitaya/mobile/uinspector/hierarchy/FragmentsFinder;", "", "()V", "findFragments", "", "Landroid/view/View;", "activity", "Landroid/app/Activity;", "record", "", "fm", "Landroid/app/FragmentManager;", "records", "", "Landroidx/fragment/app/FragmentManager;", "com.github.YvesCheung.Uinspector-api"})
public final class FragmentsFinder {
    @NotNull
    public static final FragmentsFinder INSTANCE = new FragmentsFinder();

    private FragmentsFinder() {
    }

    @NotNull
    public final Map<View, Object> findFragments(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Map records = new LinkedHashMap();
        if (activity instanceof FragmentActivity) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getSupportFragmentManager(...)");
            this.record(fragmentManager, (Map<View, Object>)records);
        }
        android.app.FragmentManager fragmentManager = activity.getFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getFragmentManager(...)");
        this.record(fragmentManager, (Map<View, Object>)records);
        return records;
    }

    private final void record(FragmentManager fm, Map<View, Object> records) {
        for (androidx.fragment.app.Fragment fragment : fm.getFragments()) {
            View v = fragment.getView();
            if (v != null) {
                Intrinsics.checkNotNull((Object)fragment);
                records.put(v, fragment);
            } else if (fragment instanceof DialogFragment) {
                View dv;
                Dialog dialog = ((DialogFragment)fragment).getDialog();
                View view = dialog != null && (dialog = dialog.getWindow()) != null ? dialog.getDecorView() : (dv = null);
                if (dv != null) {
                    records.put(dv, fragment);
                }
            }
            FragmentManager fragmentManager = fragment.getChildFragmentManager();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getChildFragmentManager(...)");
            this.record(fragmentManager, records);
        }
    }

    private final void record(android.app.FragmentManager fm, Map<View, Object> records) {
        if (Build.VERSION.SDK_INT >= 26) {
            for (Fragment fragment : fm.getFragments()) {
                View v = fragment.getView();
                if (v != null) {
                    Intrinsics.checkNotNull((Object)fragment);
                    records.put(v, fragment);
                } else if (fragment instanceof android.app.DialogFragment) {
                    View dv;
                    Dialog dialog = ((android.app.DialogFragment)fragment).getDialog();
                    View view = dialog != null && (dialog = dialog.getWindow()) != null ? dialog.getDecorView() : (dv = null);
                    if (dv != null) {
                        records.put(dv, fragment);
                    }
                }
                android.app.FragmentManager fragmentManager = fragment.getChildFragmentManager();
                Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getChildFragmentManager(...)");
                this.record(fragmentManager, records);
            }
        }
    }
}

