/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.hierarchy;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.core.view.ViewGroupKt;
import com.pitaya.mobile.uinspector.hierarchy.AndroidView;
import com.pitaya.mobile.uinspector.hierarchy.Layer;
import com.pitaya.mobile.uinspector.hierarchy.LayerFactoryPlugin;
import com.pitaya.mobile.uinspector.util.ToStringKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\nH\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\f\u00a8\u0006#"}, d2={"Lcom/pitaya/mobile/uinspector/hierarchy/AndroidView;", "Lcom/pitaya/mobile/uinspector/hierarchy/Layer;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "children", "Lkotlin/sequences/Sequence;", "getChildren", "()Lkotlin/sequences/Sequence;", "height", "", "getHeight", "()I", "id", "", "getId", "()Ljava/lang/CharSequence;", "name", "getName", "parent", "getParent", "()Lcom/pitaya/mobile/uinspector/hierarchy/Layer;", "getView", "()Landroid/view/View;", "width", "getWidth", "equals", "", "other", "", "getLocation", "", "hashCode", "toString", "", "com.github.YvesCheung.Uinspector-api"})
public class AndroidView
implements Layer {
    @NotNull
    private final View view;

    public AndroidView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
    }

    @NotNull
    public final View getView() {
        return this.view;
    }

    @Override
    @NotNull
    public CharSequence getName() {
        return ToStringKt.getSimpleName(this.view);
    }

    @Override
    @Nullable
    public CharSequence getId() {
        CharSequence charSequence;
        if (this.view.getId() > 0) {
            Context context = this.view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
            charSequence = ToStringKt.idToString(context, this.view.getId());
        } else {
            charSequence = null;
        }
        return charSequence;
    }

    @Override
    @Nullable
    public Layer getParent() {
        Layer layer;
        View view;
        ViewParent viewParent = this.view.getParent();
        View view2 = view = viewParent instanceof View ? (View)viewParent : null;
        if (view == null) {
            layer = null;
        } else {
            viewParent = view;
            boolean bl = false;
            boolean bl2 = false;
            ViewParent it = viewParent;
            boolean bl3 = false;
            layer = LayerFactoryPlugin.Companion.create((View)it);
        }
        return layer;
    }

    @Override
    @NotNull
    public Sequence<Layer> getChildren() {
        return this.view instanceof ViewGroup ? SequencesKt.map((Sequence)ViewGroupKt.getChildren((ViewGroup)((ViewGroup)this.view)), (Function1)children.1.INSTANCE) : SequencesKt.emptySequence();
    }

    @Override
    public int getWidth() {
        return this.view.getMeasuredWidth();
    }

    @Override
    public int getHeight() {
        return this.view.getMeasuredHeight();
    }

    @Override
    @NotNull
    public int[] getLocation() {
        int[] nArray = new int[2];
        boolean bl = false;
        boolean bl2 = false;
        int[] it = nArray;
        boolean bl3 = false;
        this.getView().getLocationOnScreen(it);
        return nArray;
    }

    public int hashCode() {
        return this.view.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof AndroidView && ((AndroidView)other).view == this.view;
    }

    @NotNull
    public String toString() {
        return ((Object)this.getName()).toString();
    }
}

