/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.hierarchy;

import android.app.Activity;
import android.app.Fragment;
import android.os.Build;
import android.view.View;
import android.view.Window;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\rH\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000e2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\rH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/pitaya/mobile/uinspector/hierarchy/FragmentsFinder;", "", "()V", "findFragments", "", "Landroid/view/View;", "activity", "Landroid/app/Activity;", "record", "", "fm", "Landroid/app/FragmentManager;", "records", "", "Landroidx/fragment/app/FragmentManager;", "com.github.YvesCheung.Uinspector-api"})
public final class FragmentsFinder {
    @NotNull
    public static final FragmentsFinder INSTANCE = new FragmentsFinder();

    private FragmentsFinder() {
    }

    @NotNull
    public final Map<View, Object> findFragments(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        boolean bl = false;
        Map records = new LinkedHashMap();
        if (activity instanceof FragmentActivity) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"activity.supportFragmentManager");
            this.record(fragmentManager, (Map<View, Object>)records);
        }
        android.app.FragmentManager fragmentManager = activity.getFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"activity.fragmentManager");
        this.record(fragmentManager, (Map<View, Object>)records);
        return records;
    }

    private final void record(FragmentManager fm, Map<View, Object> records) {
        for (androidx.fragment.app.Fragment fragment : fm.getFragments()) {
            androidx.fragment.app.Fragment fragment2;
            FragmentManager fragmentManager;
            View v = fragment.getView();
            if (v != null) {
                fragmentManager = records;
                Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"fragment");
                fragment2 = fragment;
                boolean bl = false;
                fragmentManager.put(v, fragment2);
            } else if (fragment instanceof DialogFragment) {
                Window window;
                View dv;
                fragment2 = ((DialogFragment)fragment).getDialog();
                View view = fragment2 == null ? null : (dv = (window = fragment2.getWindow()) == null ? null : window.getDecorView());
                if (dv != null) {
                    fragment2 = records;
                    androidx.fragment.app.Fragment fragment3 = fragment;
                    boolean bl = false;
                    fragment2.put(dv, fragment3);
                }
            }
            fragmentManager = fragment.getChildFragmentManager();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"fragment.childFragmentManager");
            this.record(fragmentManager, (Map<View, Object>)records);
        }
    }

    private final void record(android.app.FragmentManager fm, Map<View, Object> records) {
        if (Build.VERSION.SDK_INT >= 26) {
            for (Fragment fragment : fm.getFragments()) {
                Fragment fragment2;
                android.app.FragmentManager fragmentManager;
                View v = fragment.getView();
                if (v != null) {
                    fragmentManager = records;
                    Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"fragment");
                    fragment2 = fragment;
                    boolean bl = false;
                    fragmentManager.put(v, fragment2);
                } else if (fragment instanceof android.app.DialogFragment) {
                    Window window;
                    View dv;
                    fragment2 = ((android.app.DialogFragment)fragment).getDialog();
                    View view = fragment2 == null ? null : (dv = (window = fragment2.getWindow()) == null ? null : window.getDecorView());
                    if (dv != null) {
                        fragment2 = records;
                        Fragment fragment3 = fragment;
                        boolean bl = false;
                        fragment2.put(dv, fragment3);
                    }
                }
                fragmentManager = fragment.getChildFragmentManager();
                Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"fragment.childFragmentManager");
                this.record(fragmentManager, (Map<View, Object>)records);
            }
        }
    }
}

