/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.IBinder;
import android.widget.RemoteViews;
import androidx.annotation.DrawableRes;
import androidx.annotation.RestrictTo;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.pitaya.mobile.uinspector.R;
import com.pitaya.mobile.uinspector.UInspector;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0001\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0016\u00a8\u0006\u0018"}, d2={"Lcom/pitaya/mobile/uinspector/notification/UInspectorNotificationService;", "Landroid/app/Service;", "()V", "createNotification", "Landroid/app/Notification;", "isRunning", "", "createView", "Landroid/widget/RemoteViews;", "title", "", "info", "icon", "", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onDestroy", "", "onStartCommand", "flags", "startId", "Companion", "Uinspector-api_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class UInspectorNotificationService
extends Service {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PENDING_RUNNING = "pending_start";
    private static final int notificationId = 23333;

    @Nullable
    public IBinder onBind(@Nullable Intent intent) {
        return null;
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        boolean bl;
        boolean currentState = UInspector.currentState.isRunning();
        Intent intent2 = intent;
        boolean pendingState = intent2 == null ? currentState : (bl = intent2.getBooleanExtra(PENDING_RUNNING, currentState));
        this.startForeground(23333, this.createNotification(pendingState));
        UInspector.INSTANCE.changeStateInner$Uinspector_api_release(pendingState);
        return super.onStartCommand(intent, flags, startId);
    }

    public void onDestroy() {
        this.stopForeground(true);
        super.onDestroy();
    }

    private final Notification createNotification(boolean isRunning) {
        NotificationCompat.Builder builder;
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel("UInspector", (CharSequence)this.getString(R.string.uinspector_notification_channel_name), 4);
            NotificationManagerCompat.from((Context)((Context)this)).createNotificationChannel(channel);
            builder = new NotificationCompat.Builder((Context)this, channel.getId());
        } else {
            builder = new NotificationCompat.Builder((Context)this);
        }
        NotificationCompat.Builder notificationBuilder = builder;
        ApplicationInfo applicationInfo = this.getPackageManager().getApplicationInfo(this.getPackageName(), 0);
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"packageManager.getApplicationInfo(packageName, 0)");
        ApplicationInfo app = applicationInfo;
        String string2 = this.getString(app.labelRes);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(app.labelRes)");
        String appName = string2;
        Object object = new Object[]{appName};
        String string3 = this.getString(isRunning ? R.string.uinspector_notification_channel_stop_title : R.string.uinspector_notification_channel_start_title, (Object[])object);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(\n            if (isRunning) R.string.uinspector_notification_channel_stop_title\n            else R.string.uinspector_notification_channel_start_title,\n            appName\n        )");
        String title = string3;
        object = this.getString(isRunning ? R.string.uinspector_notification_channel_stop_message : R.string.uinspector_notification_channel_start_message);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getString(\n            if (isRunning) R.string.uinspector_notification_channel_stop_message\n            else R.string.uinspector_notification_channel_start_message\n        )");
        Object info = object;
        RemoteViews view = this.createView(title, (String)info, isRunning ? R.drawable.notification_stop : R.drawable.notification_start);
        Notification notification = notificationBuilder.setSmallIcon(app.icon).setContentTitle((CharSequence)title).setContentInfo((CharSequence)info).setCustomContentView(view).setContent(view).setStyle((NotificationCompat.Style)new NotificationCompat.DecoratedCustomViewStyle()).setContentIntent(PendingIntent.getService((Context)((Context)this), (int)0, (Intent)new Intent((Context)this, UInspectorNotificationService.class).putExtra(PENDING_RUNNING, !isRunning), (int)0x48000000)).setPriority(1).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"notificationBuilder\n            .setSmallIcon(app.icon)\n            .setContentTitle(title)\n            .setContentInfo(info)\n            .setCustomContentView(view)\n            .setContent(view)\n            .setStyle(NotificationCompat.DecoratedCustomViewStyle())\n            .setContentIntent(\n                PendingIntent.getService(\n                    this, 0,\n                    Intent(this, UInspectorNotificationService::class.java)\n                        .putExtra(PENDING_RUNNING, !isRunning),\n                    FLAG_ONE_SHOT or FLAG_UPDATE_CURRENT\n                )\n            )\n            .setPriority(PRIORITY_HIGH)\n            .build()");
        return notification;
    }

    private final RemoteViews createView(String title, String info, @DrawableRes int icon) {
        RemoteViews root = new RemoteViews(this.getPackageName(), R.layout.uinspector_notification_channel_view);
        root.setTextViewText(R.id.notification_title, (CharSequence)title);
        root.setTextViewText(R.id.notification_info, (CharSequence)info);
        root.setImageViewResource(R.id.notification_btn, icon);
        return root;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/pitaya/mobile/uinspector/notification/UInspectorNotificationService$Companion;", "", "()V", "PENDING_RUNNING", "", "notificationId", "", "Uinspector-api_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

