/*
 * Decompiled with CFR 0.152.
 */
package com.pitaya.mobile.uinspector.hierarchy;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.pitaya.mobile.uinspector.hierarchy.AndroidHitTest;
import com.pitaya.mobile.uinspector.hierarchy.AndroidView;
import com.pitaya.mobile.uinspector.hierarchy.HitTest;
import com.pitaya.mobile.uinspector.hierarchy.Layer;
import com.pitaya.mobile.uinspector.hierarchy.LayerFactoryPlugin;
import com.pitaya.mobile.uinspector.util.ViewUtilsKt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\u0010"}, d2={"Lcom/pitaya/mobile/uinspector/hierarchy/AndroidHitTest;", "Lcom/pitaya/mobile/uinspector/hierarchy/HitTest;", "()V", "findFirstTouchTarget", "Landroid/view/View;", "view", "touchEvent", "Landroid/view/MotionEvent;", "findNextTarget", "Lcom/pitaya/mobile/uinspector/hierarchy/Layer;", "event", "current", "findTouchTargetByEvent", "parent", "Landroid/view/ViewGroup;", "Companion", "Uinspector-api_release"})
@SuppressLint(value={"PrivateApi"})
public class AndroidHitTest
implements HitTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Field> firstTouchTarget$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)Companion.firstTouchTarget.2.INSTANCE);
    @NotNull
    private static final Lazy<Field> touchTargetChild$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)Companion.touchTargetChild.2.INSTANCE);
    private static boolean getChildDrawingOrderNotFound;

    @Override
    @Nullable
    public Layer findNextTarget(@NotNull MotionEvent event, @NotNull Layer current) {
        View view;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        if (current instanceof AndroidView && (view = this.findFirstTouchTarget(((AndroidView)current).getView(), event)) != null) {
            return LayerFactoryPlugin.Companion.create(view);
        }
        return null;
    }

    @Nullable
    protected View findFirstTouchTarget(@Nullable View view, @NotNull MotionEvent touchEvent) {
        Intrinsics.checkNotNullParameter((Object)touchEvent, (String)"touchEvent");
        if (view instanceof ViewGroup) {
            View view2;
            try {
                Object object;
                Object touchTarget = Companion.getFirstTouchTarget().get(view);
                view2 = touchTarget != null ? ((object = Companion.getTouchTargetChild().get(touchTarget)) instanceof View ? (View)object : null) : this.findTouchTargetByEvent((ViewGroup)view, touchEvent);
            }
            catch (Throwable e) {
                Log.e((String)"UInspector", (String)e.toString());
                view2 = this.findTouchTargetByEvent((ViewGroup)view, touchEvent);
            }
            return view2;
        }
        return null;
    }

    @Nullable
    protected View findTouchTargetByEvent(@NotNull ViewGroup parent, @NotNull MotionEvent touchEvent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)touchEvent, (String)"touchEvent");
        if (parent.getChildCount() <= 0) {
            return null;
        }
        ArrayList<View> dispatchTouchOrder = new ArrayList<View>(parent.getChildCount());
        int n = 0;
        int n2 = parent.getChildCount();
        if (n < n2) {
            do {
                int drawIndex = n++;
                int childIndex = Companion.getChildDrawingOrder(parent, drawIndex);
                View child = parent.getChildAt(childIndex);
                int insertIndex = drawIndex;
                if (Build.VERSION.SDK_INT >= 21) {
                    float currentZ = child.getZ();
                    while (insertIndex > 0 && ((View)dispatchTouchOrder.get(insertIndex - 1)).getZ() > currentZ) {
                        int n3 = insertIndex;
                        insertIndex = n3 + -1;
                    }
                }
                dispatchTouchOrder.add(insertIndex, child);
            } while (n < n2);
        }
        for (View child : CollectionsKt.asReversedMutable((List)dispatchTouchOrder)) {
            if (child.getVisibility() == 8 || !ViewUtilsKt.isOnView(touchEvent, child)) continue;
            return child;
        }
        return null;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0004R\u001b\u0010\u0003\u001a\u00020\u00048DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00048DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\b\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/pitaya/mobile/uinspector/hierarchy/AndroidHitTest$Companion;", "", "()V", "firstTouchTarget", "Ljava/lang/reflect/Field;", "getFirstTouchTarget", "()Ljava/lang/reflect/Field;", "firstTouchTarget$delegate", "Lkotlin/Lazy;", "getChildDrawingOrderNotFound", "", "getGetChildDrawingOrderNotFound", "()Z", "setGetChildDrawingOrderNotFound", "(Z)V", "touchTargetChild", "getTouchTargetChild", "touchTargetChild$delegate", "getChildDrawingOrder", "", "parent", "Landroid/view/ViewGroup;", "idx", "Uinspector-api_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Field getFirstTouchTarget() {
            Lazy lazy = firstTouchTarget$delegate;
            boolean bl = false;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"com.pitaya.mobile.uinspector.hierarchy\n\nimport android.annotation.SuppressLint\nimport android.os.Build\nimport android.util.Log\nimport android.view.MotionEvent\nimport android.view.View\nimport android.view.ViewGroup\nimport com.pitaya.mobile.uinspector.util.LibName\nimport com.pitaya.mobile.uinspector.util.isOnView\nimport java.lang.reflect.Field\n\n/**\n * @author YvesCheung\n * 2021/1/29\n */\n@SuppressLint(\"PrivateApi\")\nopen class AndroidHitTest : HitTest {\n\n    override fun findNextTarget(event: MotionEvent, current: Layer): Layer? {\n        if (current is AndroidView) {\n            val view = findFirstTouchTarget(current.view, event)\n            if (view != null) {\n                return LayerFactoryPlugin.create(view)\n            }\n        }\n        return null\n    }\n\n    /**\n     * 1. Try to get the [view]'s 'mFirstTouchTarget' field\n     * 2. If fail, use [findTouchTargetByEvent] instead\n     */\n    protected open fun findFirstTouchTarget(view: View?, touchEvent: MotionEvent): View? {\n        if (view is ViewGroup) {\n            return try {\n                val touchTarget = firstTouchTarget.get(view)\n                if (touchTarget != null) {\n                    touchTargetChild.get(touchTarget) as? View\n                } else {\n                    findTouchTargetByEvent(view, touchEvent)\n                }\n            } catch (e: Throwable) {\n                Log.e(LibName, e.toString())\n                findTouchTargetByEvent(view, touchEvent)\n            }\n        }\n        return null\n    }\n\n    /**\n     * 1. Sort the children in [parent] by the [ViewGroup.getChildDrawingOrder] and [View.getZ]\n     * 2. Find the child who is on the top and is able to receive the [touchEvent]\n     */\n    protected open fun findTouchTargetByEvent(parent: ViewGroup, touchEvent: MotionEvent): View? {\n        if (parent.childCount <= 0) return null\n\n        val dispatchTouchOrder = ArrayList<View>(parent.childCount)\n        for (drawIndex in 0 until parent.childCount) {\n            val childIndex = getChildDrawingOrder(parent, drawIndex)\n            val child = parent.getChildAt(childIndex)\n\n            var insertIndex: Int = drawIndex\n            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {\n                // insert ahead of any Views with greater Z\n                val currentZ = child.z\n                while (insertIndex > 0 && dispatchTouchOrder[insertIndex - 1].z > currentZ) {\n                    insertIndex--\n                }\n            }\n            dispatchTouchOrder.add(insertIndex, child)\n        }\n\n        for (child in dispatchTouchOrder.asReversed()) { //from top to bottom\n            if (child.visibility != View.GONE && isOnView(touchEvent, child)) {\n                return child\n            }\n        }\n\n        return null\n    }\n\n    companion object {\n\n        protected val firstTouchTarget: Field by lazy(LazyThreadSafetyMode.NONE) {\n            val f = ViewGroup::class.java.getDeclaredField(\"mFirstTouchTarget\")\n            f.isAccessible = true\n            f\n        }");
            return (Field)object;
        }

        @NotNull
        protected final Field getTouchTargetChild() {
            Lazy lazy = touchTargetChild$delegate;
            boolean bl = false;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"com.pitaya.mobile.uinspector.hierarchy\n\nimport android.annotation.SuppressLint\nimport android.os.Build\nimport android.util.Log\nimport android.view.MotionEvent\nimport android.view.View\nimport android.view.ViewGroup\nimport com.pitaya.mobile.uinspector.util.LibName\nimport com.pitaya.mobile.uinspector.util.isOnView\nimport java.lang.reflect.Field\n\n/**\n * @author YvesCheung\n * 2021/1/29\n */\n@SuppressLint(\"PrivateApi\")\nopen class AndroidHitTest : HitTest {\n\n    override fun findNextTarget(event: MotionEvent, current: Layer): Layer? {\n        if (current is AndroidView) {\n            val view = findFirstTouchTarget(current.view, event)\n            if (view != null) {\n                return LayerFactoryPlugin.create(view)\n            }\n        }\n        return null\n    }\n\n    /**\n     * 1. Try to get the [view]'s 'mFirstTouchTarget' field\n     * 2. If fail, use [findTouchTargetByEvent] instead\n     */\n    protected open fun findFirstTouchTarget(view: View?, touchEvent: MotionEvent): View? {\n        if (view is ViewGroup) {\n            return try {\n                val touchTarget = firstTouchTarget.get(view)\n                if (touchTarget != null) {\n                    touchTargetChild.get(touchTarget) as? View\n                } else {\n                    findTouchTargetByEvent(view, touchEvent)\n                }\n            } catch (e: Throwable) {\n                Log.e(LibName, e.toString())\n                findTouchTargetByEvent(view, touchEvent)\n            }\n        }\n        return null\n    }\n\n    /**\n     * 1. Sort the children in [parent] by the [ViewGroup.getChildDrawingOrder] and [View.getZ]\n     * 2. Find the child who is on the top and is able to receive the [touchEvent]\n     */\n    protected open fun findTouchTargetByEvent(parent: ViewGroup, touchEvent: MotionEvent): View? {\n        if (parent.childCount <= 0) return null\n\n        val dispatchTouchOrder = ArrayList<View>(parent.childCount)\n        for (drawIndex in 0 until parent.childCount) {\n            val childIndex = getChildDrawingOrder(parent, drawIndex)\n            val child = parent.getChildAt(childIndex)\n\n            var insertIndex: Int = drawIndex\n            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {\n                // insert ahead of any Views with greater Z\n                val currentZ = child.z\n                while (insertIndex > 0 && dispatchTouchOrder[insertIndex - 1].z > currentZ) {\n                    insertIndex--\n                }\n            }\n            dispatchTouchOrder.add(insertIndex, child)\n        }\n\n        for (child in dispatchTouchOrder.asReversed()) { //from top to bottom\n            if (child.visibility != View.GONE && isOnView(touchEvent, child)) {\n                return child\n            }\n        }\n\n        return null\n    }\n\n    companion object {\n\n        protected val firstTouchTarget: Field by lazy(LazyThreadSafetyMode.NONE) {\n            val f = ViewGroup::class.java.getDeclaredField(\"mFirstTouchTarget\")\n            f.isAccessible = true\n            f\n        }\n\n        protected val touchTargetChild: Field by lazy(LazyThreadSafetyMode.NONE) {\n            val cls = Class.forName(\"android.view.ViewGroup\\$TouchTarget\")\n            val f = cls.getDeclaredField(\"child\")\n            f.isAccessible = true\n            f\n        }");
            return (Field)object;
        }

        protected final boolean getGetChildDrawingOrderNotFound() {
            return getChildDrawingOrderNotFound;
        }

        protected final void setGetChildDrawingOrderNotFound(boolean bl) {
            getChildDrawingOrderNotFound = bl;
        }

        protected final int getChildDrawingOrder(@NotNull ViewGroup parent, int idx) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            if (!this.getGetChildDrawingOrderNotFound()) {
                try {
                    int childIndex = parent.getChildDrawingOrder(idx);
                    boolean bl = 0 <= childIndex ? childIndex < parent.getChildCount() : false;
                    if (bl) {
                        return childIndex;
                    }
                }
                catch (Throwable e) {
                    this.setGetChildDrawingOrderNotFound(true);
                }
            }
            return idx;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

