/*
 * Decompiled with CFR 0.152.
 */
package com.huya.mobile.uinspector.util;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.style.BackgroundColorSpan;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.ColorInt;
import androidx.annotation.IdRes;
import androidx.annotation.Size;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0010\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0003\u001a\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0003\u001a\u000e\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0003\u001a\u0018\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020\u0003\u001a\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0001H\u0000\u001a\u0014\u0010#\u001a\u0004\u0018\u00010$2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0000\u001a\u000e\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u0003\u001a\f\u0010'\u001a\u00020(*\u00020(H\u0000\u001a6\u0010)\u001a\u0002H*\"\u0004\b\u0000\u0010**\u00020+2\b\b\u0001\u0010,\u001a\u00020-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u0002H*0/H\u0080\b\u00a2\u0006\u0002\u00100\u001a\u000e\u00101\u001a\u0004\u0018\u00010\u0012*\u0004\u0018\u00010\u0012\u001a6\u00102\u001a\u0002H*\"\u0004\b\u0000\u0010**\u00020+2\b\b\u0001\u0010,\u001a\u00020-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u0002H*0/H\u0080\b\u00a2\u0006\u0002\u00100\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0001*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0002\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\"\u0018\u0010\b\u001a\u00020\u0003*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0018\u0010\b\u001a\u00020\u000b*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\f\"\u0015\u0010\r\u001a\u00020\u0003*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\n\"\u0018\u0010\r\u001a\u00020\u000b*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\"\u0015\u0010\u000f\u001a\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0005\"\u0015\u0010\u000f\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007\u00a8\u00063"}, d2={"LibName", "", "dpStr", "", "getDpStr", "(I)Ljava/lang/String;", "", "(Ljava/lang/Number;)Ljava/lang/String;", "pxToDp", "getPxToDp", "(I)I", "", "(Ljava/lang/Number;)F", "pxToSp", "getPxToSp", "spStr", "getSpStr", "colorToString", "", "color", "Landroid/content/res/ColorStateList;", "drawableToString", "drawable", "Landroid/graphics/drawable/Drawable;", "gravityToString", "gravity", "hexToString", "hex", "idToString", "context", "Landroid/content/Context;", "id", "log", "", "value", "tryGetActivity", "Landroid/app/Activity;", "visibilityToString", "visibility", "findRootParent", "Landroid/view/View;", "fromLocation", "T", "Landroid/view/MotionEvent;", "offset", "", "action", "Lkotlin/Function1;", "(Landroid/view/MotionEvent;[ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "quote", "toLocation", "Uinspector-api_release"})
public final class UtilKt {
    @NotNull
    public static final String LibName = "UInspector";

    @Nullable
    public static final Activity tryGetActivity(@Nullable Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return UtilKt.tryGetActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    @NotNull
    public static final View findRootParent(@NotNull View $this$findRootParent) {
        Intrinsics.checkParameterIsNotNull((Object)$this$findRootParent, (String)"$this$findRootParent");
        View current = $this$findRootParent;
        ViewParent next = current.getParent();
        while (next instanceof View) {
            current = (View)next;
            next = current.getParent();
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T fromLocation(@NotNull MotionEvent $this$fromLocation, @Size(value=2L) @NotNull int[] offset, @NotNull Function1<? super MotionEvent, ? extends T> action) {
        Object object;
        int $i$f$fromLocation = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$fromLocation, (String)"$this$fromLocation");
        Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        float x = offset[0];
        float y = offset[1];
        $this$fromLocation.offsetLocation(x, y);
        try {
            object = action.invoke((Object)$this$fromLocation);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$fromLocation.offsetLocation(-x, -y);
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T toLocation(@NotNull MotionEvent $this$toLocation, @Size(value=2L) @NotNull int[] offset, @NotNull Function1<? super MotionEvent, ? extends T> action) {
        Object object;
        int $i$f$toLocation = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$toLocation, (String)"$this$toLocation");
        Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        float x = offset[0];
        float y = offset[1];
        $this$toLocation.offsetLocation(-x, -y);
        try {
            object = action.invoke((Object)$this$toLocation);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$toLocation.offsetLocation(x, y);
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    public static final int getPxToDp(int $this$pxToDp) {
        float f = $this$pxToDp;
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return (int)(f / resources.getDisplayMetrics().density);
    }

    public static final float getPxToDp(@NotNull Number $this$pxToDp) {
        Intrinsics.checkParameterIsNotNull((Object)$this$pxToDp, (String)"$this$pxToDp");
        float f = $this$pxToDp.floatValue();
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return f / resources.getDisplayMetrics().density;
    }

    @NotNull
    public static final String getDpStr(int $this$dpStr) {
        return UtilKt.getPxToDp($this$dpStr) + "dp";
    }

    @NotNull
    public static final String getDpStr(@NotNull Number $this$dpStr) {
        Intrinsics.checkParameterIsNotNull((Object)$this$dpStr, (String)"$this$dpStr");
        return MathKt.roundToInt((float)UtilKt.getPxToDp($this$dpStr)) + "dp";
    }

    public static final int getPxToSp(int $this$pxToSp) {
        float f = $this$pxToSp;
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return (int)(f / resources.getDisplayMetrics().scaledDensity);
    }

    public static final float getPxToSp(@NotNull Number $this$pxToSp) {
        Intrinsics.checkParameterIsNotNull((Object)$this$pxToSp, (String)"$this$pxToSp");
        float f = $this$pxToSp.floatValue();
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return f / resources.getDisplayMetrics().scaledDensity;
    }

    @NotNull
    public static final String getSpStr(int $this$spStr) {
        return UtilKt.getPxToSp($this$spStr) + "sp";
    }

    @NotNull
    public static final String getSpStr(@NotNull Number $this$spStr) {
        Intrinsics.checkParameterIsNotNull((Object)$this$spStr, (String)"$this$spStr");
        return MathKt.roundToInt((float)UtilKt.getPxToSp($this$spStr)) + "sp";
    }

    @NotNull
    public static final CharSequence colorToString(@NotNull ColorStateList color) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        return UtilKt.colorToString(color.getDefaultColor());
    }

    @NotNull
    public static final CharSequence colorToString(@ColorInt int color) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)UtilKt.hexToString(color)).append((CharSequence)" ");
        Intrinsics.checkExpressionValueIsNotNull((Object)spannableStringBuilder, (String)"SpannableStringBuilder(h\u2026tring(color)).append(\" \")");
        SpannableStringBuilder str = spannableStringBuilder;
        int start = str.length();
        str.append((CharSequence)"    ");
        int end = str.length();
        str.setSpan((Object)new BackgroundColorSpan(color), start, end, 33);
        return (CharSequence)str;
    }

    @NotNull
    public static final String hexToString(int hex) {
        return "0x" + Integer.toHexString(hex);
    }

    @NotNull
    public static final CharSequence drawableToString(@NotNull Drawable drawable2) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)drawable2, (String)"drawable");
        Drawable drawable3 = drawable2;
        if (drawable3 instanceof ColorDrawable) {
            charSequence = UtilKt.colorToString(((ColorDrawable)drawable2).getColor());
        } else {
            String string2 = drawable2.getClass().getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"drawable::class.java.simpleName");
            charSequence = string2;
        }
        return charSequence;
    }

    @NotNull
    public static final String idToString(@NotNull Context context, @IdRes int id2) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            string2 = "@+id/" + context.getResources().getResourceEntryName(id2);
        }
        catch (Resources.NotFoundException e) {
            string2 = UtilKt.hexToString(id2);
        }
        return string2;
    }

    @NotNull
    public static final String visibilityToString(int visibility) {
        String string2;
        switch (visibility) {
            case 0: {
                string2 = "VISIBLE";
                break;
            }
            case 4: {
                string2 = "INVISIBLE";
                break;
            }
            case 8: {
                string2 = "GONE";
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("What's " + visibility + '?');
            }
        }
        return string2;
    }

    @NotNull
    public static final String gravityToString(int gravity) {
        StringBuilder result = new StringBuilder();
        if ((gravity & 0x77) == 119) {
            Intrinsics.checkExpressionValueIsNotNull((Object)result.append("FILL").append(' '), (String)"result.append(\"FILL\").append(' ')");
        } else {
            if ((gravity & 0x70) == 112) {
                Intrinsics.checkExpressionValueIsNotNull((Object)result.append("FILL_VERTICAL").append(' '), (String)"result.append(\"FILL_VERTICAL\").append(' ')");
            } else {
                if ((gravity & 0x30) == 48) {
                    result.append("TOP").append(' ');
                }
                if ((gravity & 0x50) == 80) {
                    result.append("BOTTOM").append(' ');
                }
            }
            if ((gravity & 7) == 7) {
                Intrinsics.checkExpressionValueIsNotNull((Object)result.append("FILL_HORIZONTAL").append(' '), (String)"result.append(\"FILL_HORIZONTAL\").append(' ')");
            } else {
                if ((gravity & 0x800003) == 0x800003) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)result.append("START").append(' '), (String)"result.append(\"START\").append(' ')");
                } else if ((gravity & 3) == 3) {
                    result.append("LEFT").append(' ');
                }
                if ((gravity & 0x800005) == 0x800005) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)result.append("END").append(' '), (String)"result.append(\"END\").append(' ')");
                } else if ((gravity & 5) == 5) {
                    result.append("RIGHT").append(' ');
                }
            }
        }
        if ((gravity & 0x11) == 17) {
            Intrinsics.checkExpressionValueIsNotNull((Object)result.append("CENTER").append(' '), (String)"result.append(\"CENTER\").append(' ')");
        } else {
            if ((gravity & 0x10) == 16) {
                result.append("CENTER_VERTICAL").append(' ');
            }
            if ((gravity & 1) == 1) {
                result.append("CENTER_HORIZONTAL").append(' ');
            }
        }
        CharSequence charSequence = result;
        boolean bl = false;
        if (charSequence.length() == 0) {
            result.append("NO GRAVITY").append(' ');
        }
        if ((gravity & 0x10000000) == 0x10000000) {
            result.append("DISPLAY_CLIP_VERTICAL").append(' ');
        }
        if ((gravity & 0x1000000) == 0x1000000) {
            result.append("DISPLAY_CLIP_HORIZONTAL").append(' ');
        }
        result.deleteCharAt(result.length() - 1);
        String string2 = result.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.toString()");
        return string2;
    }

    @Nullable
    public static final CharSequence quote(@Nullable CharSequence $this$quote) {
        return $this$quote != null ? (CharSequence)("" + '\"' + $this$quote + '\"') : $this$quote;
    }

    public static final void log(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Log.d((String)LibName, (String)value);
    }
}

