/*
 * Decompiled with CFR 0.152.
 */
package com.huya.mobile.uinspector.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.huya.mobile.uinspector.UInspector;
import com.huya.mobile.uinspector.lifecycle.UInspectorLifecycle;
import com.huya.mobile.uinspector.state.UInspectorLifecycleState;
import com.huya.mobile.uinspector.util.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\u0004\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0003J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/huya/mobile/uinspector/lifecycle/UInspectorLifecycle;", "", "()V", "activityLifecycle", "com/huya/mobile/uinspector/lifecycle/UInspectorLifecycle$activityLifecycle$1", "Lcom/huya/mobile/uinspector/lifecycle/UInspectorLifecycle$activityLifecycle$1;", "appLifecycle", "com/huya/mobile/uinspector/lifecycle/UInspectorLifecycle$appLifecycle$1", "Lcom/huya/mobile/uinspector/lifecycle/UInspectorLifecycle$appLifecycle$1;", "<set-?>", "Landroid/app/Activity;", "currentActivity", "getCurrentActivity", "()Landroid/app/Activity;", "onActivityChanged", "", "newActivity", "register", "application", "Landroid/app/Application;", "unRegister", "com.github.YvesCheung.Uinspector-api"})
public final class UInspectorLifecycle {
    @Nullable
    private Activity currentActivity;
    private final appLifecycle.1 appLifecycle = new LifecycleObserver(){

        @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
        public final void onForeground() {
            boolean running = UInspector.currentState.isRunning();
            UtilsKt.log("onForeground: restart service, isRunning = " + running);
            UInspector.INSTANCE.startService$com_github_YvesCheung_Uinspector_api(running);
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
        public final void onBackground() {
            UtilsKt.log("onBackground: stop service");
            UInspector.INSTANCE.changeStateTemporary$com_github_YvesCheung_Uinspector_api(false);
            UInspector.INSTANCE.stopService$com_github_YvesCheung_Uinspector_api();
        }
    };
    private final activityLifecycle.1 activityLifecycle = new Application.ActivityLifecycleCallbacks(this){
        final /* synthetic */ UInspectorLifecycle this$0;

        public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            UInspectorLifecycle.access$onActivityChanged(this.this$0, activity);
        }

        public void onActivityResumed(@NotNull Activity activity) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            UInspectorLifecycle.access$onActivityChanged(this.this$0, activity);
        }

        public void onActivityDestroyed(@NotNull Activity activity) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            if (this.this$0.getCurrentActivity() == activity) {
                UInspectorLifecycle.access$onActivityChanged(this.this$0, null);
            }
        }

        public void onActivityStarted(@NotNull Activity activity) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        }

        public void onActivityPaused(@NotNull Activity activity) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        }

        public void onActivityStopped(@NotNull Activity activity) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        }

        public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
            Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
            Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
        }
        {
            this.this$0 = $outer;
        }
    };

    @Nullable
    public final Activity getCurrentActivity() {
        return this.currentActivity;
    }

    public final void register(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        LifecycleOwner lifecycleOwner = ProcessLifecycleOwner.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)lifecycleOwner, (String)"ProcessLifecycleOwner.get()");
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)this.appLifecycle);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycle);
    }

    public final void unRegister(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycle);
        LifecycleOwner lifecycleOwner = ProcessLifecycleOwner.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)lifecycleOwner, (String)"ProcessLifecycleOwner.get()");
        lifecycleOwner.getLifecycle().removeObserver((LifecycleObserver)this.appLifecycle);
    }

    @MainThread
    private final void onActivityChanged(Activity newActivity) {
        Activity lastActivity;
        this.currentActivity = newActivity;
        UInspectorLifecycleState uInspectorLifecycleState = UInspector.currentState.getWithLifecycle();
        Object object = lastActivity = uInspectorLifecycleState != null ? uInspectorLifecycleState.getActivity() : null;
        if (lastActivity != newActivity) {
            if (lastActivity != null) {
                UInspectorLifecycleState uInspectorLifecycleState2 = UInspector.currentState.getWithLifecycle();
                if (uInspectorLifecycleState2 != null) {
                    uInspectorLifecycleState2.clear$com_github_YvesCheung_Uinspector_api();
                }
                UInspector.currentState.setWithLifecycle(null);
            }
            if (newActivity != null) {
                UInspector.currentState.setWithLifecycle(new UInspectorLifecycleState(newActivity));
                UInspector.INSTANCE.syncState$com_github_YvesCheung_Uinspector_api();
            }
        }
    }

    public static final /* synthetic */ void access$onActivityChanged(UInspectorLifecycle $this, Activity newActivity) {
        $this.onActivityChanged(newActivity);
    }

    public static final /* synthetic */ Activity access$getCurrentActivity$p(UInspectorLifecycle $this) {
        return $this.currentActivity;
    }

    public static final /* synthetic */ void access$setCurrentActivity$p(UInspectorLifecycle $this, Activity activity) {
        $this.currentActivity = activity;
    }
}

