/*
 * Decompiled with CFR 0.152.
 */
package com.huya.mobile.uinspector.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.style.BackgroundColorSpan;
import androidx.annotation.ColorInt;
import androidx.annotation.IdRes;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0010\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0002\u001a\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u000e\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0002\u001a\u000e\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0002\u001a\u0018\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010 \u001a\u00020\u0002\u001a\u000e\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0002\u001a\u000e\u0010#\u001a\u0004\u0018\u00010\u0013*\u0004\u0018\u00010\u0013\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\u0002*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0018\u0010\n\u001a\u00020\u0002*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0018\u0010\n\u001a\u00020\f*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u0002*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\"\u0018\u0010\u000e\u001a\u00020\f*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\"\u0015\u0010\u0010\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0004\"\u0015\u0010\u0010\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006\u00a8\u0006$"}, d2={"dpStr", "", "", "getDpStr", "(I)Ljava/lang/String;", "", "(Ljava/lang/Number;)Ljava/lang/String;", "dpTopx", "getDpTopx", "(I)I", "pxToDp", "getPxToDp", "", "(Ljava/lang/Number;)F", "pxToSp", "getPxToSp", "spStr", "getSpStr", "colorToString", "", "color", "Landroid/content/res/ColorStateList;", "drawableToString", "drawable", "Landroid/graphics/drawable/Drawable;", "gravityToString", "gravity", "hexToString", "hex", "idToString", "context", "Landroid/content/Context;", "id", "visibilityToString", "visibility", "quote", "com.github.YvesCheung.Uinspector-api"})
public final class ToStringKt {
    public static final int getDpTopx(int $this$dpTopx) {
        float f = $this$dpTopx;
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return (int)(f * resources.getDisplayMetrics().density);
    }

    public static final int getPxToDp(int $this$pxToDp) {
        float f = $this$pxToDp;
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return (int)(f / resources.getDisplayMetrics().density);
    }

    public static final float getPxToDp(@NotNull Number $this$pxToDp) {
        Intrinsics.checkParameterIsNotNull((Object)$this$pxToDp, (String)"$this$pxToDp");
        float f = $this$pxToDp.floatValue();
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return f / resources.getDisplayMetrics().density;
    }

    @NotNull
    public static final String getDpStr(int $this$dpStr) {
        return ToStringKt.getPxToDp($this$dpStr) + "dp";
    }

    @NotNull
    public static final String getDpStr(@NotNull Number $this$dpStr) {
        Intrinsics.checkParameterIsNotNull((Object)$this$dpStr, (String)"$this$dpStr");
        return MathKt.roundToInt((float)ToStringKt.getPxToDp($this$dpStr)) + "dp";
    }

    public static final int getPxToSp(int $this$pxToSp) {
        float f = $this$pxToSp;
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return (int)(f / resources.getDisplayMetrics().scaledDensity);
    }

    public static final float getPxToSp(@NotNull Number $this$pxToSp) {
        Intrinsics.checkParameterIsNotNull((Object)$this$pxToSp, (String)"$this$pxToSp");
        float f = $this$pxToSp.floatValue();
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return f / resources.getDisplayMetrics().scaledDensity;
    }

    @NotNull
    public static final String getSpStr(int $this$spStr) {
        return ToStringKt.getPxToSp($this$spStr) + "sp";
    }

    @NotNull
    public static final String getSpStr(@NotNull Number $this$spStr) {
        Intrinsics.checkParameterIsNotNull((Object)$this$spStr, (String)"$this$spStr");
        return MathKt.roundToInt((float)ToStringKt.getPxToSp($this$spStr)) + "sp";
    }

    @NotNull
    public static final CharSequence colorToString(@NotNull ColorStateList color) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        return ToStringKt.colorToString(color.getDefaultColor());
    }

    @NotNull
    public static final CharSequence colorToString(@ColorInt int color) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)ToStringKt.hexToString(color)).append((CharSequence)" ");
        Intrinsics.checkExpressionValueIsNotNull((Object)spannableStringBuilder, (String)"SpannableStringBuilder(h\u2026tring(color)).append(\" \")");
        SpannableStringBuilder str = spannableStringBuilder;
        int start = str.length();
        str.append((CharSequence)"    ");
        int end = str.length();
        str.setSpan((Object)new BackgroundColorSpan(color), start, end, 33);
        return (CharSequence)str;
    }

    @NotNull
    public static final String hexToString(int hex) {
        StringBuilder stringBuilder = new StringBuilder().append("0x");
        String string = Integer.toHexString(hex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Integer.toHexString(hex)");
        String string2 = string;
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
        String string5 = string4;
        return stringBuilder2.append(string5).toString();
    }

    @NotNull
    public static final CharSequence drawableToString(@NotNull Drawable drawable) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        Drawable drawable2 = drawable;
        if (drawable2 instanceof ColorDrawable) {
            charSequence = ToStringKt.colorToString(((ColorDrawable)drawable).getColor());
        } else {
            String string = drawable.getClass().getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"drawable::class.java.simpleName");
            charSequence = string;
        }
        return charSequence;
    }

    @NotNull
    public static final String idToString(@NotNull Context context, @IdRes int id2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            string = "@+id/" + context.getResources().getResourceEntryName(id2);
        }
        catch (Resources.NotFoundException e) {
            string = ToStringKt.hexToString(id2);
        }
        return string;
    }

    @NotNull
    public static final String visibilityToString(int visibility) {
        String string;
        switch (visibility) {
            case 0: {
                string = "VISIBLE";
                break;
            }
            case 4: {
                string = "INVISIBLE";
                break;
            }
            case 8: {
                string = "GONE";
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("What's " + visibility + '?');
            }
        }
        return string;
    }

    @NotNull
    public static final String gravityToString(int gravity) {
        StringBuilder result = new StringBuilder();
        if ((gravity & 0x77) == 119) {
            Intrinsics.checkExpressionValueIsNotNull((Object)result.append("FILL").append(' '), (String)"result.append(\"FILL\").append(' ')");
        } else {
            if ((gravity & 0x70) == 112) {
                Intrinsics.checkExpressionValueIsNotNull((Object)result.append("FILL_VERTICAL").append(' '), (String)"result.append(\"FILL_VERTICAL\").append(' ')");
            } else {
                if ((gravity & 0x30) == 48) {
                    result.append("TOP").append(' ');
                }
                if ((gravity & 0x50) == 80) {
                    result.append("BOTTOM").append(' ');
                }
            }
            if ((gravity & 7) == 7) {
                Intrinsics.checkExpressionValueIsNotNull((Object)result.append("FILL_HORIZONTAL").append(' '), (String)"result.append(\"FILL_HORIZONTAL\").append(' ')");
            } else {
                if ((gravity & 0x800003) == 0x800003) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)result.append("START").append(' '), (String)"result.append(\"START\").append(' ')");
                } else if ((gravity & 3) == 3) {
                    result.append("LEFT").append(' ');
                }
                if ((gravity & 0x800005) == 0x800005) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)result.append("END").append(' '), (String)"result.append(\"END\").append(' ')");
                } else if ((gravity & 5) == 5) {
                    result.append("RIGHT").append(' ');
                }
            }
        }
        if ((gravity & 0x11) == 17) {
            Intrinsics.checkExpressionValueIsNotNull((Object)result.append("CENTER").append(' '), (String)"result.append(\"CENTER\").append(' ')");
        } else {
            if ((gravity & 0x10) == 16) {
                result.append("CENTER_VERTICAL").append(' ');
            }
            if ((gravity & 1) == 1) {
                result.append("CENTER_HORIZONTAL").append(' ');
            }
        }
        CharSequence charSequence = result;
        boolean bl = false;
        if (charSequence.length() == 0) {
            result.append("NO GRAVITY").append(' ');
        }
        if ((gravity & 0x10000000) == 0x10000000) {
            result.append("DISPLAY_CLIP_VERTICAL").append(' ');
        }
        if ((gravity & 0x1000000) == 0x1000000) {
            result.append("DISPLAY_CLIP_HORIZONTAL").append(' ');
        }
        result.deleteCharAt(result.length() - 1);
        String string = result.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    @Nullable
    public static final CharSequence quote(@Nullable CharSequence $this$quote) {
        return $this$quote != null ? (CharSequence)("" + '\"' + $this$quote + '\"') : $this$quote;
    }
}

