/*
 * Decompiled with CFR 0.152.
 */
package com.huya.mobile.uinspector;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.provider.Settings;
import android.view.View;
import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import com.huya.mobile.uinspector.UInspector;
import com.huya.mobile.uinspector.lifecycle.UInspectorLifecycle;
import com.huya.mobile.uinspector.notification.UInspectorNotificationService;
import com.huya.mobile.uinspector.state.UInspectorLifecycleState;
import com.huya.mobile.uinspector.state.UInspectorState;
import com.huya.mobile.uinspector.ui.panel.fullscreen.UInspectorDialogFragment;
import com.huya.mobile.uinspector.ui.panel.fullscreen.UInspectorLegacyDialogFragment;
import com.huya.mobile.uinspector.ui.panel.fullscreen.UInspectorPanel;
import com.huya.mobile.uinspector.ui.panel.fullscreen.UInspectorWindow;
import com.huya.mobile.uinspector.ui.panel.popup.UInspectorChildPanel;
import com.huya.mobile.uinspector.ui.panel.popup.UInspectorChildPanelService;
import com.huya.mobile.uinspector.util.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0015\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0013\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0000\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020\u0016H\u0007J\b\u0010%\u001a\u00020\u0016H\u0007J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u0014H\u0007J\u0015\u0010'\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b(J\b\u0010)\u001a\u00020\u0016H\u0007J\r\u0010*\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b+J\r\u0010,\u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\b-R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010\u000b\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/huya/mobile/uinspector/UInspector;", "", "()V", "application", "Landroid/app/Application;", "currentState", "Lcom/huya/mobile/uinspector/state/UInspectorState;", "init", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lifecycle", "Lcom/huya/mobile/uinspector/lifecycle/UInspectorLifecycle;", "panelService", "Ljava/util/ServiceLoader;", "Lcom/huya/mobile/uinspector/ui/panel/popup/UInspectorChildPanelService;", "kotlin.jvm.PlatformType", "getPanelService", "()Ljava/util/ServiceLoader;", "panelService$delegate", "Lkotlin/Lazy;", "pendingInspectView", "Landroid/view/View;", "changePanelState", "", "running", "", "changeStateInner", "changeStateInner$com_github_YvesCheung_Uinspector_api", "changeStateTemporary", "changeStateTemporary$com_github_YvesCheung_Uinspector_api", "create", "context", "Landroid/content/Context;", "createChildPanels", "", "Lcom/huya/mobile/uinspector/ui/panel/popup/UInspectorChildPanel;", "createChildPanels$com_github_YvesCheung_Uinspector_api", "destroy", "start", "inspectView", "startService", "startService$com_github_YvesCheung_Uinspector_api", "stop", "stopService", "stopService$com_github_YvesCheung_Uinspector_api", "syncState", "syncState$com_github_YvesCheung_Uinspector_api", "com.github.YvesCheung.Uinspector-api"})
@SuppressLint(value={"StaticFieldLeak"})
public final class UInspector {
    @JvmField
    @NotNull
    public static final UInspectorState currentState;
    private static Application application;
    private static final AtomicBoolean init;
    private static final UInspectorLifecycle lifecycle;
    private static View pendingInspectView;
    private static final Lazy panelService$delegate;
    public static final UInspector INSTANCE;

    @JvmStatic
    @MainThread
    public static final void create(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (init.compareAndSet(false, true)) {
            Context context2 = context.getApplicationContext();
            if (context2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.Application");
            }
            Application application = UInspector.application = (Application)context2;
            if (application == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"application");
            }
            lifecycle.register(application);
            UInspector.stop();
        }
    }

    @JvmStatic
    @MainThread
    public static final void destroy() {
        if (init.compareAndSet(true, false)) {
            INSTANCE.changeStateInner$com_github_YvesCheung_Uinspector_api(false);
            Application application = UInspector.application;
            if (application == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"application");
            }
            lifecycle.unRegister(application);
            Application application2 = UInspector.application;
            if (application2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"application");
            }
            Application application3 = UInspector.application;
            if (application3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"application");
            }
            application2.stopService(new Intent((Context)application3, UInspectorNotificationService.class));
        }
    }

    @JvmStatic
    @AnyThread
    public static final void start() {
        INSTANCE.startService$com_github_YvesCheung_Uinspector_api(true);
    }

    @JvmStatic
    @AnyThread
    public static final void start(@NotNull View inspectView) {
        Intrinsics.checkParameterIsNotNull((Object)inspectView, (String)"inspectView");
        pendingInspectView = inspectView;
        UInspector.start();
    }

    @JvmStatic
    @AnyThread
    public static final void stop() {
        INSTANCE.startService$com_github_YvesCheung_Uinspector_api(false);
    }

    public final void startService$com_github_YvesCheung_Uinspector_api(boolean running) {
        if (!init.get()) {
            throw (Throwable)new IllegalStateException("UInspector has not been init");
        }
        Application application = UInspector.application;
        if (application == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"application");
        }
        Context context = (Context)application;
        Application application2 = UInspector.application;
        if (application2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"application");
        }
        ContextCompat.startForegroundService((Context)context, (Intent)new Intent((Context)application2, UInspectorNotificationService.class).putExtra("pending_start", running));
    }

    public final void stopService$com_github_YvesCheung_Uinspector_api() {
        if (!init.get()) {
            throw (Throwable)new IllegalStateException("UInspector has not been init");
        }
        Application application = UInspector.application;
        if (application == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"application");
        }
        Application application2 = UInspector.application;
        if (application2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"application");
        }
        application.stopService(new Intent((Context)application2, UInspectorNotificationService.class));
    }

    @MainThread
    public final void syncState$com_github_YvesCheung_Uinspector_api() {
        this.changeStateInner$com_github_YvesCheung_Uinspector_api(currentState.isRunning());
    }

    @MainThread
    public final void changeStateInner$com_github_YvesCheung_Uinspector_api(boolean running) {
        this.changePanelState(running);
        currentState.setRunning$com_github_YvesCheung_Uinspector_api(running);
        UtilsKt.log("change state to " + (running ? "RUNNING" : "IDLE"));
    }

    @MainThread
    public final void changeStateTemporary$com_github_YvesCheung_Uinspector_api(boolean running) {
        this.changePanelState(running);
        UtilsKt.log("change state TEMPORARY to " + (running ? "RUNNING" : "IDLE"));
    }

    private final void changePanelState(boolean running) {
        UInspectorLifecycleState currentLifecycle = currentState.getWithLifecycle();
        if (currentLifecycle != null) {
            Activity activity = currentLifecycle.getActivity();
            currentLifecycle.clear$com_github_YvesCheung_Uinspector_api();
            if (running) {
                currentLifecycle.registerFragmentLifecycle$com_github_YvesCheung_Uinspector_api();
                UInspectorPanel mask = Build.VERSION.SDK_INT >= 23 && Settings.canDrawOverlays((Context)((Context)activity)) ? (UInspectorPanel)new UInspectorWindow() : (activity instanceof FragmentActivity ? (UInspectorPanel)new UInspectorDialogFragment() : (UInspectorPanel)new UInspectorLegacyDialogFragment());
                currentLifecycle.setPanel$com_github_YvesCheung_Uinspector_api(mask);
                mask.show(activity);
                View view = pendingInspectView;
                if (view != null) {
                    View view2 = view;
                    boolean bl = false;
                    boolean bl2 = false;
                    View it = view2;
                    boolean bl3 = false;
                    mask.updateTargetView(it);
                }
                pendingInspectView = null;
            }
        }
    }

    private final ServiceLoader<UInspectorChildPanelService> getPanelService() {
        Lazy lazy = panelService$delegate;
        UInspector uInspector = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ServiceLoader)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<UInspectorChildPanel> createChildPanels$com_github_YvesCheung_Uinspector_api() {
        void $this$flatMapTo$iv$iv;
        ServiceLoader<UInspectorChildPanelService> serviceLoader = this.getPanelService();
        Intrinsics.checkExpressionValueIsNotNull(serviceLoader, (String)"panelService");
        Iterable $this$flatMap$iv = serviceLoader;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            UInspectorChildPanelService it = (UInspectorChildPanelService)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.createPanels();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        iterable = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                UInspectorChildPanel it = (UInspectorChildPanel)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getPriority());
                it = (UInspectorChildPanel)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getPriority();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
    }

    private UInspector() {
    }

    static {
        UInspector uInspector;
        INSTANCE = uInspector = new UInspector();
        currentState = new UInspectorState();
        init = new AtomicBoolean(false);
        lifecycle = new UInspectorLifecycle();
        panelService$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)panelService.2.INSTANCE);
    }
}

