/*
 * Decompiled with CFR 0.152.
 */
package com.alimaddi.segmentedbutton;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Outline;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.CycleInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import com.alimaddi.segmentedbutton.ButtonActor;
import com.alimaddi.segmentedbutton.Divider;
import com.alimaddi.segmentedbutton.EmptyView;
import com.alimaddi.segmentedbutton.R;
import com.alimaddi.segmentedbutton.SegmentedButton;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;

public class SegmentedButtonGroup
extends LinearLayout {
    private static final String TAG = "SegmentedButtonGroup";
    public static final int ANIM_INTERPOLATOR_NONE = -1;
    public static final int ANIM_INTERPOLATOR_FAST_OUT_SLOW_IN = 0;
    public static final int ANIM_INTERPOLATOR_BOUNCE = 1;
    public static final int ANIM_INTERPOLATOR_LINEAR = 2;
    public static final int ANIM_INTERPOLATOR_DECELERATE = 3;
    public static final int ANIM_INTERPOLATOR_CYCLE = 4;
    public static final int ANIM_INTERPOLATOR_ANTICIPATE = 5;
    public static final int ANIM_INTERPOLATOR_ACCELERATE_DECELERATE = 6;
    public static final int ANIM_INTERPOLATOR_ACCELERATE = 7;
    public static final int ANIM_INTERPOLATOR_ANTICIPATE_OVERSHOOT = 8;
    public static final int ANIM_INTERPOLATOR_FAST_OUT_LINEAR_IN = 9;
    public static final int ANIM_INTERPOLATOR_LINEAR_OUT_SLOW_IN = 10;
    public static final int ANIM_INTERPOLATOR_OVERSHOOT = 11;
    private LinearLayout buttonLayout;
    private LinearLayout dividerLayout;
    private EmptyView borderView;
    private ArrayList<SegmentedButton> buttons;
    private Drawable backgroundDrawable;
    private Drawable selectedBackgroundDrawable;
    private int borderWidth;
    private int borderColor;
    private int borderDashWidth;
    private int borderDashGap;
    private int selectedBorderWidth;
    private int selectedBorderColor;
    private int selectedBorderDashWidth;
    private int selectedBorderDashGap;
    private int radius;
    private int selectedButtonRadius;
    private int position;
    private boolean draggable;
    private float dragOffsetX;
    private boolean ripple;
    private boolean hasRippleColor;
    private int rippleColor;
    private Interpolator selectionAnimationInterpolator;
    private int selectionAnimationDuration;
    ValueAnimator buttonAnimator;
    private float currentPosition;
    private int lastPosition;
    private OnPositionChangedListener onPositionChangedListener;
    private OnClickListener clickListener;

    public SegmentedButtonGroup(Context context) {
        super(context);
        this.init(context, null);
    }

    public SegmentedButtonGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SegmentedButtonGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public SegmentedButtonGroup(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        this.setOutlineProvider(new OutlineProvider());
        this.buttons = new ArrayList();
        FrameLayout container = new FrameLayout(this.getContext());
        super.addView((View)container, -1, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.buttonLayout = new LinearLayout(this.getContext());
        this.buttonLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        this.buttonLayout.setOrientation(0);
        container.addView((View)this.buttonLayout);
        this.borderView = new EmptyView(context);
        this.borderView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        container.addView((View)this.borderView);
        this.dividerLayout = new LinearLayout(this.getContext());
        this.dividerLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.dividerLayout.setOrientation(0);
        this.dividerLayout.setGravity(16);
        this.dividerLayout.setClickable(false);
        this.dividerLayout.setFocusable(false);
        container.addView((View)this.dividerLayout);
        this.getAttributes(context, attrs);
    }

    private void getAttributes(Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SegmentedButtonGroup, 0, 0);
        if (typedArray.hasValue(R.styleable.SegmentedButtonGroup_android_background)) {
            this.backgroundDrawable = typedArray.getDrawable(R.styleable.SegmentedButtonGroup_android_background);
        }
        if (typedArray.hasValue(R.styleable.SegmentedButtonGroup_selectedBackground)) {
            this.selectedBackgroundDrawable = typedArray.getDrawable(R.styleable.SegmentedButtonGroup_selectedBackground);
        }
        this.radius = typedArray.getDimensionPixelSize(R.styleable.SegmentedButtonGroup_radius, 0);
        this.selectedButtonRadius = typedArray.getDimensionPixelSize(R.styleable.SegmentedButtonGroup_selectedButtonRadius, 0);
        this.borderWidth = typedArray.getDimensionPixelSize(R.styleable.SegmentedButtonGroup_borderWidth, 0);
        this.borderColor = typedArray.getColor(R.styleable.SegmentedButtonGroup_borderColor, -16777216);
        this.borderDashWidth = typedArray.getDimensionPixelSize(R.styleable.SegmentedButtonGroup_borderDashWidth, 0);
        this.borderDashGap = typedArray.getDimensionPixelSize(R.styleable.SegmentedButtonGroup_borderDashGap, 0);
        this.setBorder(this.borderWidth, this.borderColor, this.borderDashWidth, this.borderDashGap);
        this.selectedBorderWidth = typedArray.getDimensionPixelSize(R.styleable.SegmentedButtonGroup_selectedBorderWidth, 0);
        this.selectedBorderColor = typedArray.getColor(R.styleable.SegmentedButtonGroup_selectedBorderColor, -16777216);
        this.selectedBorderDashWidth = typedArray.getDimensionPixelSize(R.styleable.SegmentedButtonGroup_selectedBorderDashWidth, 0);
        this.selectedBorderDashGap = typedArray.getDimensionPixelSize(R.styleable.SegmentedButtonGroup_selectedBorderDashGap, 0);
        this.position = typedArray.getInt(R.styleable.SegmentedButtonGroup_position, 0);
        this.draggable = typedArray.getBoolean(R.styleable.SegmentedButtonGroup_draggable, false);
        this.setClickable(typedArray.getBoolean(R.styleable.SegmentedButtonGroup_android_clickable, true));
        this.ripple = typedArray.getBoolean(R.styleable.SegmentedButtonGroup_ripple, true);
        this.hasRippleColor = typedArray.hasValue(R.styleable.SegmentedButtonGroup_rippleColor);
        this.rippleColor = typedArray.getColor(R.styleable.SegmentedButtonGroup_rippleColor, -7829368);
        int dividerWidth = typedArray.getDimensionPixelSize(R.styleable.SegmentedButtonGroup_dividerWidth, 1);
        int dividerRadius = typedArray.getDimensionPixelSize(R.styleable.SegmentedButtonGroup_dividerRadius, 0);
        int dividerPadding = typedArray.getDimensionPixelSize(R.styleable.SegmentedButtonGroup_dividerPadding, 0);
        TypedValue value = new TypedValue();
        if (typedArray.getValue(R.styleable.SegmentedButtonGroup_divider, value)) {
            if (value.type == 1 || value.type == 3) {
                if (this.isInEditMode()) {
                    this.setDivider(typedArray.getDrawable(R.styleable.SegmentedButtonGroup_divider), dividerWidth, dividerRadius, dividerPadding);
                } else {
                    this.setDivider(ContextCompat.getDrawable((Context)context, (int)value.resourceId), dividerWidth, dividerRadius, dividerPadding);
                }
            } else if (value.type >= 28 && value.type <= 31) {
                this.setDivider(value.data, dividerWidth, dividerRadius, dividerPadding);
            } else {
                throw new IllegalArgumentException("Invalid type for SegmentedButtonGroup divider in layout XML resource. Must be a color or drawable");
            }
        }
        int selectionAnimationInterpolator = typedArray.getInt(R.styleable.SegmentedButtonGroup_selectionAnimationInterpolator, 0);
        this.setSelectionAnimationInterpolator(selectionAnimationInterpolator);
        this.selectionAnimationDuration = typedArray.getInt(R.styleable.SegmentedButtonGroup_selectionAnimationDuration, 500);
        typedArray.recycle();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        ButtonActor buttonActor;
        if (child instanceof SegmentedButton) {
            SegmentedButton button_;
            int i;
            boolean isLTR = this.getResources().getConfiguration().getLayoutDirection() == 0;
            SegmentedButton button = (SegmentedButton)child;
            int position = this.buttons.size();
            button.setBackgroundRadius(this.radius);
            button.setSelectedButtonRadius(this.selectedButtonRadius);
            button.setDefaultBackground(this.backgroundDrawable);
            button.setDefaultSelectedBackground(this.selectedBackgroundDrawable);
            button._setOnVisibilityChangedListener((button1, visibility) -> {
                SegmentedButton button_;
                int i;
                int index1 = this.buttonLayout.indexOfChild((View)button1);
                this.dividerLayout.getChildAt(index1 * 2).setVisibility(visibility);
                this.dividerLayout.getChildAt(index1 * 2 - 1).setVisibility(visibility);
                SegmentedButton leftButton = null;
                if (isLTR) {
                    for (i = index1 - 1; i >= 0; --i) {
                        button_ = this.buttons.get(i);
                        if (button_.getVisibility() == 8) continue;
                        leftButton = button_;
                        break;
                    }
                } else {
                    for (i = index1 + 1; i < this.buttons.size(); ++i) {
                        button_ = this.buttons.get(i);
                        if (button_.getVisibility() == 8) continue;
                        leftButton = button_;
                        break;
                    }
                }
                SegmentedButton rightButton = null;
                if (isLTR) {
                    for (int i2 = index1 + 1; i2 < this.buttons.size(); ++i2) {
                        SegmentedButton button_2 = this.buttons.get(i2);
                        if (button_2.getVisibility() == 8) continue;
                        rightButton = button_2;
                        break;
                    }
                } else {
                    for (int i3 = index1 - 1; i3 >= 0; --i3) {
                        SegmentedButton button_3 = this.buttons.get(i3);
                        if (button_3.getVisibility() == 8) continue;
                        rightButton = button_3;
                        break;
                    }
                }
                if (visibility == 8) {
                    if (leftButton != null) {
                        leftButton.setRightButton(rightButton);
                        leftButton.setupBackgroundClipPath();
                    }
                    if (rightButton != null) {
                        rightButton.setLeftButton(leftButton);
                        rightButton.setupBackgroundClipPath();
                    }
                } else {
                    button1.setLeftButton(leftButton);
                    button1.setRightButton(rightButton);
                    button1.setupBackgroundClipPath();
                    if (leftButton != null) {
                        leftButton.setRightButton(button1);
                        leftButton.setupBackgroundClipPath();
                    }
                    if (rightButton != null) {
                        rightButton.setLeftButton(button1);
                        rightButton.setupBackgroundClipPath();
                    }
                }
            });
            if (this.ripple && this.hasRippleColor) {
                button.setRipple(this.rippleColor);
            } else if (!this.ripple) {
                button.setRipple(false);
            }
            if (isLTR && position != 0) {
                SegmentedButton leftButton = null;
                for (i = this.buttons.size() - 1; i >= 0; --i) {
                    button_ = this.buttons.get(i);
                    if (button_.getVisibility() == 8) continue;
                    leftButton = button_;
                    break;
                }
                if (leftButton != null) {
                    leftButton.setRightButton(button.getVisibility() != 8 ? button : null);
                    leftButton.setupBackgroundClipPath();
                }
                button.setLeftButton(leftButton);
            } else if (!isLTR && position != 0) {
                SegmentedButton rightButton = null;
                for (i = this.buttons.size() - 1; i >= 0; --i) {
                    button_ = this.buttons.get(i);
                    if (button_.getVisibility() == 8) continue;
                    rightButton = button_;
                    break;
                }
                if (rightButton != null) {
                    rightButton.setLeftButton(button.getVisibility() != 8 ? button : null);
                    rightButton.setupBackgroundClipPath();
                }
                button.setRightButton(rightButton);
            }
            button.setupBackgroundClipPath();
            button.setupSelectedButtonClipPath();
            button.setSelectedButtonBorder(this.selectedBorderWidth, this.selectedBorderColor, this.selectedBorderDashWidth, this.selectedBorderDashGap);
            button.setOnClickListener(this::onClick);
            this.buttonLayout.addView((View)button, params);
            this.buttons.add(button);
            if (this.position == position) {
                this.updateSelectedPosition(position, isLTR);
            }
            buttonActor = new ButtonActor(this.getContext());
            buttonActor.setButton(button);
            buttonActor.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            buttonActor.setVisibility(button.getVisibility());
            Drawable dividerDrawable = this.dividerLayout.getDividerDrawable();
            if (dividerDrawable != null) {
                buttonActor.setDividerWidth(dividerDrawable.getIntrinsicWidth());
            }
            if (isLTR && !button.isLeftButton() || !isLTR && !button.isRightButton()) {
                Divider divider = new Divider(this.getContext());
                divider.setButton(button);
                divider.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                divider.setVisibility(button.getVisibility());
                this.dividerLayout.addView((View)divider);
                if (dividerDrawable != null) {
                    this.setDividersDrawable(dividerDrawable, dividerDrawable.getIntrinsicWidth(), this.dividerLayout.getDividerPadding());
                } else {
                    this.setDividersDrawable(null, 0, this.dividerLayout.getDividerPadding());
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid child view for SegmentedButtonGroup. Only SegmentedButton's are valid children of the group");
        }
        this.dividerLayout.addView((View)buttonActor);
    }

    int getButtonPositionFromX(float x) {
        int i;
        boolean isLTR = this.getResources().getConfiguration().getLayoutDirection() == 0;
        for (i = 0; i < this.buttons.size(); ++i) {
            SegmentedButton button = this.buttons.get(i);
            if (isLTR ? button.getVisibility() != 8 && x <= (float)button.getRight() : button.getVisibility() != 8 && x >= (float)button.getLeft()) break;
        }
        return i;
    }

    float getButtonPositionFromXF(float x) {
        int i;
        boolean isLTR = this.getResources().getConfiguration().getLayoutDirection() == 0;
        for (i = 0; i < this.buttons.size(); ++i) {
            SegmentedButton button = this.buttons.get(i);
            if (isLTR) {
                if (button.getVisibility() == 8 || !(x < (float)button.getRight())) continue;
                return (float)i + (x - (float)button.getLeft()) / (float)button.getWidth();
            }
            if (button.getVisibility() == 8 || !(x > (float)button.getLeft())) continue;
            return (float)(i - 1 + 1) - (x - (float)button.getLeft()) / (float)button.getWidth();
        }
        return i;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (!this.isEnabled() || !this.isClickable()) {
            return false;
        }
        switch (ev.getAction()) {
            case 1: {
                int position = this.getButtonPositionFromX(ev.getX());
                this.setPosition(position, true);
                this.requestDisallowInterceptTouchEvent(false);
                break;
            }
            case 0: {
                int position = this.getButtonPositionFromX(ev.getX());
                if (!this.draggable || this.position != position || this.buttonAnimator != null && this.buttonAnimator.isRunning()) {
                    this.dragOffsetX = Float.NaN;
                    break;
                }
                this.requestDisallowInterceptTouchEvent(true);
                this.dragOffsetX = ev.getX() - (float)this.buttons.get(position).getLeft();
                return true;
            }
            case 2: {
                if (Float.isNaN(this.dragOffsetX)) break;
                float xCoord = ev.getX() - this.dragOffsetX;
                float newPosition = Math.min(Math.max(this.getButtonPositionFromXF(xCoord), 0.0f), (float)(this.buttons.size() - 1));
                this.moveSelectedButton(newPosition);
                break;
            }
            case 3: {
                if (Float.isNaN(this.dragOffsetX)) break;
                this.setPosition(Math.round(this.currentPosition), true);
                this.requestDisallowInterceptTouchEvent(false);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private void moveSelectedButton(float position) {
        int lastEndPosition;
        int currentEndButtonPosition;
        boolean isLTR = this.getResources().getConfiguration().getLayoutDirection() == 0;
        this.currentPosition = position;
        int currentButtonPosition = (int)this.currentPosition;
        float currentOffset = this.currentPosition - (float)currentButtonPosition;
        for (currentEndButtonPosition = currentButtonPosition + 1; currentEndButtonPosition < this.buttons.size() && this.buttons.get(currentEndButtonPosition).getVisibility() == 8; ++currentEndButtonPosition) {
        }
        SegmentedButton currentButton = this.buttons.get(currentButtonPosition);
        if (isLTR) {
            currentButton.clipRight(currentOffset);
        } else {
            currentButton.clipLeft(currentOffset);
        }
        if (currentEndButtonPosition >= 0 && currentEndButtonPosition < this.buttons.size()) {
            SegmentedButton currentEndButton = this.buttons.get(currentEndButtonPosition);
            if (isLTR) {
                currentEndButton.clipLeft(currentOffset);
            } else {
                currentEndButton.clipRight(currentOffset);
            }
        }
        if (this.lastPosition != currentButtonPosition && this.lastPosition != currentEndButtonPosition) {
            if (isLTR) {
                this.buttons.get(this.lastPosition).clipRight(1.0f);
            } else {
                this.buttons.get(this.lastPosition).clipRight(0.0f);
            }
        }
        for (lastEndPosition = this.lastPosition + 1; lastEndPosition < this.buttons.size() && this.buttons.get(lastEndPosition).getVisibility() == 8; ++lastEndPosition) {
        }
        if (lastEndPosition != currentEndButtonPosition && lastEndPosition != currentButtonPosition && lastEndPosition < this.buttons.size()) {
            if (isLTR) {
                this.buttons.get(lastEndPosition).clipRight(1.0f);
            } else {
                this.buttons.get(lastEndPosition).clipRight(0.0f);
            }
        }
        this.lastPosition = currentButtonPosition;
        this.invalidate();
    }

    private void updateSelectedPosition(int position, boolean isLTR) {
        this.position = position;
        this.currentPosition = position;
        this.lastPosition = position;
        for (int i = 0; i < this.buttons.size(); ++i) {
            SegmentedButton button = this.buttons.get(i);
            if (i == position) {
                if (isLTR) {
                    button.clipRight(0.0f);
                    continue;
                }
                button.clipRight(1.0f);
                continue;
            }
            if (isLTR) {
                button.clipRight(1.0f);
                continue;
            }
            button.clipRight(0.0f);
        }
        if (this.onPositionChangedListener != null) {
            this.onPositionChangedListener.onPositionChanged(position);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putInt("position", this.position);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof Bundle)) {
            super.onRestoreInstanceState(state);
            return;
        }
        Bundle bundle = (Bundle)state;
        int position = bundle.getInt("position");
        this.setPosition(position, false);
        super.onRestoreInstanceState(bundle.getParcelable("superState"));
    }

    public ArrayList<SegmentedButton> getButtons() {
        return this.buttons;
    }

    public SegmentedButton getButton(int index) {
        return this.buttons.get(index);
    }

    public Drawable getBackground() {
        return this.backgroundDrawable;
    }

    public void setBackground(Drawable drawable) {
        this.backgroundDrawable = drawable;
        if (this.buttons != null) {
            for (SegmentedButton button : this.buttons) {
                button.setBackground(drawable);
            }
        }
    }

    public void setBackground(@ColorInt int color) {
        if (this.backgroundDrawable instanceof ColorDrawable) {
            ((ColorDrawable)this.backgroundDrawable.mutate()).setColor(color);
            this.setBackground(this.backgroundDrawable);
        } else {
            this.setBackground((Drawable)new ColorDrawable(color));
        }
    }

    public void setBackgroundColor(@ColorInt int color) {
        this.setBackground(color);
    }

    public Drawable getSelectedBackground() {
        return this.selectedBackgroundDrawable;
    }

    public void setSelectedBackground(Drawable drawable) {
        this.selectedBackgroundDrawable = drawable;
        for (SegmentedButton button : this.buttons) {
            button.setSelectedBackground(drawable);
        }
    }

    public void setSelectedBackground(@ColorInt int color) {
        if (this.selectedBackgroundDrawable instanceof ColorDrawable) {
            ((ColorDrawable)this.selectedBackgroundDrawable.mutate()).setColor(color);
            this.setSelectedBackground(this.selectedBackgroundDrawable);
        } else {
            this.setSelectedBackground((Drawable)new ColorDrawable(color));
        }
    }

    public void setSelectedBackgroundColor(@ColorInt int color) {
        this.setSelectedBackground(color);
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public int getBorderDashWidth() {
        return this.borderDashWidth;
    }

    public int getBorderDashGap() {
        return this.borderDashGap;
    }

    public void setBorder(int width, @ColorInt int color, int dashWidth, int dashGap) {
        this.borderWidth = width;
        this.borderColor = color;
        this.borderDashWidth = dashWidth;
        this.borderDashGap = dashGap;
        if (width > 0) {
            GradientDrawable borderDrawable = new GradientDrawable();
            borderDrawable.setColor(0);
            borderDrawable.setCornerRadius((float)this.radius - (float)width / 2.0f);
            borderDrawable.setStroke(width, color, (float)dashWidth, (float)dashGap);
            this.borderView.setBackground((Drawable)borderDrawable);
        } else {
            this.borderView.setBackground(null);
        }
    }

    public int getSelectedBorderWidth() {
        return this.selectedBorderWidth;
    }

    public int getSelectedBorderColor() {
        return this.selectedBorderColor;
    }

    public int getSelectedBorderDashWidth() {
        return this.selectedBorderDashWidth;
    }

    public int getSelectedBorderDashGap() {
        return this.selectedBorderDashGap;
    }

    public void setSelectedBorder(int width, @ColorInt int color, int dashWidth, int dashGap) {
        this.selectedBorderWidth = width;
        this.selectedBorderColor = color;
        this.selectedBorderDashWidth = dashWidth;
        this.selectedBorderDashGap = dashGap;
        for (SegmentedButton button : this.buttons) {
            button.setSelectedButtonBorder(width, color, dashWidth, dashGap);
        }
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        for (SegmentedButton button : this.buttons) {
            button.setBackgroundRadius(radius);
            button.setupBackgroundClipPath();
            button.invalidate();
        }
        GradientDrawable borderDrawable = (GradientDrawable)this.borderView.getBackground();
        if (borderDrawable != null) {
            borderDrawable.setCornerRadius((float)radius - (float)this.borderWidth / 2.0f);
        }
        this.invalidateOutline();
    }

    public int getSelectedButtonRadius() {
        return this.selectedButtonRadius;
    }

    public void setSelectedButtonRadius(int selectedButtonRadius) {
        this.selectedButtonRadius = selectedButtonRadius;
        for (SegmentedButton button : this.buttons) {
            button.setSelectedButtonRadius(selectedButtonRadius);
            button.setupSelectedButtonClipPath();
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(final int position, boolean animate) {
        boolean movingRight;
        boolean isLTR;
        boolean bl = isLTR = this.getResources().getConfiguration().getLayoutDirection() == 0;
        if (position < 0 || position >= this.buttons.size() || position == this.position && this.buttonAnimator != null && !this.buttonAnimator.isRunning() && Float.isNaN(this.dragOffsetX)) {
            return;
        }
        if (!animate || this.selectionAnimationInterpolator == null) {
            this.updateSelectedPosition(position, isLTR);
            return;
        }
        ArrayList<Integer> buttonGoneIndices = new ArrayList<Integer>();
        if (isLTR) {
            boolean bl2 = movingRight = this.currentPosition < (float)position;
            if (movingRight) {
                for (int i = (int)Math.ceil(this.currentPosition); i < position; ++i) {
                    if (this.buttons.get(i).getVisibility() != 8) continue;
                    buttonGoneIndices.add(i);
                }
            } else {
                for (int i = (int)Math.floor(this.currentPosition); i > position; --i) {
                    if (this.buttons.get(i).getVisibility() != 8) continue;
                    buttonGoneIndices.add(i + 1);
                }
            }
            this.buttonAnimator = ValueAnimator.ofFloat((float[])new float[]{this.currentPosition, movingRight ? (float)(position - buttonGoneIndices.size()) : (float)(position + buttonGoneIndices.size())});
        } else {
            boolean bl3 = movingRight = this.currentPosition > (float)position;
            if (movingRight) {
                for (int i = (int)Math.floor(this.currentPosition); i > position; --i) {
                    if (this.buttons.get(i).getVisibility() != 8) continue;
                    buttonGoneIndices.add(i + 1);
                }
            } else {
                for (int i = (int)Math.ceil(this.currentPosition); i < position; ++i) {
                    if (this.buttons.get(i).getVisibility() != 8) continue;
                    buttonGoneIndices.add(i);
                }
            }
            this.buttonAnimator = ValueAnimator.ofFloat((float[])new float[]{this.currentPosition, movingRight ? (float)(position + buttonGoneIndices.size()) : (float)(position - buttonGoneIndices.size())});
        }
        this.buttonAnimator.addUpdateListener(animation -> {
            float value = ((Float)animation.getAnimatedValue()).floatValue();
            Iterator iterator = buttonGoneIndices.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                if (isLTR) {
                    if (movingRight && value >= (float)index) {
                        value += 1.0f;
                        continue;
                    }
                    if (movingRight || !(value <= (float)index)) continue;
                    value -= 1.0f;
                    continue;
                }
                if (movingRight && value <= (float)index) {
                    value -= 1.0f;
                    continue;
                }
                if (movingRight || !(value >= (float)index)) continue;
                value += 1.0f;
            }
            this.moveSelectedButton(value);
        });
        this.buttonAnimator.setDuration((long)this.selectionAnimationDuration);
        this.buttonAnimator.setInterpolator((TimeInterpolator)this.selectionAnimationInterpolator);
        this.buttonAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SegmentedButtonGroup.this.updateSelectedPosition(position, isLTR);
            }
        });
        this.buttonAnimator.start();
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public boolean hasRipple() {
        return this.ripple;
    }

    public int getRippleColor() {
        return this.rippleColor;
    }

    public void setRipple(boolean enabled) {
        this.ripple = enabled;
        for (SegmentedButton button : this.buttons) {
            button.setRipple(enabled);
        }
    }

    public void setRipple(@ColorInt int color) {
        this.ripple = true;
        this.rippleColor = color;
        for (SegmentedButton button : this.buttons) {
            button.setRipple(color);
        }
    }

    public Drawable getDivider() {
        return this.dividerLayout.getDividerDrawable();
    }

    public void setDivider(@Nullable Drawable drawable, int width, int radius, int padding) {
        if (drawable == null) {
            this.dividerLayout.setDividerDrawable(null);
            this.dividerLayout.setShowDividers(0);
            this.setDividersDrawable(null, 0, 0);
            return;
        }
        if (drawable instanceof GradientDrawable) {
            GradientDrawable gradient = (GradientDrawable)drawable;
            gradient.setSize(width, 0);
            gradient.setCornerRadius((float)radius);
            this.dividerLayout.setDividerDrawable((Drawable)gradient);
            this.setDividersDrawable((Drawable)gradient, width, padding);
        } else {
            this.dividerLayout.setDividerDrawable(drawable);
            this.setDividersDrawable(drawable, width, padding);
        }
        this.dividerLayout.setDividerPadding(padding);
        this.dividerLayout.setShowDividers(0);
        for (int i = 0; i < this.dividerLayout.getChildCount(); ++i) {
            ButtonActor view = (ButtonActor)this.dividerLayout.getChildAt(i);
            view.setDividerWidth(width);
        }
        this.dividerLayout.requestLayout();
    }

    public void setDivider(@ColorInt int color, int width, int radius, int padding) {
        GradientDrawable drawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{color, color});
        drawable.setCornerRadius((float)radius);
        drawable.setShape(0);
        drawable.setSize(width, 0);
        this.dividerLayout.setDividerDrawable((Drawable)drawable);
        this.dividerLayout.setDividerPadding(padding);
        this.dividerLayout.setShowDividers(0);
        this.setDividersDrawable((Drawable)drawable, width, padding);
        for (int i = 0; i < this.dividerLayout.getChildCount(); ++i) {
            ButtonActor view = (ButtonActor)this.dividerLayout.getChildAt(i);
            view.setDividerWidth(width);
        }
        this.dividerLayout.requestLayout();
    }

    public void setDividersDrawable(Drawable drawable, int width, int padding) {
        for (int i = 0; i < this.dividerLayout.getChildCount(); ++i) {
            if (!(this.dividerLayout.getChildAt(i) instanceof Divider)) continue;
            Divider view = (Divider)this.dividerLayout.getChildAt(i);
            view.setWidth(width);
            view.setVerticalPadding(padding);
            if (drawable == null) {
                view.setVisibility(8);
                continue;
            }
            view.setBackground(drawable);
        }
        this.dividerLayout.requestLayout();
    }

    public Interpolator getSelectionAnimationInterpolator() {
        return this.selectionAnimationInterpolator;
    }

    public void setSelectionAnimationInterpolator(@Nullable Interpolator interpolator) {
        this.selectionAnimationInterpolator = interpolator;
    }

    public void setSelectionAnimationInterpolator(int interpolator) {
        switch (interpolator) {
            case -1: {
                this.selectionAnimationInterpolator = null;
                break;
            }
            case 0: {
                this.selectionAnimationInterpolator = new FastOutSlowInInterpolator();
                break;
            }
            case 1: {
                this.selectionAnimationInterpolator = new BounceInterpolator();
                break;
            }
            case 2: {
                this.selectionAnimationInterpolator = new LinearInterpolator();
                break;
            }
            case 3: {
                this.selectionAnimationInterpolator = new DecelerateInterpolator();
                break;
            }
            case 4: {
                this.selectionAnimationInterpolator = new CycleInterpolator(1.0f);
                break;
            }
            case 5: {
                this.selectionAnimationInterpolator = new AnticipateInterpolator();
                break;
            }
            case 6: {
                this.selectionAnimationInterpolator = new AccelerateDecelerateInterpolator();
                break;
            }
            case 7: {
                this.selectionAnimationInterpolator = new AccelerateInterpolator();
                break;
            }
            case 8: {
                this.selectionAnimationInterpolator = new AnticipateOvershootInterpolator();
                break;
            }
            case 9: {
                this.selectionAnimationInterpolator = new FastOutLinearInInterpolator();
                break;
            }
            case 10: {
                this.selectionAnimationInterpolator = new LinearOutSlowInInterpolator();
                break;
            }
            case 11: {
                this.selectionAnimationInterpolator = new OvershootInterpolator();
            }
        }
    }

    public int getSelectionAnimationDuration() {
        return this.selectionAnimationDuration;
    }

    public void setSelectionAnimationDuration(int selectionAnimationDuration) {
        this.selectionAnimationDuration = selectionAnimationDuration;
    }

    public OnPositionChangedListener getOnPositionChangedListener() {
        return this.onPositionChangedListener;
    }

    public void setOnPositionChangedListener(OnPositionChangedListener onPositionChangedListener) {
        this.onPositionChangedListener = onPositionChangedListener;
    }

    public void setOnClickListener(OnClickListener clickListener) {
        this.clickListener = clickListener;
    }

    public void onClick(View v) {
        if (this.clickListener != null) {
            this.clickListener.onClick(v);
        }
    }

    @RequiresApi(api=21)
    private class OutlineProvider
    extends ViewOutlineProvider {
        private OutlineProvider() {
        }

        public void getOutline(View view, Outline outline) {
            outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), (float)SegmentedButtonGroup.this.radius);
        }
    }

    public static interface OnClickListener {
        public void onClick(View var1);
    }

    public static interface OnPositionChangedListener {
        public void onPositionChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AnimationInterpolator {
    }
}

