/*
 * Decompiled with CFR 0.152.
 */
package top.wefor.circularanim;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.widget.ImageView;

public class CircularAnimUtil {
    public static final long PERFECT_MILLS = 618L;
    public static final int MINI_RADIUS = 0;
    private static final int FINISH_NONE = 0;
    private static final int FINISH_SINGLE = 1;
    private static final int FINISH_ALL = 3;

    @SuppressLint(value={"NewApi"})
    private static void actionVisible(boolean isShow, final View myView, float miniRadius, long durationMills) {
        float endRadius;
        float startRadius;
        if (Build.VERSION.SDK_INT < 21) {
            if (isShow) {
                myView.setVisibility(0);
            } else {
                myView.setVisibility(4);
            }
            return;
        }
        int cx = (myView.getLeft() + myView.getRight()) / 2;
        int cy = (myView.getTop() + myView.getBottom()) / 2;
        int w = myView.getWidth();
        int h = myView.getHeight();
        int maxRadius = (int)Math.sqrt(w * w + h * h) + 1;
        if (isShow) {
            startRadius = miniRadius;
            endRadius = maxRadius;
        } else {
            startRadius = maxRadius;
            endRadius = miniRadius;
        }
        Animator anim2 = ViewAnimationUtils.createCircularReveal((View)myView, (int)cx, (int)cy, (float)startRadius, (float)endRadius);
        myView.setVisibility(0);
        anim2.setDuration(durationMills);
        if (!isShow) {
            anim2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    myView.setVisibility(4);
                }
            });
        }
        anim2.start();
    }

    @SuppressLint(value={"NewApi"})
    private static void actionOtherVisible(boolean isShow, View triggerView, final View animView, float miniRadius, long durationMills) {
        float endRadius;
        float startRadius;
        if (Build.VERSION.SDK_INT < 21) {
            if (isShow) {
                animView.setVisibility(0);
            } else {
                animView.setVisibility(4);
            }
            return;
        }
        int[] tvLocation = new int[2];
        triggerView.getLocationInWindow(tvLocation);
        int tvCX = tvLocation[0] + triggerView.getWidth() / 2;
        int tvCY = tvLocation[1] + triggerView.getHeight() / 2;
        int[] avLocation = new int[2];
        animView.getLocationInWindow(avLocation);
        int avLX = avLocation[0];
        int avTY = avLocation[1];
        int triggerX = Math.max(avLX, tvCX);
        triggerX = Math.min(triggerX, avLX + animView.getWidth());
        int triggerY = Math.max(avTY, tvCY);
        triggerY = Math.min(triggerY, avTY + animView.getHeight());
        int avW = animView.getWidth();
        int avH = animView.getHeight();
        int rippleCX = triggerX - avLX;
        int rippleCY = triggerY - avTY;
        int maxW = Math.max(rippleCX, avW - rippleCX);
        int maxH = Math.max(rippleCY, avH - rippleCY);
        int maxRadius = (int)Math.sqrt(maxW * maxW + maxH * maxH) + 1;
        if (isShow) {
            startRadius = miniRadius;
            endRadius = maxRadius;
        } else {
            startRadius = maxRadius;
            endRadius = miniRadius;
        }
        Animator anim2 = ViewAnimationUtils.createCircularReveal((View)animView, (int)rippleCX, (int)rippleCY, (float)startRadius, (float)endRadius);
        animView.setVisibility(0);
        anim2.setDuration(durationMills);
        if (!isShow) {
            anim2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    animView.setVisibility(4);
                }
            });
        }
        anim2.start();
    }

    private static void startActivityOrFinish(int finishType, Activity thisActivity, Intent intent, Integer requestCode, Bundle bundle) {
        if (requestCode == null) {
            thisActivity.startActivity(intent);
        } else if (bundle == null) {
            thisActivity.startActivityForResult(intent, requestCode.intValue());
        } else if (Build.VERSION.SDK_INT >= 16) {
            thisActivity.startActivityForResult(intent, requestCode.intValue(), bundle);
        } else {
            thisActivity.startActivityForResult(intent, requestCode.intValue());
        }
        switch (finishType) {
            case 1: {
                thisActivity.finish();
                break;
            }
            case 3: {
                if (Build.VERSION.SDK_INT >= 16) {
                    thisActivity.finishAffinity();
                    break;
                }
                thisActivity.finish();
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private static void actionStarActivity(final int finishType, final Activity thisActivity, final Intent intent, final Integer requestCode, final Bundle bundle, final View triggerView, int colorOrImageRes, long durationMills) {
        if (Build.VERSION.SDK_INT < 21) {
            CircularAnimUtil.startActivityOrFinish(finishType, thisActivity, intent, requestCode, bundle);
            return;
        }
        int[] location = new int[2];
        triggerView.getLocationInWindow(location);
        final int cx = location[0] + triggerView.getWidth() / 2;
        final int cy = location[1] + triggerView.getHeight() / 2;
        final ImageView view = new ImageView((Context)thisActivity);
        view.setScaleType(ImageView.ScaleType.CENTER_CROP);
        view.setImageResource(colorOrImageRes);
        final ViewGroup decorView = (ViewGroup)thisActivity.getWindow().getDecorView();
        int w = decorView.getWidth();
        int h = decorView.getHeight();
        decorView.addView((View)view, w, h);
        int maxW = Math.max(cx, w - cx);
        int maxH = Math.max(cy, h - cy);
        final int finalRadius = (int)Math.sqrt(maxW * maxW + maxH * maxH) + 1;
        Animator anim2 = ViewAnimationUtils.createCircularReveal((View)view, (int)cx, (int)cy, (float)0.0f, (float)finalRadius);
        int maxRadius = (int)Math.sqrt(w * w + h * h) + 1;
        if (durationMills == 618L) {
            double rate = 1.0 * (double)finalRadius / (double)maxRadius;
            durationMills = (long)(618.0 * Math.sqrt(rate));
        }
        final long finalDuration = durationMills;
        anim2.setDuration((long)((double)finalDuration * 0.9));
        anim2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (requestCode == null) {
                    thisActivity.startActivity(intent);
                } else if (bundle == null) {
                    thisActivity.startActivityForResult(intent, requestCode.intValue());
                } else {
                    thisActivity.startActivityForResult(intent, requestCode.intValue(), bundle);
                }
                thisActivity.overridePendingTransition(0x10A0000, 0x10A0001);
                switch (finishType) {
                    case 0: {
                        triggerView.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                Animator anim2 = ViewAnimationUtils.createCircularReveal((View)view, (int)cx, (int)cy, (float)finalRadius, (float)0.0f);
                                anim2.setDuration(finalDuration);
                                anim2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                                    public void onAnimationEnd(Animator animation) {
                                        super.onAnimationEnd(animation);
                                        try {
                                            decorView.removeView((View)view);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                });
                                anim2.start();
                            }
                        }, 1000L);
                        break;
                    }
                    case 1: {
                        thisActivity.finish();
                        break;
                    }
                    case 3: {
                        thisActivity.finishAffinity();
                    }
                }
            }
        });
        anim2.start();
    }

    public static void show(View myView, float startRadius, long durationMills) {
        CircularAnimUtil.actionVisible(true, myView, startRadius, durationMills);
    }

    public static void hide(View myView, float endRadius, long durationMills) {
        CircularAnimUtil.actionVisible(false, myView, endRadius, durationMills);
    }

    public static void startActivityForResult(Activity thisActivity, Intent intent, Integer requestCode, Bundle bundle, View triggerView, int colorOrImageRes, long durationMills) {
        CircularAnimUtil.actionStarActivity(0, thisActivity, intent, requestCode, bundle, triggerView, colorOrImageRes, durationMills);
    }

    public static void startActivityThenFinish(Activity thisActivity, Intent intent, boolean isFinishAffinity, View triggerView, int colorOrImageRes, long durationMills) {
        int finishType = isFinishAffinity ? 3 : 1;
        CircularAnimUtil.actionStarActivity(finishType, thisActivity, intent, null, null, triggerView, colorOrImageRes, durationMills);
    }

    public static void startActivityForResult(Activity thisActivity, Intent intent, Integer requestCode, View triggerView, int colorOrImageRes) {
        CircularAnimUtil.startActivityForResult(thisActivity, intent, requestCode, null, triggerView, colorOrImageRes, 618L);
    }

    public static void startActivity(Activity thisActivity, Intent intent, View triggerView, int colorOrImageRes, long durationMills) {
        CircularAnimUtil.startActivityForResult(thisActivity, intent, null, null, triggerView, colorOrImageRes, durationMills);
    }

    public static void startActivity(Activity thisActivity, Intent intent, View triggerView, int colorOrImageRes) {
        CircularAnimUtil.startActivity(thisActivity, intent, triggerView, colorOrImageRes, 618L);
    }

    public static void startActivity(Activity thisActivity, Class<?> targetClass, View triggerView, int colorOrImageRes) {
        CircularAnimUtil.startActivity(thisActivity, new Intent((Context)thisActivity, targetClass), triggerView, colorOrImageRes, 618L);
    }

    public static void startActivityThenFinish(Activity thisActivity, Intent intent, View triggerView, int colorOrImageRes) {
        CircularAnimUtil.startActivityThenFinish(thisActivity, intent, false, triggerView, colorOrImageRes, 618L);
    }

    public static void show(View myView) {
        CircularAnimUtil.show(myView, 0.0f, 618L);
    }

    public static void hide(View myView) {
        CircularAnimUtil.hide(myView, 0.0f, 618L);
    }

    public static void showOther(View triggerView, View otherView) {
        CircularAnimUtil.actionOtherVisible(true, triggerView, otherView, 0.0f, 618L);
    }

    public static void hideOther(View triggerView, View otherView) {
        CircularAnimUtil.actionOtherVisible(false, triggerView, otherView, 0.0f, 618L);
    }
}

