/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.log.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import xdean.jex.log.Log;

public class JulLog
implements Log {
    private final Logger logger;

    public JulLog(String name) {
        this.logger = Logger.getLogger(name);
    }

    @Override
    public Log.SubLog trace() {
        return new JulSubLog(Level.FINEST);
    }

    @Override
    public Log.SubLog debug() {
        return new JulSubLog(Level.FINER);
    }

    @Override
    public Log.SubLog info() {
        return new JulSubLog(Level.INFO);
    }

    @Override
    public Log.SubLog warn() {
        return new JulSubLog(Level.WARNING);
    }

    @Override
    public Log.SubLog error() {
        return new JulSubLog(Level.SEVERE);
    }

    private class JulSubLog
    implements Log.SubLog {
        private final Level level;

        public JulSubLog(Level level) {
            this.level = level;
        }

        @Override
        public boolean isEnable() {
            return JulLog.this.logger.isLoggable(this.level);
        }

        @Override
        public void log(String msg) {
            JulLog.this.logger.log(this.level, msg);
        }

        @Override
        public void log(String msg, Object param1) {
            JulLog.this.logger.log(this.level, msg, param1);
        }

        @Override
        public void log(String msg, Object ... params) {
            JulLog.this.logger.log(this.level, msg, params);
        }

        @Override
        public void log(String msg, Throwable thrown) {
            JulLog.this.logger.log(this.level, msg, thrown);
        }
    }
}

