/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.reflect;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.function.Function;
import java.util.function.Supplier;
import xdean.jex.log.Logable;

public class TypeVisitor<T>
implements Logable {
    private Type type;
    private T result;
    private boolean visited;

    public static <T> TypeVisitor<T> create(Type type) {
        return new TypeVisitor<T>(type);
    }

    public static <T> T of(Type type, Function<TypeVisitor<T>, T> function) {
        return function.apply(TypeVisitor.create(type));
    }

    public TypeVisitor(Type type) {
        this.type = type;
    }

    public TypeVisitor<T> onClass(Function<Class, T> function) {
        return this.on(Class.class, function);
    }

    public TypeVisitor<T> onTypeVariable(Function<TypeVariable, T> function) {
        return this.on(TypeVariable.class, function);
    }

    public TypeVisitor<T> onParameterizedType(Function<ParameterizedType, T> function) {
        return this.on(ParameterizedType.class, function);
    }

    public TypeVisitor<T> onWildcardType(Function<WildcardType, T> function) {
        return this.on(WildcardType.class, function);
    }

    public TypeVisitor<T> onGenericArrayType(Function<GenericArrayType, T> function) {
        return this.on(GenericArrayType.class, function);
    }

    public T result() {
        if (!this.visited) {
            throw new IllegalStateException("The type haven't been visited: " + this.type);
        }
        return this.result;
    }

    public T result(T defaultValue) {
        if (!this.visited) {
            this.trace().log("The type haven't been visited: " + this.type);
            return defaultValue;
        }
        return this.result;
    }

    public T result(Supplier<T> defaultValueSupplier) {
        if (!this.visited) {
            this.trace().log("The type haven't been visited: " + this.type);
            return defaultValueSupplier.get();
        }
        return this.result;
    }

    public <K extends Type> TypeVisitor<T> on(Class<K> klass, Function<K, T> action) {
        if (!this.visited && klass.isInstance(this.type)) {
            this.visited = true;
            this.result = action.apply(this.type);
        }
        return this;
    }
}

