/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.reflect;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import xdean.jex.util.function.FunctionAdapter;
import xdean.jex.util.lang.ExceptionUtil;
import xdean.jex.util.lang.PrimitiveTypeUtil;
import xdean.jex.util.reflect.ReflectUtil;

public class ReferenceUtil {
    public static boolean isReferencing(Object from, Object to) {
        Objects.requireNonNull(to);
        return ReferenceUtil.isReferencing(from, to, new IdentityHashMap());
    }

    private static boolean isReferencing(Object from, Object to, Map<Object, ?> visited) {
        if (from == to) {
            return true;
        }
        if (from == null || visited.containsKey(from)) {
            return false;
        }
        visited.put(from, null);
        Class<?> clz = from.getClass();
        if (clz.isArray()) {
            if (PrimitiveTypeUtil.isPrimitive(clz.getComponentType())) {
                return false;
            }
            return Stream.of((Object[])from).anyMatch(o -> ReferenceUtil.isReferencing(o, to, visited));
        }
        return Stream.of(ReflectUtil.getAllFields(clz, false)).filter(f -> !PrimitiveTypeUtil.isPrimitive(f.getType())).map(FunctionAdapter.function(f -> f.setAccessible(true))).anyMatch(f -> ReferenceUtil.isReferencing(ExceptionUtil.uncheck(() -> f.get(from)), to, visited));
    }
}

