/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.lang;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.stream.Stream;
import sun.misc.Unsafe;
import xdean.jex.log.Log;
import xdean.jex.log.LogFactory;
import xdean.jex.util.lang.ExceptionUtil;
import xdean.jex.util.lang.PrimitiveTypeUtil;
import xdean.jex.util.reflect.ReflectUtil;

public class UnsafeUtil {
    private static final Unsafe THE_UNSAFE = UnsafeUtil.initUnsafe();
    private static final int ADDRESS_SIZE = THE_UNSAFE.addressSize();
    private static final long HEADER_SIZE = UnsafeUtil.initHeaderSize();
    private static final boolean useCompressedOops = UnsafeUtil.initUseCompressedOops();
    private static final Log LOGGER = LogFactory.from(UnsafeUtil.class);

    public static Unsafe getUnsafe() {
        return THE_UNSAFE;
    }

    public static long addressOf(Object o) {
        long objectAddress;
        Object[] array = new Object[]{o};
        long baseOffset = THE_UNSAFE.arrayBaseOffset(Object[].class);
        switch (ADDRESS_SIZE) {
            case 4: {
                objectAddress = THE_UNSAFE.getInt(array, baseOffset);
                break;
            }
            case 8: {
                objectAddress = THE_UNSAFE.getLong(array, baseOffset);
                break;
            }
            default: {
                throw new IllegalStateException("unsupported address size: " + ADDRESS_SIZE);
            }
        }
        return objectAddress;
    }

    public static long shallowSizeOf(Class<?> clz) {
        if (PrimitiveTypeUtil.isPrimitive(clz)) {
            return PrimitiveTypeUtil.sizeOf(clz);
        }
        if (clz.isArray()) {
            return THE_UNSAFE.arrayBaseOffset(clz);
        }
        long maxOffset = 0L;
        Field maxField = null;
        for (Field field : ReflectUtil.getAllFields(clz, false)) {
            long offset = THE_UNSAFE.objectFieldOffset(field);
            if (offset <= maxOffset) continue;
            maxOffset = offset;
            maxField = field;
        }
        if (maxOffset == 0L) {
            maxOffset = HEADER_SIZE;
        } else {
            if (maxOffset < HEADER_SIZE) {
                throw new IllegalStateException("Can't calculate " + clz + "'s size.");
            }
            maxOffset += UnsafeUtil.refSizeOf(maxField.getType());
        }
        return UnsafeUtil.regulateSize(maxOffset);
    }

    public static long shallowSizeOf(Object o) {
        Class<?> clz = o.getClass();
        if (clz.isArray()) {
            int len = Array.getLength(o);
            return UnsafeUtil.regulateSize(THE_UNSAFE.arrayBaseOffset(clz) + THE_UNSAFE.arrayIndexScale(clz) * len);
        }
        return UnsafeUtil.shallowSizeOf(clz);
    }

    public static long sizeOf(Object o) {
        return UnsafeUtil.sizeOf(o, new IdentityHashMap<Object, Object>());
    }

    private static long sizeOf(Object o, Map<Object, Object> visited) {
        if (visited.keySet().contains(o)) {
            return 0L;
        }
        visited.put(o, null);
        if (o == null) {
            return 0L;
        }
        Class<?> clz = o.getClass();
        if (clz.isArray()) {
            long len = Array.getLength(o);
            long shallowSize = UnsafeUtil.shallowSizeOf(o);
            if (PrimitiveTypeUtil.isPrimitiveArray(clz)) {
                return shallowSize;
            }
            long size = shallowSize;
            int i = 0;
            while ((long)i < len) {
                size += UnsafeUtil.sizeOf(Array.get(o, i), visited);
                ++i;
            }
            return size;
        }
        return UnsafeUtil.shallowSizeOf(o) + Stream.of((Object[])ExceptionUtil.uncheck(() -> ReflectUtil.getAllFields(clz, false))).mapToLong(f -> {
            if (PrimitiveTypeUtil.isPrimitive(f.getType())) {
                return 0L;
            }
            f.setAccessible(true);
            return ExceptionUtil.uncheck(() -> UnsafeUtil.sizeOf(f.get(o), visited));
        }).sum();
    }

    public static long refSize() {
        return useCompressedOops ? 4L : (long)ADDRESS_SIZE;
    }

    public static long refSizeOf(Class<?> clz) {
        if (PrimitiveTypeUtil.isPrimitive(clz)) {
            return PrimitiveTypeUtil.sizeOf(clz);
        }
        return UnsafeUtil.refSize();
    }

    public static long getHeaderSize() {
        return HEADER_SIZE;
    }

    public static boolean isUsecompressedOops() {
        return useCompressedOops;
    }

    private static long regulateSize(long size) {
        return size / (long)ADDRESS_SIZE * (long)ADDRESS_SIZE + (long)(size % (long)ADDRESS_SIZE == 0L ? 0 : ADDRESS_SIZE);
    }

    private static boolean initUseCompressedOops() {
        try {
            class Helper {
                Object a;
                Object b;

                Helper() {
                }
            }
            Field a = Helper.class.getDeclaredField("a");
            Field b = Helper.class.getDeclaredField("b");
            long aOffset = THE_UNSAFE.objectFieldOffset(a);
            long bOffset = THE_UNSAFE.objectFieldOffset(b);
            return Math.abs(bOffset - aOffset) == 4L;
        }
        catch (NoSuchFieldException e) {
            throw new Error("Never happen.", e);
        }
    }

    private static long initHeaderSize() {
        class Helper {
            Object o;

            Helper() {
            }
        }
        Field[] fields = ReflectUtil.getAllFields(Helper.class, false);
        if (fields.length != 1) {
            throw new Error("Java Object don't behavior as expect. Check your java version or your code.");
        }
        Field f = fields[0];
        return THE_UNSAFE.objectFieldOffset(f);
    }

    private static Unsafe initUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException tryReflectionInstead) {
            try {
                return AccessController.doPrivileged(() -> {
                    Class<Unsafe> k = Unsafe.class;
                    for (Field f : k.getDeclaredFields()) {
                        f.setAccessible(true);
                        Object x = f.get(null);
                        if (!k.isInstance(x)) continue;
                        return (Unsafe)k.cast(x);
                    }
                    throw new NoSuchFieldError("the Unsafe");
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static {
        LOGGER.trace("address size: {0}", (Object)ADDRESS_SIZE);
        LOGGER.trace("header size: {0}", (Object)HEADER_SIZE);
        LOGGER.trace("useCompressedOops: {0}", (Object)useCompressedOops);
    }
}

