/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.lang;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Array;

public class PrimitiveTypeUtil {
    private static final BiMap<Class<?>, Class<?>> wrapperToPrimitive = HashBiMap.create();
    private static final BiMap<Class<?>, Class<?>> wrapperArrayToPrimitiveArray = HashBiMap.create();

    public static Object toPrimitiveArray(Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Must give array object.");
        }
        if (PrimitiveTypeUtil.isWrapperArray(array.getClass())) {
            int length = Array.getLength(array);
            Object newArray = Array.newInstance(PrimitiveTypeUtil.toPrimitive(array.getClass().getComponentType()), length);
            for (int i = 0; i < length; ++i) {
                Array.set(newArray, i, Array.get(array, i));
            }
            return newArray;
        }
        if (array.getClass().getComponentType().isArray()) {
            int length = Array.getLength(array);
            Object newArray = Array.newInstance(PrimitiveTypeUtil.toPrimitiveArray(array.getClass().getComponentType()), length);
            for (int i = 0; i < length; ++i) {
                Array.set(newArray, i, PrimitiveTypeUtil.toPrimitiveArray(Array.get(array, i)));
            }
            return newArray;
        }
        return array;
    }

    public static Object toWrapperArray(Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Must give array object.");
        }
        if (PrimitiveTypeUtil.isPrimitiveArray(array.getClass())) {
            int length = Array.getLength(array);
            Object newArray = Array.newInstance(PrimitiveTypeUtil.toWrapper(array.getClass().getComponentType()), length);
            for (int i = 0; i < length; ++i) {
                Array.set(newArray, i, PrimitiveTypeUtil.toWrapper(Array.get(array, i)));
            }
            return newArray;
        }
        if (array.getClass().getComponentType().isArray()) {
            int length = Array.getLength(array);
            Object newArray = Array.newInstance(PrimitiveTypeUtil.toWrapperArray(array.getClass().getComponentType()), length);
            for (int i = 0; i < length; ++i) {
                Array.set(newArray, i, PrimitiveTypeUtil.toWrapperArray(Array.get(array, i)));
            }
            return newArray;
        }
        return array;
    }

    public static Object toWrapper(Object o) {
        return o;
    }

    public static Class<?> toWrapper(Class<?> primitiveType) {
        return (Class)wrapperToPrimitive.inverse().getOrDefault(primitiveType, primitiveType);
    }

    public static Class<?> toPrimitive(Class<?> wrapperType) {
        return (Class)wrapperToPrimitive.getOrDefault(wrapperType, wrapperType);
    }

    public static boolean isPrimitive(Class<?> clz) {
        return clz.isPrimitive();
    }

    public static boolean isWrapper(Class<?> clz) {
        return wrapperToPrimitive.keySet().contains(clz);
    }

    public static Class<?> toWrapperArray(Class<?> primitiveArrayType) {
        return (Class)wrapperArrayToPrimitiveArray.inverse().getOrDefault(primitiveArrayType, primitiveArrayType);
    }

    public static Class<?> toPrimitiveArray(Class<?> wrapperArrayType) {
        return (Class)wrapperArrayToPrimitiveArray.getOrDefault(wrapperArrayType, wrapperArrayType);
    }

    public static boolean isPrimitiveArray(Class<?> clz) {
        return clz.isArray() && clz.getComponentType().isPrimitive();
    }

    public static boolean isWrapperArray(Class<?> clz) {
        return clz.isArray() && PrimitiveTypeUtil.isWrapper(clz.getComponentType());
    }

    public static int sizeOf(Class<?> clz) throws IllegalArgumentException {
        switch (clz.getName()) {
            case "int": {
                return 4;
            }
            case "short": {
                return 2;
            }
            case "long": {
                return 8;
            }
            case "double": {
                return 8;
            }
            case "float": {
                return 4;
            }
            case "boolean": {
                return 1;
            }
            case "char": {
                return 2;
            }
            case "byte": {
                return 1;
            }
        }
        throw new IllegalArgumentException("Not a primitive type.");
    }

    public static <T> T parse(Class<T> clz, String objectValue) {
        switch (clz.getName()) {
            case "int": {
                return (T)Integer.valueOf(objectValue);
            }
            case "short": {
                return (T)Short.valueOf(objectValue);
            }
            case "long": {
                if (objectValue.endsWith("L") || objectValue.endsWith("l")) {
                    objectValue = objectValue.substring(0, objectValue.length() - 1);
                }
                return (T)Long.valueOf(objectValue);
            }
            case "double": {
                return (T)Double.valueOf(objectValue);
            }
            case "float": {
                return (T)Float.valueOf(objectValue);
            }
            case "boolean": {
                if (objectValue.equalsIgnoreCase(Boolean.TRUE.toString())) {
                    return (T)Boolean.TRUE;
                }
                if (objectValue.equalsIgnoreCase(Boolean.FALSE.toString())) {
                    return (T)Boolean.FALSE;
                }
                throw new IllegalArgumentException(String.format("The String %s cannot parse as boolean.", objectValue));
            }
            case "char": {
                if (objectValue.length() == 1) {
                    return (T)new Character(objectValue.charAt(0));
                }
                throw new IllegalArgumentException(String.format("The String %s cannot parse as char.", objectValue));
            }
            case "byte": {
                return (T)Byte.valueOf(objectValue);
            }
        }
        return null;
    }

    private static void add(Class<?> primitiveType, Class<?> wrapperType) {
        wrapperToPrimitive.put(wrapperType, primitiveType);
        wrapperArrayToPrimitiveArray.put(Array.newInstance(wrapperType, 0).getClass(), Array.newInstance(primitiveType, 0).getClass());
    }

    static {
        PrimitiveTypeUtil.add(Boolean.TYPE, Boolean.class);
        PrimitiveTypeUtil.add(Byte.TYPE, Byte.class);
        PrimitiveTypeUtil.add(Character.TYPE, Character.class);
        PrimitiveTypeUtil.add(Double.TYPE, Double.class);
        PrimitiveTypeUtil.add(Float.TYPE, Float.class);
        PrimitiveTypeUtil.add(Integer.TYPE, Integer.class);
        PrimitiveTypeUtil.add(Long.TYPE, Long.class);
        PrimitiveTypeUtil.add(Short.TYPE, Short.class);
    }
}

