/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.file;

import com.google.common.base.Stopwatch;
import io.reactivex.Flowable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import xdean.jex.extra.collection.Traverse;
import xdean.jex.log.Log;
import xdean.jex.log.LogFactory;
import xdean.jex.util.security.SecurityUtil;
import xdean.jex.util.task.TaskUtil;

public class FileUtil {
    private static final Log LOG = LogFactory.from(FileUtil.class);

    public static String getNameWithoutSuffix(Path path) {
        String name = path.getFileName().toString();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(0, index);
    }

    public static void createDirectory(Path path) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
    }

    public static Path rename(Path path, String name) throws IOException {
        return Files.move(path, path.resolveSibling(name), new CopyOption[0]);
    }

    public static Path rename(Path path, UnaryOperator<String> nameConverter) throws IOException {
        return FileUtil.rename(path, (String)nameConverter.apply(path.getFileName().toString()));
    }

    /*
     * Exception decompiling
     */
    public static boolean equals(Path p1, Path p2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Flowable<Path> deepTraversal(Path path) {
        return Traverse.preOrderTraversal(path, p -> (Iterable)TaskUtil.firstSuccess(() -> Files.newDirectoryStream(p), () -> Collections.emptyList()));
    }

    public static Flowable<Path> wideTraversal(Path path) {
        return Traverse.breadthFirstTraversal(path, p -> (Iterable)TaskUtil.firstSuccess(() -> Files.newDirectoryStream(p), () -> Collections.emptyList()));
    }

    public static String md5(Path path) throws IOException {
        return SecurityUtil.md5(Files.newInputStream(path, new OpenOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String digest(Path path, String algorithm) throws NoSuchAlgorithmException, IOException {
        LOG.debug("To calc {0}''s {1}, its size is: {2}", new Object[]{path.getFileName(), algorithm, Files.size(path)});
        Stopwatch s = Stopwatch.createStarted();
        try {
            String string = SecurityUtil.digest(Files.newInputStream(path, new OpenOption[0]), algorithm);
            return string;
        }
        finally {
            LOG.debug("Calc end, use {0} ms", (Object)s.elapsed(TimeUnit.MILLISECONDS));
        }
    }
}

