/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.collection;

import com.google.common.collect.Lists;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import xdean.jex.extra.collection.Traverse;
import xdean.jex.extra.collection.Wrapper;
import xdean.jex.extra.rx2.RxFunctions;
import xdean.jex.util.function.FunctionAdapter;
import xdean.jex.util.function.Predicates;

public class Tree<T>
implements Traverse.Traversable<Tree<T>> {
    private Tree<T> parent;
    private List<Tree<T>> children = new ArrayList<Tree<T>>();
    private T value;

    public Tree(T value) {
        this.value = value;
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    public List<Tree<T>> getChildren() {
        return this.children;
    }

    public T getValue() {
        return this.value;
    }

    public Tree<T> add(T value) {
        return this.add(new Tree<T>(value));
    }

    public Tree<T> add(Tree<T> node) {
        node.removeFromParent();
        node.parent = this;
        this.children.add(node);
        return node;
    }

    public boolean remove(T value) {
        return this.getChild(value).map(this::remove).orElse(false);
    }

    public boolean remove(Tree<T> node) {
        return this.getChild(node).map(FunctionAdapter.function(n -> {
            n.parent = null;
        })).map(this.children::remove).orElse(false);
    }

    public Optional<Tree<T>> removeFromParent() {
        Tree<T> theParent = this.parent;
        if (this.parent != null) {
            this.parent.remove(this);
        }
        return Optional.ofNullable(theParent);
    }

    public boolean hasChild(T value) {
        return this.getChild(value).isPresent();
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Optional<Tree<T>> getChild(T value) {
        return this.children.stream().filter(Predicates.its(n -> n.value, Predicates.isEquals(value))).findFirst();
    }

    public Optional<Tree<T>> getChild(Tree<T> node) {
        return this.children.stream().filter(Predicates.is(node)).findFirst();
    }

    public Optional<Tree<T>> deepChild(T value) {
        return (Optional)this.breadthFirstTraversal().filter(RxFunctions.rx(Predicates.its(Tree::getValue, Predicates.isEquals(value)))).map(Optional::of).blockingFirst(Optional.empty());
    }

    public Optional<Tree<T>> deepChild(Tree<T> node) {
        return (Optional)this.breadthFirstTraversal().filter(RxFunctions.rx(Predicates.is(node))).map(Optional::of).blockingFirst(Optional.empty());
    }

    public Optional<Tree<T>> commonParent(Tree<T> other) {
        List myParents = (List)this.parents().startWith((Object)this).toList().blockingGet();
        return (Optional)other.parents().startWith(other).filter(myParents::contains).map(Optional::of).blockingFirst(Optional.empty());
    }

    public Optional<Flowable<Tree<T>>> pathTo(Tree<T> node) {
        if (this.deepChild(node).isPresent()) {
            return Optional.of(Tree.path(node, this).toList().flattenAsFlowable(Lists::reverse));
        }
        if (node.deepChild(this).isPresent()) {
            return Optional.of(Tree.path(this, node));
        }
        return Optional.empty();
    }

    private static <T> Flowable<Tree<T>> path(Tree<T> downNode, Tree<T> upNode) {
        return Flowable.generate(() -> Wrapper.of(downNode), (w, e) -> {
            Tree node = (Tree)w.get();
            if (node == null) {
                e.onComplete();
            } else {
                e.onNext((Object)node);
                if (node == upNode) {
                    w.set(null);
                } else {
                    Tree parent = node.getParent();
                    w.set(parent);
                }
            }
        });
    }

    public void swap(Tree<T> node) {
        Tree<T> thisParent = this.parent;
        ArrayList<Tree<Tree>> thisChildren = new ArrayList<Tree<Tree>>(this.children);
        this.removeFromParent();
        if (node.parent != null) {
            node.parent.add(this);
        }
        node.children.forEach(this::add);
        node.removeFromParent();
        if (thisParent != null) {
            thisParent.add(node);
        }
        thisChildren.forEach(node::add);
    }

    public void rotateAsParent() {
        this.removeFromParent().ifPresent(this::add);
    }

    public Flowable<Tree<T>> parents() {
        return Flowable.generate(() -> Wrapper.of(this), (n, e) -> {
            Tree parent = ((Tree)n.get()).getParent();
            if (parent != null) {
                e.onNext(parent);
                n.set(parent);
            } else {
                e.onComplete();
            }
        });
    }

    @Override
    public Flowable<Tree<T>> traverse(Traverse.Traverser traverser) {
        return traverser.travese(this, Tree::getChildren);
    }

    public String toString() {
        return "TreeNode [value=" + this.value + "]";
    }
}

