/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import xdean.jex.extra.collection.Tree;

@Beta
public class RelativeComparator<T> {
    Comparator<T> defaultComparator;
    Tree<T> root;

    public static <T extends Comparable<T>> RelativeComparator<T> create() {
        return new RelativeComparator(Comparator.naturalOrder());
    }

    public static <T> RelativeComparator<T> create(Comparator<T> defaultComparator) {
        return new RelativeComparator<T>(defaultComparator);
    }

    @SafeVarargs
    public static <T extends Comparable<T>> Comparator<T> of(T ... ts) {
        return new RelativeComparator<T>(Comparator.naturalOrder()).addOrder(ts).toComparator();
    }

    @SafeVarargs
    public static <T> Comparator<T> of(Comparator<T> defaultComparator, T ... ts) {
        return new RelativeComparator<T>(defaultComparator).addOrder(ts).toComparator();
    }

    public RelativeComparator(Comparator<T> defaultComparator) {
        this.defaultComparator = defaultComparator;
        this.root = new Tree<Object>(null);
    }

    public RelativeComparator<T> addOrder(T ... ts) {
        for (int i = 0; i < ts.length - 1; ++i) {
            this.addOrder(ts[i], ts[i + 1]);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public RelativeComparator<T> addOrder(T small, T big) {
        Optional<Tree<T>> oSmallNode = this.root.deepChild(small);
        Tree<T> smallNode = oSmallNode.isPresent() ? oSmallNode.get() : this.root.add(small);
        Optional<Tree<T>> oBigNode = this.root.deepChild(big);
        if (!oBigNode.isPresent()) {
            smallNode.add(big);
            return this;
        }
        Tree<T> bigNode = oBigNode.get();
        Tree<T> commonParent = smallNode.commonParent(bigNode).get();
        if (commonParent == smallNode) {
            return this;
        }
        if (commonParent == bigNode) {
            throw new IllegalArgumentException(String.format("%s is already bigger than %s, can't setter it as the smaller.", small, big));
        }
        if (commonParent == bigNode.getParent()) {
            smallNode.add(bigNode);
            return this;
        }
        if (commonParent != smallNode.getParent()) throw new UnsupportedOperationException();
        throw new UnsupportedOperationException();
    }

    public Comparator<T> toComparator() {
        return (Comparator)this.root.breadthFirstTraversal().skip(1L).map(Tree::getValue).toList().map(orderList -> {
            ArrayList<T> target = new ArrayList<T>(orderList);
            target.sort(this.defaultComparator);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < orderList.size(); ++i) {
                builder.put(orderList.get(i), target.get(i));
            }
            ImmutableMap map = builder.build();
            return (a, b) -> {
                int ia = orderList.indexOf(a);
                int ib = orderList.indexOf(b);
                if (ia != -1 && ib != -1) {
                    return ia - ib;
                }
                return this.defaultComparator.compare(map.getOrDefault(a, a), map.getOrDefault(b, b));
            };
        }).blockingGet();
    }
}

