/*
 * Decompiled with CFR 0.152.
 */
package xdean.annotation.processor;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import xdean.annotation.MethodRef;
import xdean.annotation.processor.toolkit.AssertException;
import xdean.annotation.processor.toolkit.ElementUtil;
import xdean.annotation.processor.toolkit.XAbstractProcessor;
import xdean.annotation.processor.toolkit.annotation.SupportedAnnotation;

@SupportedAnnotation(value=MethodRef.class)
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class MethodRefProcessor
extends XAbstractProcessor {
    private static final String RECORD_FILE = "META-INF/xdean/annotation/MethodRef";
    private TypeMirror classType;
    private TypeMirror methodRefType;
    private TypeMirror voidType;
    private Set<TypeElement> visitedClassAndMethod = new HashSet<TypeElement>();
    private Set<String> allMethodRefAnnotations = new HashSet<String>();

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.classType = this.types.erasure(this.elements.getTypeElement(Class.class.getCanonicalName()).asType());
        this.methodRefType = this.elements.getTypeElement(MethodRef.class.getCanonicalName()).asType();
        this.voidType = this.types.getNoType(TypeKind.VOID);
    }

    public boolean processActual(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateConfigFiles(roundEnv);
        } else {
            this.valid(annotations, roundEnv);
        }
        return false;
    }

    private void generateConfigFiles(RoundEnvironment roundEnv) {
        try {
            Filer filer = this.processingEnv.getFiler();
            FileObject resource = filer.createResource(StandardLocation.CLASS_OUTPUT, "", RECORD_FILE, new Element[0]);
            OutputStream output = resource.openOutputStream();
            PrintStream writer = new PrintStream(output, false, "UTF-8");
            this.allMethodRefAnnotations.forEach(writer::println);
            writer.flush();
        }
        catch (IOException e) {
            this.error().log("Unable to create META-INF/xdean/annotation/MethodRef, " + e);
        }
    }

    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>(super.getSupportedAnnotationTypes());
        try {
            Enumeration<URL> resource = ((Object)((Object)this)).getClass().getClassLoader().getResources(RECORD_FILE);
            for (URL url : Collections.list(resource)) {
                URI uri = url.toURI();
                try {
                    FileSystems.getFileSystem(uri);
                }
                catch (FileSystemNotFoundException e) {
                    HashMap<String, String> env = new HashMap<String, String>();
                    env.put("create", "true");
                    FileSystems.newFileSystem(uri, env);
                }
                catch (IllegalArgumentException e) {
                    this.debug().log(e.getMessage());
                }
                Files.readAllLines(Paths.get(uri)).forEach(set::add);
            }
        }
        catch (IOException | URISyntaxException e1) {
            this.error().log("error happened when read record file: " + e1.getMessage());
        }
        return set;
    }

    private void valid(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Stream.concat(annotations.stream().flatMap(typeElement -> ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().filter(ee -> ee.getAnnotation(MethodRef.class) != null)), roundEnv.getElementsAnnotatedWith(MethodRef.class).stream()).distinct().forEach(e -> this.handleAssert(() -> this.valid((ExecutableElement)this.assertType(e, ExecutableElement.class).todo(() -> this.error().log("MethodRef can only annotate on method element.", e)), roundEnv)));
    }

    private void valid(ExecutableElement annotatedMethod, RoundEnvironment roundEnv) throws AssertException {
        this.debug().log("To validate: " + annotatedMethod);
        MethodRef mr = annotatedMethod.getAnnotation(MethodRef.class);
        TypeElement annotatedClass = (TypeElement)this.assertType(annotatedMethod.getEnclosingElement(), TypeElement.class).todo(() -> this.error().log("@MethodRef method must defined in a class.", (Element)annotatedMethod));
        this.assertThat(annotatedClass.getKind() == ElementKind.ANNOTATION_TYPE).todo(() -> this.error().log("@MethodRef can only annotated on @interface class's method.", (Element)annotatedMethod));
        BiFunction<Element, AnnotationMirror, String[]> getClassAndMethod = mr.type() == MethodRef.Type.ALL ? this.useAll(annotatedMethod, mr) : (mr.type() == MethodRef.Type.METHOD && mr.findInEnclosing() ? this.useEnclosing(annotatedMethod, mr) : (mr.type() == MethodRef.Type.METHOD && !this.types.isSameType(ElementUtil.getAnnotationClassValue((Elements)this.elements, (Annotation)mr, MethodRef::defaultClass), this.voidType) ? this.useDefaultClass(annotatedMethod, mr) : (mr.type() == MethodRef.Type.METHOD && !this.types.isSameType(ElementUtil.getAnnotationClassValue((Elements)this.elements, (Annotation)mr, MethodRef::parentClass), this.methodRefType) ? this.useParentClass(annotatedMethod, mr) : this.useClassAndMethod(annotatedClass))));
        this.valid(annotatedClass, getClassAndMethod, roundEnv);
        this.allMethodRefAnnotations.add(annotatedClass.getQualifiedName().toString());
    }

    private BiFunction<Element, AnnotationMirror, String[]> useEnclosing(ExecutableElement annotatedMethod, MethodRef mr) {
        return (e, am) -> new String[]{e.getEnclosingElement().asType().toString(), this.elements.getElementValuesWithDefaults((AnnotationMirror)am).get(annotatedMethod).getValue().toString()};
    }

    private BiFunction<Element, AnnotationMirror, String[]> useAll(ExecutableElement annotatedMethod, MethodRef mr) {
        char splitor = mr.splitor();
        return (e, am) -> {
            AnnotationValue av = this.elements.getElementValuesWithDefaults((AnnotationMirror)am).get(annotatedMethod);
            String value = av.getValue().toString();
            String[] split = value.split(Pattern.quote(Character.toString(splitor)));
            this.assertThat(split.length == 2).todo(() -> this.error().log("The method reference must be $ClassName" + splitor + "$MethodName", e, am, av));
            return split;
        };
    }

    private BiFunction<Element, AnnotationMirror, String[]> useDefaultClass(ExecutableElement annotatedMethod, MethodRef mr) {
        String className = ElementUtil.getAnnotationClassValue((Elements)this.elements, (Annotation)mr, MethodRef::defaultClass).toString();
        return (e, am) -> new String[]{className, this.elements.getElementValuesWithDefaults((AnnotationMirror)am).get(annotatedMethod).getValue().toString()};
    }

    private BiFunction<Element, AnnotationMirror, String[]> useParentClass(ExecutableElement annotatedMethod, MethodRef mr) {
        TypeMirror parentClass = ElementUtil.getAnnotationClassValue((Elements)this.elements, (Annotation)mr, MethodRef::parentClass);
        ExecutableElement valueMethod = this.assertParentDefine(annotatedMethod, parentClass);
        return (e, am) -> {
            Element enclosingElement = e.getEnclosingElement();
            AnnotationMirror defaultAnnotation = (AnnotationMirror)this.assertNonNull(ElementUtil.getAnnotationMirror((Element)enclosingElement, (TypeMirror)parentClass).orElse(null)).todo(() -> {
                this.error().log("Should annotated by @" + parentClass.toString(), enclosingElement);
                this.error().log("Can't find parent annotation @" + parentClass.toString() + " on enclosing element. ", e, am);
            });
            return new String[]{this.elements.getElementValuesWithDefaults(defaultAnnotation).get(valueMethod).getValue().toString(), this.elements.getElementValuesWithDefaults((AnnotationMirror)am).get(annotatedMethod).getValue().toString()};
        };
    }

    private BiFunction<Element, AnnotationMirror, String[]> useClassAndMethod(TypeElement annotatedClass) {
        ExecutableElement method;
        ExecutableElement clazz;
        this.assertThat(this.visitedClassAndMethod.add(annotatedClass)).todo(() -> this.debug().log("This annotation has been visisted: " + annotatedClass));
        ExecutableElement[] refMethods = (ExecutableElement[])ElementFilter.methodsIn(this.elements.getAllMembers(annotatedClass)).stream().filter(e -> {
            MethodRef methodRef = e.getAnnotation(MethodRef.class);
            if (methodRef == null) {
                return false;
            }
            return methodRef.type() == MethodRef.Type.CLASS || methodRef.type() == MethodRef.Type.METHOD && !methodRef.findInEnclosing() && this.types.isSameType(ElementUtil.getAnnotationClassValue((Elements)this.elements, (Annotation)methodRef, MethodRef::defaultClass), this.voidType) && this.types.isSameType(ElementUtil.getAnnotationClassValue((Elements)this.elements, (Annotation)methodRef, MethodRef::parentClass), this.methodRefType);
        }).toArray(ExecutableElement[]::new);
        this.assertThat(refMethods.length == 2).todo(() -> this.error().log("When use @MethodRef.Type.CLASS&METHOD, the annotation must have and only have 2 methods with @MethodRef, one is @MethodRef(type=CLASS), one is @MethodRef(type=METHOD)", (Element)annotatedClass));
        ExecutableElement ee1 = refMethods[0];
        ExecutableElement ee2 = refMethods[1];
        MethodRef mr1 = ee1.getAnnotation(MethodRef.class);
        MethodRef mr2 = ee2.getAnnotation(MethodRef.class);
        if (mr1.type() == MethodRef.Type.CLASS && mr2.type() == MethodRef.Type.METHOD) {
            clazz = ee1;
            method = ee2;
        } else if (mr1.type() == MethodRef.Type.METHOD && mr2.type() == MethodRef.Type.CLASS) {
            clazz = ee2;
            method = ee1;
        } else {
            this.error().log("When use @MethodRef.Type.CLASS&METHOD, the annotation must have 1 method with Type.CLASS and 1 method with Type.METHOD", (Element)annotatedClass);
            throw new AssertException();
        }
        MethodRef mr = clazz.getAnnotation(MethodRef.class);
        TypeMirror parentClass = ElementUtil.getAnnotationClassValue((Elements)this.elements, (Annotation)mr, MethodRef::parentClass);
        ExecutableElement parentValueMethod = !this.types.isSameType(parentClass, this.methodRefType) ? this.assertParentDefine(clazz, parentClass) : null;
        this.assertThat(this.types.isAssignable(clazz.getReturnType(), this.classType)).todo(() -> this.error().log("Method with @MethodRef(type=CLASS) must return Class", (Element)clazz));
        return (e, am) -> {
            String clzValue;
            Element enclosingElement;
            Optional defaultAnnotation;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = this.elements.getElementValuesWithDefaults((AnnotationMirror)am);
            String parentClzValue = null;
            if (parentValueMethod != null && (defaultAnnotation = ElementUtil.getAnnotationMirror((Element)(enclosingElement = e.getEnclosingElement()), (TypeMirror)parentClass)).isPresent()) {
                parentClzValue = this.elements.getElementValuesWithDefaults((AnnotationMirror)defaultAnnotation.get()).get(parentValueMethod).getValue().toString();
            }
            if ((clzValue = values.get(clazz).getValue().toString()).equals(Void.TYPE.getCanonicalName()) || clzValue.equals(Void.class.getCanonicalName())) {
                this.assertNonNull(parentClzValue).todo(() -> this.error().log("Parent and itself both don't define a Class value.", e, am));
                clzValue = parentClzValue;
            }
            String methodValue = values.get(method).getValue().toString();
            return new String[]{clzValue, methodValue};
        };
    }

    private void valid(TypeElement theAnnotation, BiFunction<Element, AnnotationMirror, String[]> getClassAndMethod, RoundEnvironment roundEnv) {
        TypeMirror annoType = theAnnotation.asType();
        roundEnv.getElementsAnnotatedWith(theAnnotation).forEach(e -> this.handleAssert(() -> {
            AnnotationMirror anno = (AnnotationMirror)ElementUtil.getAnnotationMirror((Element)e, (TypeMirror)annoType).get();
            String[] pair = (String[])getClassAndMethod.apply((Element)e, anno);
            TypeElement clz = this.elements.getTypeElement(pair[0]);
            if (clz == null) {
                try {
                    clz = this.elements.getTypeElement(Class.forName(pair[0]).getCanonicalName());
                }
                catch (ClassNotFoundException e1) {
                    this.error().log("Can't find the given class: " + pair[0], e, anno);
                    return;
                }
            }
            if (!this.elements.getAllMembers(clz).stream().filter(ExecutableElement.class::isInstance).map(Element::getSimpleName).anyMatch(n -> n.contentEquals(pair[1]))) {
                this.error().log("Can't find the given method: " + pair[1] + " in " + pair[0], e, anno);
            }
        }));
    }

    private ExecutableElement assertParentDefine(ExecutableElement annotatedMethod, TypeMirror parentClass) throws AssertException {
        return (ExecutableElement)this.assertNonNull(ElementFilter.methodsIn(this.types.asElement(parentClass).getEnclosedElements()).stream().filter(ee -> ee.getSimpleName().contentEquals("value")).filter(ee -> this.types.isAssignable(ee.getReturnType(), this.classType)).findAny().orElse(null)).todo(() -> this.error().log("The parent annotation class must have an attribute named 'value' with type Class", (Element)annotatedMethod));
    }
}

