/*
 * Decompiled with CFR 0.152.
 */
package pyxis.uzuki.live.richutilskt.utils;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pyxis.uzuki.live.richutilskt.utils.ImageOrientation;
import pyxis.uzuki.live.richutilskt.utils.ResizeMode;
import pyxis.uzuki.live.richutilskt.utils.RichUtils;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=5, d1={"\u0000J\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\u001a%\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\b\u0005\u001a\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\b\t\u001a%\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\b\u000b\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\r*\u00020\u000f\u001a\u0011\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002\u00a2\u0006\u0002\b\u0017\u001a\u0012\u0010\u0018\u001a\u00020\u0019*\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u000f\u001a0\u0010\u001b\u001a\u00020\r*\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\b\b\u0002\u0010\u001c\u001a\u00020\u00072\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007\u001a\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u0015*\u00020\u00162\u0006\u0010 \u001a\u00020\r\u001a\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u0015*\u00020\u00152\u0006\u0010 \u001a\u00020\r\u001a\u0014\u0010!\u001a\u0004\u0018\u00010\r*\u00020\r2\u0006\u0010\"\u001a\u00020#\u00a8\u0006$"}, d2={"calculateHeight", "", "originalWidth", "originalHeight", "width", "calculateHeight$RichUtils__RBitmapKt", "calculateResizeMode", "Lpyxis/uzuki/live/richutilskt/utils/ResizeMode;", "height", "calculateResizeMode$RichUtils__RBitmapKt", "calculateWidth", "calculateWidth$RichUtils__RBitmapKt", "downloadBitmap", "Landroid/graphics/Bitmap;", "imageUrl", "", "drawableToBitmap", "drawable", "Landroid/graphics/drawable/Drawable;", "getBitmap", "getOutputMediaFile", "Ljava/io/File;", "Landroid/content/Context;", "getOutputMediaFile$RichUtils__RBitmapKt", "requestMediaScanner", "", "url", "resize", "mode", "isExcludeAlpha", "", "saveBitmapToFile", "bitmap", "toRoundCorner", "radius", "", "RichUtils_release"}, xs="pyxis/uzuki/live/richutilskt/utils/RichUtils")
final class RichUtils__RBitmapKt {
    @Nullable
    public static final Bitmap getBitmap(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return RichUtils.isEmpty($receiver) ? null : BitmapFactory.decodeFile((String)$receiver);
    }

    @Nullable
    public static final Bitmap toRoundCorner(@NotNull Bitmap $receiver, float radius) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int width = $receiver.getWidth();
        int height = $receiver.getHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)$receiver.getConfig());
        Paint paint = new Paint();
        Canvas canvas = new Canvas(bitmap);
        Rect rect = new Rect(0, 0, width, height);
        paint.setAntiAlias(true);
        canvas.drawRoundRect(new RectF(rect), radius, radius, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap($receiver, rect, rect, paint);
        $receiver.recycle();
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final File saveBitmapToFile(@NotNull Context $receiver, @NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        File file = RichUtils__RBitmapKt.getOutputMediaFile$RichUtils__RBitmapKt($receiver);
        Object object = file;
        object = new FileOutputStream((File)object);
        boolean bl = false;
        try {
            FileOutputStream it = (FileOutputStream)object;
            boolean bl2 = bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)it);
        }
        catch (Exception exception) {
            try {
                bl = true;
                try {
                    object.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    object.close();
                }
                throw throwable;
            }
        }
        object.close();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final File saveBitmapToFile(@NotNull File $receiver, @NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Object object = $receiver;
        object = new FileOutputStream((File)object);
        boolean bl = false;
        try {
            FileOutputStream it = (FileOutputStream)object;
            boolean bl2 = bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)it);
        }
        catch (Exception exception) {
            try {
                bl = true;
                try {
                    object.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    object.close();
                }
                throw throwable;
            }
        }
        object.close();
        return $receiver;
    }

    private static final File getOutputMediaFile$RichUtils__RBitmapKt(@NotNull Context $receiver) {
        CharSequence charSequence = UUID.randomUUID().toString();
        String string = "-";
        StringBuilder stringBuilder = new StringBuilder();
        Object object = new Regex(string);
        string = object;
        String string2 = "";
        object = string.replace(charSequence, string2);
        String picName = stringBuilder.append((String)object).append(".jpg").toString();
        File folder = $receiver.getExternalFilesDir(null);
        if (!folder.isDirectory()) {
            folder.mkdirs();
        }
        return new File(folder, picName);
    }

    @NotNull
    public static final Bitmap drawableToBitmap(@NotNull Drawable drawable) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        if (drawable instanceof BitmapDrawable) {
            Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"drawable.bitmap");
            return bitmap;
        }
        int width = drawable.getIntrinsicWidth();
        width = width > 0 ? width : 1;
        int height = drawable.getIntrinsicHeight();
        height = height > 0 ? height : 1;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    public static final void requestMediaScanner(@NotNull Context $receiver, @NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        Uri contentUri = Uri.fromFile((File)new File(url));
        mediaScanIntent.setData(contentUri);
        $receiver.sendBroadcast(mediaScanIntent);
    }

    @Nullable
    public static final Bitmap downloadBitmap(@NotNull String imageUrl) {
        Intrinsics.checkParameterIsNotNull((Object)imageUrl, (String)"imageUrl");
        Bitmap bitmap = null;
        URL url = new URL(imageUrl);
        URLConnection uRLConnection = url.openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection conn = (HttpURLConnection)uRLConnection;
        if (conn.getResponseCode() == 200) {
            bitmap = RichUtils.outAsBitmap(conn.getInputStream());
        }
        conn.disconnect();
        return bitmap;
    }

    @JvmOverloads
    @NotNull
    public static final Bitmap resize(@NotNull Bitmap $receiver, int width, int height, @NotNull ResizeMode mode, boolean isExcludeAlpha) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
        int mWidth = width;
        int mHeight = height;
        ResizeMode mMode = mode;
        int sourceWidth = $receiver.getWidth();
        int sourceHeight = $receiver.getHeight();
        if (Intrinsics.areEqual((Object)((Object)mode), (Object)((Object)ResizeMode.AUTOMATIC))) {
            mMode = RichUtils__RBitmapKt.calculateResizeMode$RichUtils__RBitmapKt(sourceWidth, sourceHeight);
        }
        if (Intrinsics.areEqual((Object)((Object)mMode), (Object)((Object)ResizeMode.FIT_TO_WIDTH))) {
            mHeight = RichUtils__RBitmapKt.calculateHeight$RichUtils__RBitmapKt(sourceWidth, sourceHeight, width);
        } else if (Intrinsics.areEqual((Object)((Object)mMode), (Object)((Object)ResizeMode.FIT_TO_HEIGHT))) {
            mWidth = RichUtils__RBitmapKt.calculateWidth$RichUtils__RBitmapKt(sourceWidth, sourceHeight, height);
        }
        Bitmap.Config config = isExcludeAlpha ? Bitmap.Config.RGB_565 : Bitmap.Config.ARGB_8888;
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)$receiver, (int)mWidth, (int)mHeight, (boolean)true).copy(config, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createScaledBitma\u2026 true).copy(config, true)");
        return bitmap;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Bitmap resize$default(Bitmap bitmap, int n, int n2, ResizeMode resizeMode, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            resizeMode = ResizeMode.AUTOMATIC;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return RichUtils.resize(bitmap, n, n2, resizeMode, bl);
    }

    @JvmOverloads
    @NotNull
    public static final Bitmap resize(@NotNull Bitmap $receiver, int width, int height, @NotNull ResizeMode mode) {
        return RichUtils.resize$default($receiver, width, height, mode, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public static final Bitmap resize(@NotNull Bitmap $receiver, int width, int height) {
        return RichUtils.resize$default($receiver, width, height, null, false, 12, null);
    }

    private static final ResizeMode calculateResizeMode$RichUtils__RBitmapKt(int width, int height) {
        return ImageOrientation.Companion.getOrientation(width, height) == ImageOrientation.LANDSCAPE ? ResizeMode.FIT_TO_WIDTH : ResizeMode.FIT_TO_HEIGHT;
    }

    private static final int calculateWidth$RichUtils__RBitmapKt(int originalWidth, int originalHeight, int height) {
        return (int)Math.ceil((double)originalWidth / ((double)originalHeight / (double)height));
    }

    private static final int calculateHeight$RichUtils__RBitmapKt(int originalWidth, int originalHeight, int width) {
        return (int)Math.ceil((double)originalHeight / ((double)originalWidth / (double)width));
    }
}

