/*
 * Decompiled with CFR 0.152.
 */
package pyxis.uzuki.live.richutilskt.module.crash;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import pyxis.uzuki.live.richutilskt.module.crash.CrashConfig;
import pyxis.uzuki.live.richutilskt.module.crash.item.LogLevel;
import pyxis.uzuki.live.richutilskt.module.crash.item.RichCrashModel;
import pyxis.uzuki.live.richutilskt.utils.RichUtils;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\u0006H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lpyxis/uzuki/live/richutilskt/module/crash/CrashHandler;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "crashConfig", "Lpyxis/uzuki/live/richutilskt/module/crash/CrashConfig;", "(Lpyxis/uzuki/live/richutilskt/module/crash/CrashConfig;)V", "fileName", "", "getFileName", "()Ljava/lang/String;", "lineBreak", "getLineBreak", "now", "Ljava/util/Calendar;", "richCrashModel", "Lpyxis/uzuki/live/richutilskt/module/crash/item/RichCrashModel;", "generateRichCrashModel", "ex", "", "handleException", "", "saveLocal", "message", "uncaughtException", "t", "Ljava/lang/Thread;", "e", "writeLogIntoMarkdown", "Companion", "RichUtils_release"})
public final class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private Calendar now;
    private RichCrashModel richCrashModel;
    private final CrashConfig crashConfig;
    private static CrashHandler instance;
    public static final Companion Companion;

    private final String getFileName() {
        return "crash_" + CrashHandler.Companion.getTimeForPrint() + ".md";
    }

    private final String getLineBreak() {
        String string = System.getProperty("line.separator");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"line.separator\")");
        return string;
    }

    @Override
    public void uncaughtException(@NotNull Thread t, @NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        this.now = calendar;
        this.handleException(e);
    }

    private final void handleException(Throwable ex) {
        if (ex == null) {
            return;
        }
        this.richCrashModel = this.generateRichCrashModel(ex);
        new Thread(this){
            final /* synthetic */ CrashHandler this$0;

            public void run() {
                CrashHandler.access$saveLocal(this.this$0, CrashHandler.access$writeLogIntoMarkdown(this.this$0));
            }
            {
                this.this$0 = $outer;
            }
        }.start();
    }

    private final void saveLocal(String message) {
        String fileName = this.getFileName();
        File file = new File(this.crashConfig.getLogLocation(), fileName);
        if (!file.exists()) {
            CrashHandler $receiver$iv = this;
            try {
                CrashHandler it = $receiver$iv;
                file.createNewFile();
                Boolean bl = Boolean.TRUE;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"java.lang.Boolean.TRUE");
                file.setWritable(bl);
            }
            catch (Exception e$iv) {
                Log.e((String)"tag", (String)"I/O Exception", (Throwable)e$iv);
                throw (Throwable)e$iv;
            }
        }
        String string = message;
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] messageBytes = byArray;
        FilesKt.writeBytes((File)file, (byte[])messageBytes);
        Process.killProcess((int)Process.myPid());
        System.exit(10);
    }

    private final RichCrashModel generateRichCrashModel(Throwable ex) {
        RichCrashModel richCrashModel = new RichCrashModel();
        richCrashModel.setConfig(this.crashConfig);
        richCrashModel.setDeviceInfo(new Build());
        richCrashModel.setThrowable(ex);
        Date date = this.now.getTime();
        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"now.time");
        richCrashModel.setTime(date, this.crashConfig);
        return richCrashModel;
    }

    @SuppressLint(value={"InlinedApi"})
    private final String writeLogIntoMarkdown() {
        StringBuilder builder = new StringBuilder();
        StringBuilder stringBuilder = builder.append("## Crash Log in ");
        RichCrashModel richCrashModel = this.richCrashModel;
        if (richCrashModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"richCrashModel");
        }
        StringBuilder stringBuilder2 = stringBuilder.append(richCrashModel.getPackageName()).append(this.getLineBreak()).append("### Application Info").append(this.getLineBreak()).append("* Package Name: **");
        RichCrashModel richCrashModel2 = this.richCrashModel;
        if (richCrashModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"richCrashModel");
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(richCrashModel2.getPackageName()).append("**").append(this.getLineBreak()).append("* Version: **");
        RichCrashModel richCrashModel3 = this.richCrashModel;
        if (richCrashModel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"richCrashModel");
        }
        stringBuilder3.append(richCrashModel3.getVersionStr()).append("**").append(this.getLineBreak()).append(this.getLineBreak());
        if (this.crashConfig.isDisplayDeviceInfo()) {
            StringBuilder stringBuilder4 = builder.append("### Device Info").append(this.getLineBreak()).append("* Device: **");
            RichCrashModel richCrashModel4 = this.richCrashModel;
            if (richCrashModel4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"richCrashModel");
            }
            StringBuilder stringBuilder5 = stringBuilder4.append(richCrashModel4.getModelStr()).append(" (a.k.a ");
            RichCrashModel richCrashModel5 = this.richCrashModel;
            if (richCrashModel5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"richCrashModel");
            }
            StringBuilder stringBuilder6 = stringBuilder5.append(richCrashModel5.getProductStr()).append(" or ");
            RichCrashModel richCrashModel6 = this.richCrashModel;
            if (richCrashModel6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"richCrashModel");
            }
            StringBuilder stringBuilder7 = stringBuilder6.append(richCrashModel6.getDeviceStr()).append(")**").append(this.getLineBreak()).append("* Version: **");
            RichCrashModel richCrashModel7 = this.richCrashModel;
            if (richCrashModel7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"richCrashModel");
            }
            StringBuilder stringBuilder8 = stringBuilder7.append(richCrashModel7.getSdkStr()).append(" (");
            RichCrashModel richCrashModel8 = this.richCrashModel;
            if (richCrashModel8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"richCrashModel");
            }
            StringBuilder stringBuilder9 = stringBuilder8.append(richCrashModel8.getSdkNum()).append(")**").append(this.getLineBreak()).append("* Manufacturer: **");
            RichCrashModel richCrashModel9 = this.richCrashModel;
            if (richCrashModel9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"richCrashModel");
            }
            stringBuilder9.append(richCrashModel9.getManufacturerStr()).append("**").append(this.getLineBreak()).append(this.getLineBreak());
        }
        StringBuilder stringBuilder10 = builder.append("### Crash Info").append(this.getLineBreak()).append("* When: **");
        RichCrashModel richCrashModel10 = this.richCrashModel;
        if (richCrashModel10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"richCrashModel");
        }
        StringBuilder stringBuilder11 = stringBuilder10.append(richCrashModel10.getTimeStr()).append("**").append(this.getLineBreak()).append("* Message: **");
        RichCrashModel richCrashModel11 = this.richCrashModel;
        if (richCrashModel11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"richCrashModel");
        }
        StringBuilder stringBuilder12 = stringBuilder11.append(richCrashModel11.getMessage()).append("**").append(this.getLineBreak()).append("* Localized Message: **");
        RichCrashModel richCrashModel12 = this.richCrashModel;
        if (richCrashModel12 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"richCrashModel");
        }
        stringBuilder12.append(richCrashModel12.getLocalizedMessage()).append("**").append(this.getLineBreak()).append(this.getLineBreak());
        if (this.crashConfig.getLogLevel() == LogLevel.STACKTRACE) {
            StringBuilder stringBuilder13 = builder.append("#### Stack Trace").append(this.getLineBreak()).append("````").append(this.getLineBreak());
            RichCrashModel richCrashModel13 = this.richCrashModel;
            if (richCrashModel13 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"richCrashModel");
            }
            stringBuilder13.append(richCrashModel13.getStackTrace()).append("````").append(this.getLineBreak()).append(this.getLineBreak());
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    private CrashHandler(CrashConfig crashConfig) {
        this.crashConfig = crashConfig;
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        this.now = calendar;
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ void access$saveLocal(CrashHandler $this, @NotNull String message) {
        $this.saveLocal(message);
    }

    @NotNull
    public static final /* synthetic */ String access$writeLogIntoMarkdown(CrashHandler $this) {
        return $this.writeLogIntoMarkdown();
    }

    public /* synthetic */ CrashHandler(@NotNull CrashConfig crashConfig, DefaultConstructorMarker $constructor_marker) {
        this(crashConfig);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lpyxis/uzuki/live/richutilskt/module/crash/CrashHandler$Companion;", "", "()V", "instance", "Lpyxis/uzuki/live/richutilskt/module/crash/CrashHandler;", "getInstance", "()Lpyxis/uzuki/live/richutilskt/module/crash/CrashHandler;", "setInstance", "(Lpyxis/uzuki/live/richutilskt/module/crash/CrashHandler;)V", "timeForPrint", "", "getTimeForPrint", "()Ljava/lang/String;", "config", "Lpyxis/uzuki/live/richutilskt/module/crash/CrashConfig;", "RichUtils_release"})
    public static final class Companion {
        private final CrashHandler getInstance() {
            return instance;
        }

        private final void setInstance(CrashHandler crashHandler) {
            instance = crashHandler;
        }

        @NotNull
        public final CrashHandler getInstance(@NotNull CrashConfig config) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            if (this.getInstance() == null) {
                this.setInstance(new CrashHandler(config, null));
            }
            CrashHandler crashHandler = this.getInstance();
            if (crashHandler == null) {
                throw new TypeCastException("null cannot be cast to non-null type pyxis.uzuki.live.richutilskt.module.crash.CrashHandler");
            }
            return crashHandler;
        }

        private final String getTimeForPrint() {
            return RichUtils.asDateString(System.currentTimeMillis(), "yyyyMMddHHmmss");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

