/*
 * Decompiled with CFR 0.152.
 */
package pyxis.uzuki.live.mediaresizer.processor;

import android.content.Context;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.ypresto.androidtranscoder.MediaTranscoder;
import net.ypresto.androidtranscoder.format.MediaFormatStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pyxis.uzuki.live.mediaresizer.MediaResizer;
import pyxis.uzuki.live.mediaresizer.MediaResizerGlobalKt;
import pyxis.uzuki.live.mediaresizer.data.ResizeOption;
import pyxis.uzuki.live.mediaresizer.data.VideoResizeOption;
import pyxis.uzuki.live.mediaresizer.model.ScanRequest;
import pyxis.uzuki.live.mediaresizer.processor.VideoProcessorKt;
import pyxis.uzuki.live.mediaresizer.processor.VideoProcessorKt$WhenMappings;
import pyxis.uzuki.live.mediaresizer.strategy.AS480Strategy;
import pyxis.uzuki.live.mediaresizer.strategy.AS720Strategy;
import pyxis.uzuki.live.mediaresizer.strategy.AS960Strategy;
import pyxis.uzuki.live.richutilskt.utils.RichUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"getFileDescriptor", "Ljava/io/FileDescriptor;", "path", "", "getTranscodingStrategy", "Lnet/ypresto/androidtranscoder/format/MediaFormatStrategy;", "resizeOption", "Lpyxis/uzuki/live/mediaresizer/data/VideoResizeOption;", "resizeVideo", "", "option", "Lpyxis/uzuki/live/mediaresizer/data/ResizeOption;", "Resizer_release"})
public final class VideoProcessorKt {
    public static final void resizeVideo(@NotNull ResizeOption option) {
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        FileDescriptor descriptor = VideoProcessorKt.getFileDescriptor(option.getTargetPath());
        VideoResizeOption resizeOption = option.getVideoResizeOption();
        MediaFormatStrategy strategy = resizeOption != null ? VideoProcessorKt.getTranscodingStrategy(resizeOption) : (MediaFormatStrategy)new AS720Strategy(1000000, 128000, 1);
        File file = RichUtils.toFile((String)option.getOutputPath());
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            MediaResizer.INSTANCE.executeCallback(option, false, option.getTargetPath());
        }
        MediaTranscoder.getInstance().transcodeVideo(descriptor, option.getOutputPath(), strategy, new MediaTranscoder.Listener(option){
            final /* synthetic */ ResizeOption $option;

            public void onTranscodeProgress(double progress) {
            }

            public void onTranscodeCanceled() {
                MediaResizer.INSTANCE.executeCallback(this.$option, false, this.$option.getTargetPath());
            }

            public void onTranscodeFailed(@Nullable Exception exception) {
                MediaResizer.INSTANCE.executeCallback(this.$option, false, this.$option.getTargetPath());
            }

            public void onTranscodeCompleted() {
                Object object = this.$option.getVideoResizeOption();
                if (object == null || (object = object.getRequest()) == null) {
                    object = ScanRequest.FALSE;
                }
                if (Intrinsics.areEqual((Object)object, (Object)((Object)ScanRequest.TRUE))) {
                    MediaResizerGlobalKt.useGlobalContext((Function1)new Function1<Context, Unit>(this){
                        final /* synthetic */ resizeVideo.1 this$0;

                        public final void invoke(@NotNull Context $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            RichUtils.requestMediaScanner((Context)$receiver, (String)this.this$0.$option.getOutputPath());
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    });
                }
                MediaResizer.INSTANCE.executeCallback(this.$option, true, this.$option.getOutputPath());
            }
            {
                this.$option = $captured_local_variable$0;
            }
        });
    }

    @Nullable
    public static final FileDescriptor getFileDescriptor(@NotNull String path) {
        FileDescriptor fileDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        File file = RichUtils.toFile((String)path);
        try {
            FileInputStream stream = new FileInputStream(file);
            fileDescriptor = stream.getFD();
        }
        catch (IOException e) {
            fileDescriptor = null;
        }
        return fileDescriptor;
    }

    @NotNull
    public static final MediaFormatStrategy getTranscodingStrategy(@NotNull VideoResizeOption resizeOption) {
        MediaFormatStrategy mediaFormatStrategy;
        Intrinsics.checkParameterIsNotNull((Object)resizeOption, (String)"resizeOption");
        switch (VideoProcessorKt$WhenMappings.$EnumSwitchMapping$0[resizeOption.getResolutionType().ordinal()]) {
            case 1: {
                mediaFormatStrategy = new AS480Strategy(resizeOption.getVideoBitrate(), resizeOption.getAudioBitrate(), resizeOption.getAudioChannel());
                break;
            }
            case 2: {
                mediaFormatStrategy = new AS720Strategy(resizeOption.getVideoBitrate(), resizeOption.getAudioBitrate(), resizeOption.getAudioChannel());
                break;
            }
            case 3: {
                mediaFormatStrategy = new AS960Strategy(resizeOption.getAudioBitrate(), resizeOption.getAudioChannel());
                break;
            }
            case 4: {
                mediaFormatStrategy = resizeOption.getCustomStrategy();
                if (mediaFormatStrategy != null) break;
                mediaFormatStrategy = new AS720Strategy(resizeOption.getVideoBitrate(), resizeOption.getAudioBitrate(), resizeOption.getAudioChannel());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return mediaFormatStrategy;
    }
}

