/*
 * Decompiled with CFR 0.152.
 */
package pyxis.uzuki.live.mediaresizer.processor;

import android.content.Context;
import android.graphics.Bitmap;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pyxis.uzuki.live.mediaresizer.MediaResizer;
import pyxis.uzuki.live.mediaresizer.MediaResizerGlobalKt;
import pyxis.uzuki.live.mediaresizer.UtilsKt;
import pyxis.uzuki.live.mediaresizer.data.ImageResizeOption;
import pyxis.uzuki.live.mediaresizer.data.ResizeOption;
import pyxis.uzuki.live.mediaresizer.model.ImageMode;
import pyxis.uzuki.live.mediaresizer.model.ScanRequest;
import pyxis.uzuki.live.richutilskt.utils.RichUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\u0010"}, d2={"resizeBitmap", "Landroid/graphics/Bitmap;", "image", "maxWidth", "", "maxHeight", "filter", "", "resizeImage", "", "option", "Lpyxis/uzuki/live/mediaresizer/data/ResizeOption;", "resizeImageInternally", "Lkotlin/Pair;", "", "resizeImageSynchronously", "Resizer_release"})
public final class ImageProcessorKt {
    public static final void resizeImage(@NotNull ResizeOption option) {
        Pair<Boolean, String> pair;
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        Pair<Boolean, String> $isSuccess_imagePath = pair = ImageProcessorKt.resizeImageInternally(option);
        boolean isSuccess = (Boolean)$isSuccess_imagePath.component1();
        String imagePath = (String)$isSuccess_imagePath.component2();
        MediaResizer.INSTANCE.executeCallback(option, isSuccess, imagePath);
    }

    @NotNull
    public static final Pair<Integer, String> resizeImageSynchronously(@NotNull ResizeOption option) {
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        Pair<Boolean, String> result = ImageProcessorKt.resizeImageInternally(option);
        int flag = (Boolean)result.getFirst() != false ? 1 : -1;
        return TuplesKt.to((Object)flag, (Object)result.getSecond());
    }

    @NotNull
    public static final Pair<Boolean, String> resizeImageInternally(@NotNull ResizeOption option) {
        ImageResizeOption imageResizeOption;
        Bitmap newBitmap;
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)option, (String)"option");
        Bitmap bitmap2 = RichUtils.getBitmap((String)option.getTargetPath());
        if (bitmap2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.graphics.Bitmap");
        }
        Bitmap bitmap3 = bitmap2;
        int degree = RichUtils.getPhotoOrientationDegree((String)option.getTargetPath());
        Bitmap rotated = RichUtils.rotate((Bitmap)bitmap3, (int)degree);
        File imageFile = RichUtils.toFile((String)option.getOutputPath());
        ImageResizeOption imageResizeOption2 = option.getImageResizeOption();
        boolean enableResize = Intrinsics.areEqual((Object)((Object)(imageResizeOption2 != null ? imageResizeOption2.getMode() : null)), (Object)((Object)ImageMode.CompressOnly)) ^ true;
        if (enableResize) {
            boolean filter;
            Pair pair = option.getImageResizeOption();
            if (pair == null || (pair = pair.getImageResolution()) == null) {
                pair = TuplesKt.to((Object)1280, (Object)720);
            }
            Pair pair2 = pair;
            ImageResizeOption imageResizeOption3 = option.getImageResizeOption();
            boolean bl = filter = imageResizeOption3 != null ? imageResizeOption3.getBitmapFilter() : true;
            bitmap = rotated.getWidth() < rotated.getHeight() ? ImageProcessorKt.resizeBitmap(rotated, ((Number)pair2.getSecond()).intValue(), ((Number)pair2.getFirst()).intValue(), filter) : ImageProcessorKt.resizeBitmap(rotated, ((Number)pair2.getFirst()).intValue(), ((Number)pair2.getSecond()).intValue(), filter);
        } else {
            bitmap = newBitmap = rotated;
        }
        if ((imageResizeOption = option.getImageResizeOption()) == null || (imageResizeOption = imageResizeOption.getFormat()) == null) {
            imageResizeOption = Bitmap.CompressFormat.JPEG;
        }
        ImageResizeOption imageResizeOption4 = option.getImageResizeOption();
        UtilsKt.saveBitmapToFile(imageFile, newBitmap, (Bitmap.CompressFormat)imageResizeOption, imageResizeOption4 != null ? imageResizeOption4.getCompressQuality() : 100);
        Object object = option.getImageResizeOption();
        if (object == null || (object = object.getRequest()) == null) {
            object = ScanRequest.FALSE;
        }
        if (Intrinsics.areEqual((Object)object, (Object)((Object)ScanRequest.TRUE))) {
            MediaResizerGlobalKt.useGlobalContext((Function1)new Function1<Context, Unit>(imageFile){
                final /* synthetic */ File $imageFile;

                public final void invoke(@NotNull Context $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    String string = this.$imageFile.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"imageFile.absolutePath");
                    RichUtils.requestMediaScanner((Context)$receiver, (String)string);
                }
                {
                    this.$imageFile = file;
                    super(1);
                }
            });
        }
        return TuplesKt.to((Object)true, (Object)imageFile.getAbsolutePath());
    }

    private static final Bitmap resizeBitmap(Bitmap image, int maxWidth, int maxHeight, boolean filter) {
        if (maxHeight <= 0 || maxWidth <= 0) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        float ratioBitmap = (float)width / (float)height;
        float ratioMax = (float)maxWidth / (float)maxHeight;
        int finalWidth = maxWidth;
        int finalHeight = maxHeight;
        if (ratioMax > ratioBitmap) {
            finalWidth = (int)((float)maxHeight * ratioBitmap);
        } else {
            finalHeight = (int)((float)maxWidth / ratioBitmap);
        }
        Bitmap newImage = Bitmap.createScaledBitmap((Bitmap)image, (int)finalWidth, (int)finalHeight, (boolean)filter);
        if (Intrinsics.areEqual((Object)newImage, (Object)image) ^ true && !image.isRecycled()) {
            image.recycle();
        }
        Bitmap bitmap = newImage;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"newImage");
        return bitmap;
    }
}

