/*
 * Decompiled with CFR 0.152.
 */
package com.studiohartman.jamepad;

import com.badlogic.gdx.jnigen.AntScriptGenerator;
import com.badlogic.gdx.jnigen.BuildConfig;
import com.badlogic.gdx.jnigen.BuildExecutorFixed;
import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.NativeCodeGenerator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;

class JamepadNativesBuild {
    static final String win32crossCompilePath = "/usr/local/cross-tools/i686-w64-mingw32/bin/";
    static final String win64crossCompilePath = "/usr/local/cross-tools/x86_64-w64-mingw32/bin/";
    static final String minSDLversion = "2.0.9";
    static final String macLibPath = "/usr/local/lib/libSDL2.a";

    JamepadNativesBuild() {
    }

    public static void main(String[] args) throws Exception {
        String libraries;
        String cflags;
        boolean useSystemSDL = false;
        boolean buildWindows = false;
        boolean buildLinux = false;
        boolean buildOSX = false;
        boolean buildLinux32 = false;
        boolean buildLinuxARM = false;
        String[] stringArray = args;
        int n = stringArray.length;
        block16: for (int i = 0; i < n; ++i) {
            String s;
            switch (s = stringArray[i]) {
                case "system-SDL2": {
                    useSystemSDL = true;
                    continue block16;
                }
                case "build-windows": {
                    buildWindows = true;
                    continue block16;
                }
                case "build-linux": {
                    buildLinux = true;
                    continue block16;
                }
                case "build-linux32": {
                    buildLinux32 = true;
                    continue block16;
                }
                case "build-linuxARM": {
                    buildLinuxARM = true;
                    continue block16;
                }
                case "build-OSX": {
                    buildOSX = true;
                }
            }
        }
        System.out.println("Using system SDL          (arg: system-SDL2)   " + (useSystemSDL ? "ON" : "OFF"));
        System.out.println("Building for Windows64/32 (arg: build-windows) " + (buildWindows ? "ON" : "OFF"));
        System.out.println("Building for Linux64      (arg: build-linux)   " + (buildLinux ? "ON" : "OFF"));
        System.out.println("Building for Linux32      (arg: build-linux32)   " + (buildLinux32 ? "ON" : "OFF"));
        System.out.println("Building for LinuxARM      (arg: build-linuxARM)   " + (buildLinuxARM ? "ON" : "OFF"));
        System.out.println("Building for OSX64        (arg: build-OSX)     " + (buildOSX ? "ON" : "OFF"));
        System.out.println();
        BuildTarget lin32 = BuildTarget.newDefaultTarget((BuildTarget.TargetOs)BuildTarget.TargetOs.Linux, (boolean)false);
        BuildTarget lin64 = BuildTarget.newDefaultTarget((BuildTarget.TargetOs)BuildTarget.TargetOs.Linux, (boolean)true);
        BuildTarget linARM = BuildTarget.newDefaultTarget((BuildTarget.TargetOs)BuildTarget.TargetOs.Linux, (boolean)false);
        BuildTarget win32 = BuildTarget.newDefaultTarget((BuildTarget.TargetOs)BuildTarget.TargetOs.Windows, (boolean)false);
        BuildTarget win64 = BuildTarget.newDefaultTarget((BuildTarget.TargetOs)BuildTarget.TargetOs.Windows, (boolean)true);
        BuildTarget mac64 = BuildTarget.newDefaultTarget((BuildTarget.TargetOs)BuildTarget.TargetOs.MacOsX, (boolean)true);
        if (buildLinux) {
            JamepadNativesBuild.checkSDLVersion("sdl2-config", minSDLversion);
            lin64.cIncludes = new String[0];
            cflags = JamepadNativesBuild.execCmd("sdl2-config --cflags");
            lin64.cppFlags = lin64.cFlags = lin64.cFlags + " " + cflags;
            lin64.linkerFlags = "-shared -m64";
            lin64.libraries = libraries = JamepadNativesBuild.execCmd("sdl2-config --static-libs").replace("-lSDL2", "-l:libSDL2.a");
        }
        if (buildLinuxARM) {
            linARM.buildFileName = "build-linuxARM.xml";
            JamepadNativesBuild.checkSDLVersion("sdl2-config", minSDLversion);
            linARM.cIncludes = new String[0];
            cflags = JamepadNativesBuild.execCmd("sdl2-config --cflags");
            linARM.cppFlags = linARM.cFlags = "-c -Wall -O2 " + cflags;
            linARM.linkerFlags = "-shared";
            linARM.libraries = libraries = JamepadNativesBuild.execCmd("sdl2-config --static-libs").replace("-lSDL2", "-l:libSDL2.a");
            linARM.osFileName = "linuxArm";
            linARM.libName = "libjamepadArm.so";
        }
        if (buildLinux32) {
            JamepadNativesBuild.checkSDLVersion("sdl2-config", minSDLversion);
            lin32.cIncludes = new String[0];
            cflags = JamepadNativesBuild.execCmd("sdl2-config --cflags");
            lin32.cppFlags = lin32.cFlags = lin32.cFlags + " " + cflags;
            lin32.linkerFlags = "-shared -m32";
            lin32.libraries = libraries = JamepadNativesBuild.execCmd("sdl2-config --static-libs").replace("-lSDL2", "-l:libSDL2.a");
        }
        if (buildOSX) {
            JamepadNativesBuild.checkSDLVersion("sdl2-config", minSDLversion);
            mac64.cIncludes = new String[0];
            cflags = JamepadNativesBuild.execCmd("sdl2-config --cflags");
            mac64.cppFlags = mac64.cFlags = cflags + " -c -Wall -O2 -arch x86_64 -DFIXED_POINT -fmessage-length=0 -fPIC -mmacosx-version-min=10.6";
            mac64.linkerFlags = "-shared -arch x86_64 -mmacosx-version-min=10.6";
            mac64.libraries = "/usr/local/lib/libSDL2.a -lm -liconv -Wl,-framework,CoreAudio -Wl,-framework,AudioToolbox -Wl,-framework,ForceFeedback -lobjc -Wl,-framework,CoreVideo -Wl,-framework,Cocoa -Wl,-framework,Carbon -Wl,-framework,IOKit -Wl,-weak_framework,QuartzCore -Wl,-weak_framework,Metal";
        }
        if (buildWindows) {
            JamepadNativesBuild.checkSDLVersion("/usr/local/cross-tools/i686-w64-mingw32/bin/sdl2-config", minSDLversion);
            JamepadNativesBuild.checkSDLVersion("/usr/local/cross-tools/x86_64-w64-mingw32/bin/sdl2-config", minSDLversion);
            win32.cppFlags = win32.cFlags = win32.cFlags + " " + JamepadNativesBuild.execCmd("/usr/local/cross-tools/i686-w64-mingw32/bin/sdl2-config --cflags");
            win32.libraries = JamepadNativesBuild.execCmd("/usr/local/cross-tools/i686-w64-mingw32/bin/sdl2-config --static-libs");
            win64.cppFlags = win64.cFlags = win64.cFlags + " " + JamepadNativesBuild.execCmd("/usr/local/cross-tools/x86_64-w64-mingw32/bin/sdl2-config --cflags");
            win64.libraries = JamepadNativesBuild.execCmd("/usr/local/cross-tools/x86_64-w64-mingw32/bin/sdl2-config --static-libs");
        }
        System.out.println("##### GENERATING NATIVE CODE AND BUILD SCRIPTS #####");
        new NativeCodeGenerator().generate("src", "build/classes/main", "jni");
        new AntScriptGenerator().generate(new BuildConfig("jamepad", "build/tmp", "libs", "jni"), new BuildTarget[]{win32, win64, lin64, lin32, linARM, mac64});
        System.out.println();
        if (!useSystemSDL) {
            throw new IllegalArgumentException("system SDL must be used!");
        }
        if (buildWindows) {
            System.out.println("##### COMPILING NATIVES FOR WINDOWS #####");
            BuildExecutorFixed.executeAnt("jni/build-windows32.xml", "-Dhas-compiler=true clean postcompile");
            BuildExecutorFixed.executeAnt("jni/build-windows64.xml", "-Dhas-compiler=true clean postcompile");
            System.out.println();
        }
        if (buildLinux) {
            System.out.println("##### COMPILING NATIVES FOR LINUX64 #####");
            BuildExecutorFixed.executeAnt("jni/build-linux64.xml", "-Dhas-compiler=true clean postcompile");
            System.out.println();
        }
        if (buildLinux32) {
            System.out.println("##### COMPILING NATIVES FOR LINUX32 #####");
            BuildExecutorFixed.executeAnt("jni/build-linux32.xml", "-Dhas-compiler=true clean postcompile");
            System.out.println();
        }
        if (buildLinuxARM) {
            System.out.println("##### COMPILING NATIVES FOR LINUXARM #####");
            BuildExecutorFixed.executeAnt("jni/build-linuxARM.xml", "-Dhas-compiler=true clean postcompile");
            System.out.println();
        }
        if (buildOSX) {
            System.out.println("##### COMPILING NATIVES FOR OSX #####");
            BuildExecutorFixed.executeAnt("jni/build-macosx64.xml", "-Dhas-compiler=true clean postcompile");
            System.out.println();
        }
        System.out.println("##### PACKING NATIVES INTO .JAR #####");
        BuildExecutorFixed.executeAnt("jni/build.xml", "pack-natives");
    }

    private static void checkSDLVersion(String command, String version) throws FileNotFoundException {
        String sdl = "0";
        try {
            sdl = JamepadNativesBuild.execCmd(command + " --version").trim();
        }
        catch (Exception e) {
            System.out.println("SDL must be installed and " + command + " command must be on path.");
            e.printStackTrace();
        }
        System.out.println("SDL version found: " + sdl);
        if (JamepadNativesBuild.compareVersions(sdl, version) < 0) {
            throw new FileNotFoundException("\n!!! SDL version must be >= " + version);
        }
    }

    public static String execCmd(String cmd) throws IOException {
        Scanner s = new Scanner(Runtime.getRuntime().exec(cmd).getInputStream()).useDelimiter("\\A");
        return s.hasNext() ? s.next().trim() : "";
    }

    public static int compareVersions(String v1, String v2) {
        String[] components1 = v1.split("\\.");
        String[] components2 = v2.split("\\.");
        int length = Math.min(components1.length, components2.length);
        for (int i = 0; i < length; ++i) {
            int result = new Integer(components1[i]).compareTo(Integer.parseInt(components2[i]));
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(components1.length, components2.length);
    }
}

