/*
 * Decompiled with CFR 0.152.
 */
package com.studiohartman.jamepad;

import com.badlogic.gdx.jnigen.JniGenSharedLibraryLoader;
import com.studiohartman.jamepad.ControllerIndex;
import com.studiohartman.jamepad.ControllerState;
import com.studiohartman.jamepad.ControllerUnpluggedException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class ControllerManager {
    private String mappingsPath;
    private boolean isInitialized;
    private ControllerIndex[] controllers;

    public ControllerManager() {
        this(4, "/gamecontrollerdb.txt");
    }

    public ControllerManager(int maxNumControllers) {
        this(maxNumControllers, "/gamecontrollerdb.txt");
    }

    public ControllerManager(int maxNumControllers, String mappingsPath) {
        this.mappingsPath = mappingsPath;
        this.isInitialized = false;
        this.controllers = new ControllerIndex[maxNumControllers];
        new JniGenSharedLibraryLoader().load("jamepad");
    }

    public void initSDLGamepad() throws IllegalStateException {
        if (this.isInitialized) {
            throw new IllegalStateException("SDL is already initialized!");
        }
        if (!this.nativeInitSDLGamepad()) {
            throw new IllegalStateException("Failed to initialize SDL in native method!");
        }
        this.isInitialized = true;
        try {
            this.addMappingsFromFile(this.mappingsPath);
        }
        catch (IOException | IllegalStateException e) {
            System.err.println("Failed to load mapping with original location \"" + this.mappingsPath + "\", Falling back of SDL's built in mappings");
            e.printStackTrace();
        }
        for (int i = 0; i < this.controllers.length; ++i) {
            this.controllers[i] = new ControllerIndex(i);
        }
    }

    private native boolean nativeInitSDLGamepad();

    public void quitSDLGamepad() {
        for (ControllerIndex c : this.controllers) {
            c.close();
        }
        this.nativeCloseSDLGamepad();
        this.controllers = new ControllerIndex[0];
        this.isInitialized = false;
    }

    private native void nativeCloseSDLGamepad();

    public ControllerState getState(int index) throws IllegalStateException {
        this.verifyInitialized();
        if (index < this.controllers.length && index >= 0) {
            this.update();
            return ControllerState.getInstanceFromController(this.controllers[index]);
        }
        return ControllerState.getDisconnectedControllerInstance();
    }

    public boolean doVibration(int index, float leftMagnitude, float rightMagnitude, int duration_ms) throws IllegalStateException {
        this.verifyInitialized();
        if (index < this.controllers.length && index >= 0) {
            try {
                return this.controllers[index].doVibration(leftMagnitude, rightMagnitude, duration_ms);
            }
            catch (ControllerUnpluggedException e) {
                return false;
            }
        }
        return false;
    }

    @Deprecated
    public boolean startVibration(int index, float leftMagnitude, float rightMagnitude) throws IllegalStateException {
        return this.doVibration(index, leftMagnitude, rightMagnitude, 1000);
    }

    @Deprecated
    public void stopVibration(int index) {
        this.verifyInitialized();
        if (index < this.controllers.length && index >= 0) {
            this.controllers[index].stopVibration();
        }
    }

    public ControllerIndex getControllerIndex(int index) {
        this.verifyInitialized();
        return this.controllers[index];
    }

    public int getNumControllers() {
        this.verifyInitialized();
        return this.nativeGetNumRollers();
    }

    private native int nativeGetNumRollers();

    public void update() {
        this.verifyInitialized();
        if (this.nativeControllerConnectedOrDisconnected()) {
            for (int i = 0; i < this.controllers.length; ++i) {
                this.controllers[i].reconnectController();
            }
        }
    }

    private native boolean nativeControllerConnectedOrDisconnected();

    public void addMappingsFromFile(String path) throws IOException, IllegalStateException {
        Path extractedLoc = Files.createTempFile(null, null, new FileAttribute[0]).toAbsolutePath();
        InputStream source = this.getClass().getResourceAsStream(path);
        if (source == null) {
            source = ClassLoader.getSystemResourceAsStream(path);
        }
        if (source == null) {
            throw new IOException("Cannot open resource from classpath " + path);
        }
        Files.copy(source, extractedLoc, StandardCopyOption.REPLACE_EXISTING);
        if (!this.nativeAddMappingsFromFile(extractedLoc.toString())) {
            throw new IllegalStateException("Failed to set SDL controller mappings! Falling back to build in SDL mappings.");
        }
        Files.delete(extractedLoc);
    }

    private native boolean nativeAddMappingsFromFile(String var1);

    private boolean verifyInitialized() throws IllegalStateException {
        if (!this.isInitialized) {
            throw new IllegalStateException("SDL_GameController is not initialized!");
        }
        return true;
    }
}

