/*
 * Decompiled with CFR 0.152.
 */
package com.studiohartman.jamepad.tester;

import com.studiohartman.jamepad.ControllerIndex;
import com.studiohartman.jamepad.ControllerManager;
import com.studiohartman.jamepad.tester.ControllerInfoPanel;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class ControllerTester {
    public static int NUM_CONTROLLERS = 4;

    public static void run() {
        int i;
        JTabbedPane tabbedPane = new JTabbedPane();
        ControllerManager controllers = new ControllerManager(NUM_CONTROLLERS);
        controllers.initSDLGamepad();
        JFrame testFrame = new JFrame();
        testFrame.setDefaultCloseOperation(3);
        testFrame.setLocationRelativeTo(null);
        testFrame.setMinimumSize(new Dimension(640, 350));
        testFrame.setResizable(false);
        testFrame.setVisible(true);
        ControllerInfoPanel[] controllerTabs = new ControllerInfoPanel[NUM_CONTROLLERS];
        for (i = 0; i < NUM_CONTROLLERS; ++i) {
            controllerTabs[i] = new ControllerInfoPanel();
            tabbedPane.add("   Controller " + (i + 1) + "   ", controllerTabs[i]);
        }
        testFrame.setContentPane(tabbedPane);
        while (true) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            controllers.update();
            for (i = 0; i < controllerTabs.length; ++i) {
                ControllerIndex controllerAtIndex = controllers.getControllerIndex(i);
                if (controllerAtIndex.isConnected()) {
                    controllerTabs[i].updatePanel(controllerAtIndex);
                    continue;
                }
                controllerTabs[i].setAsDisconnected();
            }
            testFrame.repaint();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ControllerTester.run();
    }
}

