/*
 * Decompiled with CFR 0.152.
 */
package com.studiohartman.jamepad.tester;

import com.studiohartman.jamepad.ControllerAxis;
import com.studiohartman.jamepad.ControllerButton;
import com.studiohartman.jamepad.ControllerIndex;
import com.studiohartman.jamepad.ControllerUnpluggedException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ControllerInfoPanel
extends JPanel {
    private JPanel title;
    private JPanel axes;
    private JPanel buttons;
    private JButton vibrateButton;
    private JButton stopVibrateButton;
    private JLabel titleLabel;

    public ControllerInfoPanel() {
        this.setLayout(new BorderLayout());
        this.title = new JPanel();
        this.axes = new JPanel();
        this.buttons = new JPanel();
        JPanel vibratePanel = new JPanel();
        this.vibrateButton = new JButton("Start vibrating");
        this.stopVibrateButton = new JButton("Stop vibrating");
        vibratePanel.add(this.vibrateButton);
        vibratePanel.add(this.stopVibrateButton);
        this.title.setLayout(new BoxLayout(this.title, 1));
        this.title.setAlignmentX(0.5f);
        this.titleLabel = new JLabel();
        this.title.add(this.titleLabel);
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(new BoxLayout(middlePanel, 1));
        middlePanel.add(this.title);
        middlePanel.add(this.axes);
        middlePanel.add(this.buttons);
        this.add(middlePanel);
        this.add((Component)vibratePanel, "South");
    }

    public void updatePanel(ControllerIndex c) {
        try {
            this.titleLabel.setText(c.getName());
            this.axes.removeAll();
            for (ControllerAxis controllerAxis : ControllerAxis.values()) {
                JLabel label = new JLabel();
                label.setPreferredSize(new Dimension(100, 30));
                label.setText(controllerAxis.name());
                JProgressBar progressBar = new JProgressBar(-100, 100);
                progressBar.setPreferredSize(new Dimension(200, 30));
                progressBar.setValue((int)(c.getAxisState(controllerAxis) * 100.0f));
                JPanel axisPanel = new JPanel();
                axisPanel.setLayout(new BoxLayout(axisPanel, 0));
                axisPanel.add(label);
                axisPanel.add(progressBar);
                this.axes.add(axisPanel);
            }
            this.buttons.removeAll();
            for (Enum enum_ : ControllerButton.values()) {
                JButton button = new JButton(enum_.name());
                button.setEnabled(c.isButtonPressed((ControllerButton)enum_));
                this.buttons.add(button);
            }
            Arrays.stream(this.vibrateButton.getActionListeners()).forEach(this.vibrateButton::removeActionListener);
            this.vibrateButton.addActionListener(event -> {
                try {
                    c.startVibration(1.0f, 1.0f);
                }
                catch (ControllerUnpluggedException e) {
                    System.err.println("Failed to vibrate!");
                }
            });
            Arrays.stream(this.stopVibrateButton.getActionListeners()).forEach(this.stopVibrateButton::removeActionListener);
            this.stopVibrateButton.addActionListener(event -> c.stopVibration());
        }
        catch (ControllerUnpluggedException e) {
            e.printStackTrace();
            this.titleLabel.setText("a Jamepad runtime exception occurred!");
            this.axes.removeAll();
            this.buttons.removeAll();
            this.axes.add(new JLabel(e.getMessage()));
        }
    }

    public void setAsDisconnected() {
        this.titleLabel.setText("No controller connected at this index!");
        this.axes.removeAll();
        this.buttons.removeAll();
    }
}

