/*
 * Decompiled with CFR 0.152.
 */
package com.studiohartman.jamepad;

import com.studiohartman.jamepad.ControllerAxis;
import com.studiohartman.jamepad.ControllerButton;
import com.studiohartman.jamepad.ControllerUnpluggedException;

public final class ControllerIndex {
    private static final float AXIS_MAX_VAL = 32767.0f;
    private int index;
    private long controllerPtr;
    private long hapticPtr;
    private int hapticEffectID;
    private boolean[] heldDownButtons;
    private boolean[] justPressedButtons;

    ControllerIndex(int index) {
        this.index = index;
        this.heldDownButtons = new boolean[ControllerButton.values().length];
        this.justPressedButtons = new boolean[ControllerButton.values().length];
        for (int i = 0; i < this.heldDownButtons.length; ++i) {
            this.heldDownButtons[i] = false;
            this.justPressedButtons[i] = false;
        }
        this.hapticEffectID = -1;
        this.connectController();
    }

    private void connectController() {
        this.controllerPtr = this.nativeConnectController(this.index);
        this.hapticPtr = this.nativeConnectHaptic(this.controllerPtr);
        if (this.hapticPtr != 0L) {
            this.hapticEffectID = this.nativeBuildHapticEffect(this.hapticPtr);
        }
    }

    private native long nativeConnectController(int var1);

    private native long nativeConnectHaptic(long var1);

    private native int nativeBuildHapticEffect(long var1);

    public void close() {
        if (this.controllerPtr != 0L) {
            this.nativeClose(this.controllerPtr);
            this.controllerPtr = 0L;
        }
    }

    private native void nativeClose(long var1);

    public boolean reconnectController() {
        this.close();
        this.connectController();
        return this.isConnected();
    }

    public boolean isConnected() {
        return this.controllerPtr != 0L && this.nativeIsConnected(this.controllerPtr);
    }

    private native boolean nativeIsConnected(long var1);

    public int getIndex() {
        return this.index;
    }

    public boolean isVibrating() {
        return this.hapticPtr != 0L;
    }

    public boolean startVibration(float leftMagnitude, float rightMagnitude) throws ControllerUnpluggedException {
        boolean rightInRange;
        this.ensureConnected();
        boolean leftInRange = leftMagnitude >= 0.0f && leftMagnitude <= 1.0f;
        boolean bl = rightInRange = rightMagnitude >= 0.0f && rightMagnitude <= 1.0f;
        if (!leftInRange || !rightInRange) {
            throw new IllegalArgumentException("The passed values are not in the range 0 to 1!");
        }
        if (this.hapticPtr == 0L) {
            return false;
        }
        return this.nativeStartVibration(this.hapticPtr, this.hapticEffectID, (int)(32767.0f * leftMagnitude), (int)(32767.0f * rightMagnitude));
    }

    private native boolean nativeStartVibration(long var1, int var3, int var4, int var5);

    public void stopVibration() {
        this.nativeStopVibration(this.hapticPtr);
    }

    private native void nativeStopVibration(long var1);

    public boolean isButtonPressed(ControllerButton toCheck) throws ControllerUnpluggedException {
        this.updateButton(toCheck.ordinal());
        return this.heldDownButtons[toCheck.ordinal()];
    }

    public boolean isButtonJustPressed(ControllerButton toCheck) throws ControllerUnpluggedException {
        this.updateButton(toCheck.ordinal());
        return this.justPressedButtons[toCheck.ordinal()];
    }

    private void updateButton(int buttonIndex) throws ControllerUnpluggedException {
        this.ensureConnected();
        boolean currButtonIsPressed = this.nativeCheckButton(this.controllerPtr, buttonIndex);
        this.justPressedButtons[buttonIndex] = currButtonIsPressed && !this.heldDownButtons[buttonIndex];
        this.heldDownButtons[buttonIndex] = currButtonIsPressed;
    }

    private native boolean nativeCheckButton(long var1, int var3);

    public float getAxisState(ControllerAxis toCheck) throws ControllerUnpluggedException {
        this.ensureConnected();
        float toReturn = toCheck == ControllerAxis.LEFTY || toCheck == ControllerAxis.RIGHTY ? (float)this.nativeCheckAxis(this.controllerPtr, toCheck.ordinal()) / -32767.0f : (float)this.nativeCheckAxis(this.controllerPtr, toCheck.ordinal()) / 32767.0f;
        return toReturn;
    }

    private native int nativeCheckAxis(long var1, int var3);

    public String getName() throws ControllerUnpluggedException {
        this.ensureConnected();
        String controllerName = this.nativeGetName(this.controllerPtr);
        if (controllerName == null) {
            return "Unnamed Controller";
        }
        return controllerName;
    }

    private native String nativeGetName(long var1);

    private void ensureConnected() throws ControllerUnpluggedException {
        if (!this.isConnected()) {
            throw new ControllerUnpluggedException("Controller at index " + this.index + " is not connected!");
        }
    }
}

