/*
 * Decompiled with CFR 0.152.
 */
package me.william278.husktowns.chunk;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import me.william278.husktowns.chunk.ChunkLocation;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ClaimedChunk
extends ChunkLocation {
    private final ChunkType chunkType;
    private final UUID claimer;
    private final long claimTimestamp;
    private String town;
    private final UUID plotChunkOwner;
    private final HashSet<UUID> plotChunkMembers = new HashSet();

    public ClaimedChunk(String server, String worldName, int chunkX, int chunkZ, UUID claimerUUID, ChunkType chunkType, UUID plotChunkOwner, HashSet<UUID> plotChunkMembers, String town, long timestamp) {
        super(server, worldName, chunkX, chunkZ);
        this.chunkType = chunkType;
        this.claimer = claimerUUID;
        this.plotChunkOwner = plotChunkOwner;
        this.plotChunkMembers.addAll(plotChunkMembers);
        this.town = town;
        this.claimTimestamp = timestamp;
    }

    public ClaimedChunk(String server, String worldName, int chunkX, int chunkZ, UUID claimerUUID, ChunkType chunkType, String town, long timestamp) {
        super(server, worldName, chunkX, chunkZ);
        this.chunkType = chunkType;
        this.claimer = claimerUUID;
        this.plotChunkOwner = null;
        this.town = town;
        this.claimTimestamp = timestamp;
    }

    public ClaimedChunk(Player player, String server, Location location, String town) {
        super(server, location.getWorld().getName(), location.getChunk().getX(), location.getChunk().getZ());
        this.chunkType = ChunkType.REGULAR;
        this.claimer = player.getUniqueId();
        this.plotChunkOwner = null;
        this.town = town;
        this.claimTimestamp = Instant.now().getEpochSecond();
    }

    public void updateTownName(String newName) {
        this.town = newName;
    }

    public void addPlotMember(UUID plotMember) {
        this.plotChunkMembers.add(plotMember);
    }

    public void removePlotMember(UUID plotMember) {
        this.plotChunkMembers.remove(plotMember);
    }

    public long getClaimTimestamp() {
        return this.claimTimestamp;
    }

    public String getFormattedClaimTime() {
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.SHORT).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault()).format(Instant.ofEpochSecond(this.getClaimTimestamp()));
    }

    public UUID getClaimerUUID() {
        return this.claimer;
    }

    public UUID getPlotChunkOwner() {
        return this.plotChunkOwner;
    }

    public HashSet<UUID> getPlotChunkMembers() {
        return this.plotChunkMembers;
    }

    public ChunkType getChunkType() {
        return this.chunkType;
    }

    public String getTown() {
        return this.town;
    }

    public static enum ChunkType {
        REGULAR,
        FARM,
        PLOT;

    }

    public static enum PlayerAccess {
        CAN_PERFORM_ACTION_PLOT_OWNER,
        CAN_PERFORM_ACTION_PLOT_MEMBER,
        CAN_PERFORM_ACTION_TOWN_FARM,
        CAN_PERFORM_ACTION_IGNORING_CLAIMS,
        CAN_PERFORM_ACTION_ADMIN_CLAIM_ACCESS,
        CAN_PERFORM_ACTION_TRUSTED,
        CAN_PERFORM_ACTION_PUBLIC_BUILD_ACCESS_FLAG,
        CANNOT_PERFORM_ACTION_RESIDENT,
        CANNOT_PERFORM_ACTION_ADMIN_CLAIM,
        CANNOT_PERFORM_ACTION_NOT_IN_TOWN,
        CANNOT_PERFORM_ACTION_DIFFERENT_TOWN;

    }
}

