/*
 * Decompiled with CFR 0.152.
 */
package me.william278.husktowns;

import java.awt.Color;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.logging.Level;
import me.william278.husktowns.HuskTowns;
import me.william278.husktowns.MessageManager;
import me.william278.husktowns.cache.CacheStatus;
import me.william278.husktowns.cache.ClaimCache;
import me.william278.husktowns.cache.PlayerCache;
import me.william278.husktowns.cache.TownDataCache;
import me.william278.husktowns.chunk.ClaimedChunk;
import me.william278.husktowns.data.DataManager;
import me.william278.husktowns.flags.Flag;
import me.william278.husktowns.listener.ActionType;
import me.william278.husktowns.town.Town;
import me.william278.husktowns.town.TownBonus;
import me.william278.husktowns.town.TownRole;
import me.william278.husktowns.util.AccessManager;
import me.william278.husktowns.util.TownLimitsUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HuskTownsAPI {
    private static HuskTownsAPI instance;

    public static HuskTownsAPI getInstance() {
        if (instance == null) {
            instance = new HuskTownsAPI();
        }
        return instance;
    }

    public boolean isWilderness(Block block) {
        return this.isWilderness(block.getLocation());
    }

    public boolean isWilderness(Location location) {
        ClaimCache cache = HuskTowns.getClaimCache();
        if (cache.getStatus() == CacheStatus.LOADED) {
            return cache.getChunkAt(location.getChunk().getX(), location.getChunk().getZ(), location.getWorld().getName()) == null;
        }
        return true;
    }

    public String getTownAt(Location location) {
        return this.getClaimedChunk(location).getTown();
    }

    public ClaimedChunk getClaimedChunk(Location location) {
        int chunkX = location.getChunk().getX();
        int chunkZ = location.getChunk().getZ();
        World world = location.getWorld();
        ClaimCache cache = HuskTowns.getClaimCache();
        if (cache.getStatus() == CacheStatus.LOADED) {
            return cache.getChunkAt(chunkX, chunkZ, world.getName());
        }
        return null;
    }

    public boolean isClaimed(Location location) {
        return !this.isWilderness(location);
    }

    public TownRole getPlayerTownRole(UUID playerUUID) {
        PlayerCache cache = HuskTowns.getPlayerCache();
        if (cache.getStatus() == CacheStatus.LOADED) {
            return cache.getPlayerRole(playerUUID);
        }
        return null;
    }

    public TownRole getPlayerTownRole(Player player) {
        return this.getPlayerTownRole(player.getUniqueId());
    }

    public String getPlayerTown(Player player) {
        return this.getPlayerTown(player.getUniqueId());
    }

    public boolean isInTown(Player player) {
        return this.getPlayerTown(player) != null;
    }

    public String getPlayerTown(UUID playerUUID) {
        PlayerCache playerCache = HuskTowns.getPlayerCache();
        if (playerCache.getStatus() == CacheStatus.LOADED) {
            return playerCache.getPlayerTown(playerUUID);
        }
        return null;
    }

    public boolean isStandingInTown(Player player) {
        if (!this.isInTown(player)) {
            return false;
        }
        return this.isLocationClaimedByTown(player.getLocation(), this.getPlayerTown(player));
    }

    public boolean isLocationClaimedByTown(Location location, String townName) {
        return this.getClaimedChunk(location).getTown().equals(townName);
    }

    public boolean isActionAllowed(Location location, ActionType actionType) {
        return Flag.isActionAllowed((Location)location, (ActionType)actionType);
    }

    public boolean canPerformAction(Player player, Location location, ActionType actionType) {
        return this.canPerformAction(player.getUniqueId(), location, actionType);
    }

    public boolean canBuild(Player player, Location location) {
        return this.canBuild(player.getUniqueId(), location);
    }

    public boolean canOpenContainers(Player player, Location location) {
        return this.canOpenContainers(player.getUniqueId(), location);
    }

    public boolean canInteract(Player player, Location location) {
        return this.canInteract(player.getUniqueId(), location);
    }

    public boolean canPerformAction(UUID uuid, Location location, ActionType actionType) {
        ClaimCache claimCache = HuskTowns.getClaimCache();
        if (!claimCache.hasLoaded()) {
            return false;
        }
        PlayerCache playerCache = HuskTowns.getPlayerCache();
        if (!playerCache.hasLoaded()) {
            return false;
        }
        if (this.isWilderness(location)) {
            return true;
        }
        return switch (AccessManager.getPlayerAccess((UUID)uuid, (ActionType)actionType, (ClaimedChunk)this.getClaimedChunk(location), (boolean)true)) {
            case ClaimedChunk.PlayerAccess.CAN_PERFORM_ACTION_TRUSTED, ClaimedChunk.PlayerAccess.CAN_PERFORM_ACTION_TOWN_FARM, ClaimedChunk.PlayerAccess.CAN_PERFORM_ACTION_PLOT_MEMBER, ClaimedChunk.PlayerAccess.CAN_PERFORM_ACTION_PLOT_OWNER, ClaimedChunk.PlayerAccess.CAN_PERFORM_ACTION_IGNORING_CLAIMS, ClaimedChunk.PlayerAccess.CAN_PERFORM_ACTION_ADMIN_CLAIM_ACCESS, ClaimedChunk.PlayerAccess.CAN_PERFORM_ACTION_PUBLIC_BUILD_ACCESS_FLAG -> true;
            default -> false;
        };
    }

    public boolean canBuild(UUID uuid, Location location) {
        return this.canPerformAction(uuid, location, ActionType.PLACE_BLOCK);
    }

    public boolean canOpenContainers(UUID uuid, Location location) {
        return this.canPerformAction(uuid, location, ActionType.OPEN_CONTAINER);
    }

    public boolean canInteract(UUID uuid, Location location) {
        return this.canPerformAction(uuid, location, ActionType.INTERACT_BLOCKS);
    }

    public HashSet<String> getPlayersInTown(String townName) {
        PlayerCache cache = HuskTowns.getPlayerCache();
        if (cache.getStatus() == CacheStatus.LOADED) {
            return cache.getPlayersInTown(townName);
        }
        return new HashSet<String>();
    }

    public HashMap<String, TownRole> getPlayersInTownRoles(String townName) {
        HashMap<String, TownRole> playersInTownRoles = new HashMap<String, TownRole>();
        PlayerCache cache = HuskTowns.getPlayerCache();
        if (cache.getStatus() == CacheStatus.LOADED) {
            for (String username : this.getPlayersInTown(townName)) {
                playersInTownRoles.put(username, cache.getPlayerRole(cache.getUUID(username)));
            }
            return playersInTownRoles;
        }
        return new HashMap<String, TownRole>();
    }

    public String getTownMayor(String townName) {
        HashMap<String, TownRole> playersInTownRoles = this.getPlayersInTownRoles(townName);
        for (String username : playersInTownRoles.keySet()) {
            if (playersInTownRoles.get(username) != TownRole.MAYOR) continue;
            return username;
        }
        return null;
    }

    public void addTownBonus(String townName, int bonusClaims, int bonusMembers) {
        TownBonus bonus = new TownBonus(null, bonusClaims, bonusMembers, Instant.now().getEpochSecond());
        DataManager.addTownBonus((CommandSender)Bukkit.getConsoleSender(), (String)townName, (TownBonus)bonus);
    }

    public String getTownGreetingMessage(String townName) {
        TownDataCache cache = HuskTowns.getTownDataCache();
        if (cache.hasLoaded()) {
            return cache.getGreetingMessage(townName);
        }
        return null;
    }

    public String getTownFarewellMessage(String townName) {
        TownDataCache cache = HuskTowns.getTownDataCache();
        if (cache.hasLoaded()) {
            return cache.getFarewellMessage(townName);
        }
        return null;
    }

    public String getTownBio(String townName) {
        TownDataCache cache = HuskTowns.getTownDataCache();
        if (cache.hasLoaded()) {
            return cache.getTownBio(townName);
        }
        return null;
    }

    public HashSet<String> getTowns() {
        if (this.isPlayerCacheLoaded()) {
            return HuskTowns.getPlayerCache().getTowns();
        }
        return null;
    }

    public HashSet<String> getTownsWithPublicSpawns() {
        if (this.isTownDataCacheLoaded()) {
            return HuskTowns.getTownDataCache().getPublicSpawnTowns();
        }
        return null;
    }

    public String getPlayerUsername(UUID uuid) {
        if (this.isPlayerCacheLoaded()) {
            return HuskTowns.getPlayerCache().getPlayerUsername(uuid);
        }
        return null;
    }

    public boolean isClaimCacheLoaded() {
        return HuskTowns.getClaimCache().hasLoaded();
    }

    public CacheStatus getClaimCacheStatus() {
        return HuskTowns.getClaimCache().getStatus();
    }

    public boolean isPlayerCacheLoaded() {
        return HuskTowns.getPlayerCache().hasLoaded();
    }

    public CacheStatus getPlayerCacheStatus() {
        return HuskTowns.getPlayerCache().getStatus();
    }

    public boolean isTownDataCacheLoaded() {
        return HuskTowns.getTownDataCache().hasLoaded();
    }

    public CacheStatus getTownDataCacheStatus() {
        return HuskTowns.getTownDataCache().getStatus();
    }

    public boolean isTownBonusCacheLoaded() {
        return HuskTowns.getTownBonusesCache().hasLoaded();
    }

    public CacheStatus getTownBonusCacheStatus() {
        return HuskTowns.getTownBonusesCache().getStatus();
    }

    public String getTownColorHex(String townName) {
        return Town.getTownColorHex((String)townName);
    }

    public Color getTownColor(String townName) {
        return Town.getTownColor((String)townName);
    }

    public String getMessageString(String messageId) {
        return MessageManager.getRawMessage((String)messageId);
    }

    private Town getTownFromDatabase(String townName) {
        Town town;
        block8: {
            Connection connection = HuskTowns.getConnection();
            try {
                town = DataManager.getTownFromName((String)townName, (Connection)connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    HuskTowns.getInstance().getLogger().log(Level.SEVERE, "An exception occurred pulling data from SQL via the API", e);
                    return null;
                }
            }
            connection.close();
        }
        return town;
    }

    public Double getTownBalance(String townName) {
        Town town = this.getTownFromDatabase(townName);
        if (town != null) {
            return town.getMoneyDeposited();
        }
        return null;
    }

    public Integer getTownLevel(String townName) {
        Town town = this.getTownFromDatabase(townName);
        if (town != null) {
            return town.getLevel();
        }
        return null;
    }

    public Double getAmountToNextLevel(String townName) {
        Double coffers = this.getTownBalance(townName);
        if (coffers != null) {
            return TownLimitsUtil.getNextLevelRequired((double)coffers);
        }
        return null;
    }

    public String getTownFoundedTime(String townName) {
        Town town = this.getTownFromDatabase(townName);
        if (town != null) {
            return town.getFormattedFoundedTime();
        }
        return null;
    }
}

