/*
 * Decompiled with CFR 0.152.
 */
package convalida.validators;

import android.widget.EditText;
import convalida.validators.AbstractValidator;
import java.util.regex.Pattern;

public class EmailValidator
extends AbstractValidator {
    private static final String EMAIL_REGEX = "^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);
    private boolean required;

    public EmailValidator(EditText editText, String errorMessage, boolean autoDismiss, boolean required) {
        super(editText, errorMessage, autoDismiss);
        this.required = required;
    }

    @Override
    public boolean isValid(String value) {
        value = value.replace(" ", "");
        return !(this.required && value.isEmpty() || !value.isEmpty() && !EMAIL_PATTERN.matcher(value).matches());
    }
}

