/*
 * Decompiled with CFR 0.152.
 */
package convalida.compiler;

import com.google.auto.common.SuperficialValidation;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.sun.source.util.Trees;
import com.sun.tools.javac.tree.JCTree;
import convalida.annotations.BetweenValidation;
import convalida.annotations.ClearValidationsOnClick;
import convalida.annotations.ConfirmEmailValidation;
import convalida.annotations.ConfirmPasswordValidation;
import convalida.annotations.CpfValidation;
import convalida.annotations.CreditCardValidation;
import convalida.annotations.EmailValidation;
import convalida.annotations.LengthValidation;
import convalida.annotations.NumberLimitValidation;
import convalida.annotations.OnValidationError;
import convalida.annotations.OnValidationSuccess;
import convalida.annotations.OnlyNumberValidation;
import convalida.annotations.PasswordValidation;
import convalida.annotations.PatternValidation;
import convalida.annotations.RequiredValidation;
import convalida.annotations.ValidateOnClick;
import convalida.compiler.JavaFiler;
import convalida.compiler.Messager;
import convalida.compiler.Preconditions;
import convalida.compiler.internal.Id;
import convalida.compiler.internal.QualifiedId;
import convalida.compiler.internal.ValidationClass;
import convalida.compiler.internal.ValidationField;
import convalida.compiler.internal.scanners.IdScanner;
import convalida.compiler.internal.scanners.RClassScanner;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@SupportedAnnotationTypes(value={"convalida.annotations.RequiredValidation", "convalida.annotations.EmailValidation", "convalida.annotations.ConfirmEmailValidation", "convalida.annotations.PatternValidation", "convalida.annotations.LengthValidation", "convalida.annotations.OnlyNumberValidation", "convalida.annotations.PasswordValidation", "convalida.annotations.ConfirmPasswordValidation", "convalida.annotations.CpfValidation", "convalida.annotations.BetweenValidation.Start", "convalida.annotations.BetweenValidation.End", "convalida.annotations.CreditCardValidation", "convalida.annotations.NumberLimitValidation", "convalida.annotations.ValidateOnClick", "convalida.annotations.ClearValidationsOnClick", "convalida.annotations.OnValidationSuccess", "convalida.annotations.OnValidationError"})
public class ConvalidaProcessor
extends AbstractProcessor {
    private Elements elementUtils;
    private Types typeUtils;
    private Filer filer;
    private Trees trees;
    private final Map<QualifiedId, Id> symbols = new LinkedHashMap<QualifiedId, Id>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.elementUtils = processingEnvironment.getElementUtils();
        this.typeUtils = processingEnvironment.getTypeUtils();
        this.filer = processingEnvironment.getFiler();
        Messager.init(processingEnvironment.getMessager());
        try {
            this.trees = Trees.instance(this.processingEnv);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private Set<Class<? extends Annotation>> getSupportedAnnotations() {
        LinkedHashSet<Class<? extends Annotation>> annotations = new LinkedHashSet<Class<? extends Annotation>>();
        annotations.add(RequiredValidation.class);
        annotations.add(EmailValidation.class);
        annotations.add(ConfirmEmailValidation.class);
        annotations.add(PatternValidation.class);
        annotations.add(LengthValidation.class);
        annotations.add(OnlyNumberValidation.class);
        annotations.add(PasswordValidation.class);
        annotations.add(ConfirmPasswordValidation.class);
        annotations.add(CpfValidation.class);
        annotations.add(BetweenValidation.Start.class);
        annotations.add(BetweenValidation.End.class);
        annotations.add(CreditCardValidation.class);
        annotations.add(NumberLimitValidation.class);
        annotations.add(ValidateOnClick.class);
        annotations.add(ClearValidationsOnClick.class);
        annotations.add(OnValidationSuccess.class);
        annotations.add(OnValidationError.class);
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment env) {
        List<ValidationClass> validationClasses = this.findAndParseValidations(env);
        for (ValidationClass validationClass : validationClasses) {
            try {
                JavaFile javaFile = JavaFiler.cookJava(validationClass);
                javaFile.writeTo(this.filer);
            }
            catch (IOException e) {
                Messager.error(validationClass.typeElement, "Unable to write validation for type %s: %s", validationClass.typeElement, e.getMessage());
            }
        }
        return false;
    }

    private List<ValidationClass> findAndParseValidations(RoundEnvironment env) {
        HashSet<Element> parents = new HashSet<Element>();
        ArrayList<ValidationField> validationFields = new ArrayList<ValidationField>();
        ArrayList<Element> validationActions = new ArrayList<Element>();
        ArrayList<Element> validationResults = new ArrayList<Element>();
        ArrayList<ValidationClass> validationClasses = new ArrayList<ValidationClass>();
        this.scanForRClasses(env);
        for (Element element : env.getElementsAnnotatedWith(RequiredValidation.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseRequiredValidation(element, parents, validationFields);
            }
            catch (Exception e) {
                Messager.logParsingError(element, RequiredValidation.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(EmailValidation.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseEmailValidation(element, parents, validationFields);
            }
            catch (Exception e) {
                Messager.logParsingError(element, EmailValidation.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(ConfirmEmailValidation.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseConfirmEmailValidation(element, parents, validationFields);
            }
            catch (Exception e) {
                Messager.logParsingError(element, ConfirmEmailValidation.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(PatternValidation.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parsePatternValidation(element, parents, validationFields);
            }
            catch (Exception e) {
                Messager.logParsingError(element, PatternValidation.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(LengthValidation.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseLengthValidation(element, parents, validationFields);
            }
            catch (Exception e) {
                Messager.logParsingError(element, LengthValidation.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(OnlyNumberValidation.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseOnlyNumberValidation(element, parents, validationFields);
            }
            catch (Exception e) {
                Messager.logParsingError(element, OnlyNumberValidation.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(PasswordValidation.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parsePasswordValidation(element, parents, validationFields);
            }
            catch (Exception e) {
                Messager.logParsingError(element, PasswordValidation.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(ConfirmPasswordValidation.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseConfirmPasswordValidation(element, parents, validationFields);
            }
            catch (Exception e) {
                Messager.logParsingError(element, ConfirmPasswordValidation.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(CpfValidation.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseCpfValidation(element, parents, validationFields);
            }
            catch (Exception e) {
                Messager.logParsingError(element, CpfValidation.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(BetweenValidation.Start.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseBetweenValidation(element, parents, validationFields);
            }
            catch (Exception e) {
                Messager.logParsingError(element, BetweenValidation.Start.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(CreditCardValidation.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseCreditCardValidation(element, parents, validationFields);
            }
            catch (Exception e) {
                Messager.logParsingError(element, CreditCardValidation.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(NumberLimitValidation.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseNumberLimitValidation(element, parents, validationFields);
            }
            catch (Exception e) {
                Messager.logParsingError(element, NumberLimitValidation.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(ValidateOnClick.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseValidateOnClick(element, parents, validationActions);
            }
            catch (Exception e) {
                Messager.logParsingError(element, ValidateOnClick.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(ClearValidationsOnClick.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseClearValidationsOnClick(element, parents, validationActions);
            }
            catch (Exception e) {
                Messager.logParsingError(element, ClearValidationsOnClick.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(OnValidationSuccess.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseOnValidationSuccess(element, parents, validationResults);
            }
            catch (Exception e) {
                Messager.logParsingError(element, OnValidationSuccess.class, e);
            }
        }
        for (Element element : env.getElementsAnnotatedWith(OnValidationError.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            try {
                this.parseOnValidationError(element, parents, validationResults);
            }
            catch (Exception e) {
                Messager.logParsingError(element, OnValidationError.class, e);
            }
        }
        for (Element element : parents) {
            ValidationClass validationClass = new ValidationClass(element, this.elementUtils);
            this.processValidationFields(element, validationClass, validationFields);
            this.processValidationActions(element, validationClass, validationActions);
            this.processValidationResults(element, validationClass, validationResults);
            validationClasses.add(validationClass);
        }
        return validationClasses;
    }

    private void processValidationFields(Element parent, ValidationClass validationClass, List<ValidationField> validationFields) {
        for (ValidationField validationField : validationFields) {
            Element element = validationField.element;
            if (!element.getEnclosingElement().equals(parent)) continue;
            validationClass.addField(validationField);
        }
    }

    private void processValidationActions(Element parent, ValidationClass validationClass, List<Element> validationActions) {
        for (Element validationAction : validationActions) {
            if (!validationAction.getEnclosingElement().equals(parent)) continue;
            if (validationAction.getAnnotation(ValidateOnClick.class) != null) {
                validationClass.setValidateButton(validationAction);
            }
            if (validationAction.getAnnotation(ClearValidationsOnClick.class) == null) continue;
            validationClass.setClearValidationsButton(validationAction);
        }
    }

    private void processValidationResults(Element parent, ValidationClass validationClass, List<Element> validationResults) {
        for (Element validationResult : validationResults) {
            if (!validationResult.getEnclosingElement().equals(parent)) continue;
            if (validationResult.getAnnotation(OnValidationSuccess.class) != null) {
                validationClass.setOnValidationSuccessMethod(validationResult);
            }
            if (validationResult.getAnnotation(OnValidationError.class) == null) continue;
            validationClass.setOnValidationErrorMethod(validationResult);
        }
    }

    private void parseValidateOnClick(Element element, Set<Element> parents, List<Element> validationActions) {
        boolean hasError;
        Element parent = element.getEnclosingElement();
        boolean bl = hasError = Preconditions.isInaccessible(ValidateOnClick.class, element) || Preconditions.hasMoreThanOneMethodsAnnotatedWith(parent, ValidateOnClick.class);
        if (hasError) {
            return;
        }
        parents.add(parent);
        validationActions.add(element);
    }

    private void parseClearValidationsOnClick(Element element, Set<Element> parents, List<Element> validationActions) {
        boolean hasError;
        Element parent = element.getEnclosingElement();
        boolean bl = hasError = Preconditions.isInaccessible(ClearValidationsOnClick.class, element) || Preconditions.hasMoreThanOneMethodsAnnotatedWith(parent, ClearValidationsOnClick.class);
        if (hasError) {
            return;
        }
        parents.add(parent);
        validationActions.add(element);
    }

    private void parseOnValidationSuccess(Element element, Set<Element> parents, List<Element> validationActions) {
        boolean hasError;
        Element parent = element.getEnclosingElement();
        ExecutableElement executableElement = (ExecutableElement)element;
        boolean bl = hasError = Preconditions.isInaccessible(OnValidationSuccess.class, element) || Preconditions.methodHasParams(executableElement, OnValidationSuccess.class) || Preconditions.hasMoreThanOneMethodsAnnotatedWith(parent, OnValidationSuccess.class);
        if (hasError) {
            return;
        }
        parents.add(parent);
        validationActions.add(element);
    }

    private void parseOnValidationError(Element element, Set<Element> parents, List<Element> validationActions) {
        boolean hasError;
        Element parent = element.getEnclosingElement();
        ExecutableElement executableElement = (ExecutableElement)element;
        boolean bl = hasError = Preconditions.isInaccessible(OnValidationError.class, element) || Preconditions.methodHasParams(executableElement, OnValidationError.class) || Preconditions.hasMoreThanOneMethodsAnnotatedWith(parent, OnValidationError.class) || Preconditions.hasNoMethodAnnotatedWith(parent, OnValidationSuccess.class);
        if (hasError) {
            return;
        }
        parents.add(parent);
        validationActions.add(element);
    }

    private void parseRequiredValidation(Element element, Set<Element> parents, List<ValidationField> validationFields) {
        boolean hasError;
        boolean bl = hasError = Preconditions.isInvalid(RequiredValidation.class, element) || Preconditions.isInaccessible(RequiredValidation.class, element);
        if (hasError) {
            return;
        }
        int errorMessageResourceId = element.getAnnotation(RequiredValidation.class).errorMessage();
        boolean autoDismiss = element.getAnnotation(RequiredValidation.class).autoDismiss();
        QualifiedId qualifiedId = this.elementToQualifiedId(element, errorMessageResourceId);
        parents.add(element.getEnclosingElement());
        validationFields.add(new ValidationField(element, RequiredValidation.class, this.getId(qualifiedId), autoDismiss));
    }

    private void parseEmailValidation(Element element, Set<Element> parents, List<ValidationField> validationFields) {
        boolean hasError;
        boolean bl = hasError = Preconditions.isInvalid(EmailValidation.class, element) || Preconditions.isInaccessible(EmailValidation.class, element);
        if (hasError) {
            return;
        }
        int errorMessageResourceId = element.getAnnotation(EmailValidation.class).errorMessage();
        boolean autoDismiss = element.getAnnotation(EmailValidation.class).autoDismiss();
        QualifiedId qualifiedId = this.elementToQualifiedId(element, errorMessageResourceId);
        parents.add(element.getEnclosingElement());
        validationFields.add(new ValidationField(element, EmailValidation.class, this.getId(qualifiedId), autoDismiss));
    }

    private void parseConfirmEmailValidation(Element element, Set<Element> parents, List<ValidationField> validationFields) {
        boolean hasError;
        boolean bl = hasError = Preconditions.isInvalid(ConfirmEmailValidation.class, element) || Preconditions.isInaccessible(ConfirmEmailValidation.class, element) || Preconditions.confirmValidationElementsHasError(EmailValidation.class, ConfirmEmailValidation.class, element);
        if (hasError) {
            return;
        }
        int errorMessageResourceId = element.getAnnotation(ConfirmEmailValidation.class).errorMessage();
        boolean autoDismiss = element.getAnnotation(ConfirmEmailValidation.class).autoDismiss();
        QualifiedId qualifiedId = this.elementToQualifiedId(element, errorMessageResourceId);
        parents.add(element.getEnclosingElement());
        validationFields.add(new ValidationField(element, ConfirmEmailValidation.class, this.getId(qualifiedId), autoDismiss));
    }

    private void parsePatternValidation(Element element, Set<Element> parents, List<ValidationField> validationFields) {
        boolean hasError;
        boolean bl = hasError = Preconditions.isInvalid(PatternValidation.class, element) || Preconditions.isInaccessible(PatternValidation.class, element);
        if (hasError) {
            return;
        }
        int errorMessageResourceId = element.getAnnotation(PatternValidation.class).errorMessage();
        boolean autoDismiss = element.getAnnotation(PatternValidation.class).autoDismiss();
        QualifiedId qualifiedId = this.elementToQualifiedId(element, errorMessageResourceId);
        parents.add(element.getEnclosingElement());
        validationFields.add(new ValidationField(element, PatternValidation.class, this.getId(qualifiedId), autoDismiss));
    }

    private void parseLengthValidation(Element element, Set<Element> parents, List<ValidationField> validationFields) {
        int minLength = element.getAnnotation(LengthValidation.class).min();
        int maxLength = element.getAnnotation(LengthValidation.class).max();
        if (minLength == 0 && maxLength == 0) {
            Messager.error(element, "The min length and max length must be greater than zero.", new Object[0]);
        }
        if (maxLength > 0 && maxLength < minLength) {
            Messager.error(element, "The max lentgh must be greater than min lentgh.", new Object[0]);
        }
        try {
            boolean hasError;
            boolean bl = hasError = Preconditions.isInvalid(LengthValidation.class, element) || Preconditions.isInaccessible(LengthValidation.class, element);
            if (hasError) {
                return;
            }
            int errorMessageResourceId = element.getAnnotation(LengthValidation.class).errorMessage();
            boolean autoDismiss = element.getAnnotation(LengthValidation.class).autoDismiss();
            QualifiedId qualifiedId = this.elementToQualifiedId(element, errorMessageResourceId);
            parents.add(element.getEnclosingElement());
            validationFields.add(new ValidationField(element, LengthValidation.class, this.getId(qualifiedId), autoDismiss));
        }
        catch (Exception e) {
            Messager.logParsingError(element, LengthValidation.class, e);
        }
    }

    private void parseOnlyNumberValidation(Element element, Set<Element> parents, List<ValidationField> validationFields) {
        boolean hasError;
        boolean bl = hasError = Preconditions.isInvalid(OnlyNumberValidation.class, element) || Preconditions.isInaccessible(OnlyNumberValidation.class, element);
        if (hasError) {
            return;
        }
        int errorMessageResourceId = element.getAnnotation(OnlyNumberValidation.class).errorMessage();
        boolean autoDismiss = element.getAnnotation(OnlyNumberValidation.class).autoDismiss();
        QualifiedId qualifiedId = this.elementToQualifiedId(element, errorMessageResourceId);
        parents.add(element.getEnclosingElement());
        validationFields.add(new ValidationField(element, OnlyNumberValidation.class, this.getId(qualifiedId), autoDismiss));
    }

    private void parsePasswordValidation(Element element, Set<Element> parents, List<ValidationField> validationFields) {
        boolean hasError;
        boolean bl = hasError = Preconditions.isInvalid(PasswordValidation.class, element) || Preconditions.isInaccessible(PasswordValidation.class, element);
        if (hasError) {
            return;
        }
        List<? extends Element> elementsOfParent = element.getEnclosingElement().getEnclosedElements();
        int elementsAnnotatedWithPasswordValidation = 0;
        for (Element element2 : elementsOfParent) {
            if (element2.getAnnotation(PasswordValidation.class) == null) continue;
            ++elementsAnnotatedWithPasswordValidation;
        }
        if (elementsAnnotatedWithPasswordValidation > 1) {
            TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
            Messager.error(element.getEnclosingElement(), "%s must have only one element annotated with @PasswordValidation.", enclosingElement.getQualifiedName());
        }
        int errorMessageResourceId = element.getAnnotation(PasswordValidation.class).errorMessage();
        boolean bl2 = element.getAnnotation(PasswordValidation.class).autoDismiss();
        QualifiedId qualifiedId = this.elementToQualifiedId(element, errorMessageResourceId);
        parents.add(element.getEnclosingElement());
        validationFields.add(new ValidationField(element, PasswordValidation.class, this.getId(qualifiedId), bl2));
    }

    private void parseConfirmPasswordValidation(Element element, Set<Element> parents, List<ValidationField> validationFields) {
        boolean hasError;
        boolean bl = hasError = Preconditions.isInvalid(ConfirmPasswordValidation.class, element) || Preconditions.isInaccessible(ConfirmPasswordValidation.class, element) || Preconditions.confirmValidationElementsHasError(PasswordValidation.class, ConfirmPasswordValidation.class, element);
        if (hasError) {
            return;
        }
        int errorMessageResourceId = element.getAnnotation(ConfirmPasswordValidation.class).errorMessage();
        boolean autoDismiss = element.getAnnotation(ConfirmPasswordValidation.class).autoDismiss();
        QualifiedId qualifiedId = this.elementToQualifiedId(element, errorMessageResourceId);
        parents.add(element.getEnclosingElement());
        validationFields.add(new ValidationField(element, ConfirmPasswordValidation.class, this.getId(qualifiedId), autoDismiss));
    }

    private void parseCpfValidation(Element element, Set<Element> parents, List<ValidationField> validationFields) {
        boolean hasError;
        boolean bl = hasError = Preconditions.isInvalid(CpfValidation.class, element) || Preconditions.isInaccessible(CpfValidation.class, element);
        if (hasError) {
            return;
        }
        int errorMessageResourceId = element.getAnnotation(CpfValidation.class).errorMessage();
        boolean autoDismiss = element.getAnnotation(CpfValidation.class).autoDismiss();
        QualifiedId qualifiedId = this.elementToQualifiedId(element, errorMessageResourceId);
        parents.add(element.getEnclosingElement());
        validationFields.add(new ValidationField(element, CpfValidation.class, this.getId(qualifiedId), autoDismiss));
    }

    private void parseBetweenValidation(Element element, Set<Element> parents, List<ValidationField> validationFields) {
        boolean hasError;
        boolean bl = hasError = Preconditions.isInvalid(BetweenValidation.Start.class, element) || Preconditions.isInaccessible(BetweenValidation.Start.class, element) || Preconditions.isInvalid(BetweenValidation.End.class, element) || Preconditions.isInaccessible(BetweenValidation.End.class, element);
        if (hasError) {
            return;
        }
        List<? extends Element> elementsOfParent = element.getEnclosingElement().getEnclosedElements();
        int key = element.getAnnotation(BetweenValidation.Start.class).key();
        Element endElement = null;
        for (Element element2 : elementsOfParent) {
            if (element2.getAnnotation(BetweenValidation.End.class) == null || element2.getAnnotation(BetweenValidation.End.class).key() != key) continue;
            endElement = element2;
        }
        if (endElement == null) {
            Messager.error(element.getEnclosingElement(), "The class %s has one element annotated with @%s with key %s but it requires an element annotated with @%s and with same key.", element.getEnclosingElement().getSimpleName(), BetweenValidation.Start.class.getSimpleName(), key, BetweenValidation.End.class.getSimpleName());
            return;
        }
        int startErrorMessage = element.getAnnotation(BetweenValidation.Start.class).errorMessage();
        boolean bl2 = element.getAnnotation(BetweenValidation.Start.class).autoDismiss();
        QualifiedId startQualifiedId = this.elementToQualifiedId(element, startErrorMessage);
        parents.add(element.getEnclosingElement());
        validationFields.add(new ValidationField(element, BetweenValidation.Start.class, this.getId(startQualifiedId), bl2));
        int endErrorMessage = endElement.getAnnotation(BetweenValidation.End.class).errorMessage();
        boolean endAutoDismiss = endElement.getAnnotation(BetweenValidation.End.class).autoDismiss();
        QualifiedId endQualifiedId = this.elementToQualifiedId(endElement, endErrorMessage);
        parents.add(endElement.getEnclosingElement());
        validationFields.add(new ValidationField(endElement, BetweenValidation.End.class, this.getId(endQualifiedId), endAutoDismiss));
    }

    private void parseCreditCardValidation(Element element, Set<Element> parents, List<ValidationField> validationFields) {
        boolean hasError;
        boolean bl = hasError = Preconditions.isInvalid(CreditCardValidation.class, element) || Preconditions.isInaccessible(CreditCardValidation.class, element);
        if (hasError) {
            return;
        }
        int errorMessageResourceId = element.getAnnotation(CreditCardValidation.class).errorMessage();
        boolean autoDismiss = element.getAnnotation(CreditCardValidation.class).autoDismiss();
        QualifiedId qualifiedId = this.elementToQualifiedId(element, errorMessageResourceId);
        parents.add(element.getEnclosingElement());
        validationFields.add(new ValidationField(element, CreditCardValidation.class, this.getId(qualifiedId), autoDismiss));
    }

    private void parseNumberLimitValidation(Element element, Set<Element> parents, List<ValidationField> validationFields) {
        boolean hasError;
        boolean bl = hasError = Preconditions.isInvalid(NumberLimitValidation.class, element) || Preconditions.isInaccessible(NumberLimitValidation.class, element);
        if (hasError) {
            return;
        }
        int errorMessageResourceId = element.getAnnotation(NumberLimitValidation.class).errorMessage();
        boolean autoDismiss = element.getAnnotation(NumberLimitValidation.class).autoDismiss();
        QualifiedId qualifiedId = this.elementToQualifiedId(element, errorMessageResourceId);
        parents.add(element.getEnclosingElement());
        validationFields.add(new ValidationField(element, NumberLimitValidation.class, this.getId(qualifiedId), autoDismiss));
    }

    private static AnnotationMirror getMirror(Element element, Class<? extends Annotation> annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotation.getCanonicalName())) continue;
            return annotationMirror;
        }
        return null;
    }

    private QualifiedId elementToQualifiedId(Element element, int id) {
        return new QualifiedId(this.elementUtils.getPackageOf(element).getQualifiedName().toString(), id);
    }

    private Id getId(QualifiedId qualifiedId) {
        if (this.symbols.get(qualifiedId) == null) {
            this.symbols.put(qualifiedId, new Id(qualifiedId.id));
        }
        return this.symbols.get(qualifiedId);
    }

    private void scanForRClasses(RoundEnvironment env) {
        if (this.trees == null) {
            return;
        }
        RClassScanner scanner = new RClassScanner();
        for (Class<? extends Annotation> clazz : this.getSupportedAnnotations()) {
            for (Element element : env.getElementsAnnotatedWith(clazz)) {
                JCTree tree = (JCTree)this.trees.getTree(element, ConvalidaProcessor.getMirror(element, clazz));
                if (tree == null) continue;
                String respectivePackageName = this.elementUtils.getPackageOf(element).getQualifiedName().toString();
                scanner.setCurrentPackageName(respectivePackageName);
                tree.accept(scanner);
            }
        }
        for (Map.Entry entry : scanner.getRClasses().entrySet()) {
            String respectivePackageName = (String)entry.getKey();
            for (String rClass : (Set)entry.getValue()) {
                this.parseRClass(respectivePackageName, rClass);
            }
        }
    }

    private void parseRClass(String respectivePackageName, String rClass) {
        Element element;
        try {
            element = this.elementUtils.getTypeElement(rClass);
        }
        catch (MirroredTypeException mte) {
            element = this.typeUtils.asElement(mte.getTypeMirror());
        }
        JCTree tree = (JCTree)this.trees.getTree(element);
        if (tree != null) {
            IdScanner idScanner = new IdScanner(this.symbols, this.elementUtils.getPackageOf(element).getQualifiedName().toString(), respectivePackageName);
            tree.accept(idScanner);
        } else {
            this.parseCompiledR(respectivePackageName, (TypeElement)element);
        }
    }

    private void parseCompiledR(String respectivePackageName, TypeElement rClass) {
        for (Element element : rClass.getEnclosedElements()) {
            String innerClassName = element.getSimpleName().toString();
            if (!innerClassName.equals("string")) continue;
            for (Element element2 : element.getEnclosedElements()) {
                VariableElement variableElement;
                Object value;
                if (!(element2 instanceof VariableElement) || !((value = (variableElement = (VariableElement)element2).getConstantValue()) instanceof Integer)) continue;
                int id = (Integer)value;
                ClassName rClassName = ClassName.get((String)this.elementUtils.getPackageOf(variableElement).toString(), (String)"R", (String[])new String[]{innerClassName});
                String resourceName = variableElement.getSimpleName().toString();
                QualifiedId qualifiedId = new QualifiedId(respectivePackageName, id);
                this.symbols.put(qualifiedId, new Id(id, rClassName, resourceName));
            }
        }
    }
}

