/*
 * Decompiled with CFR 0.152.
 */
package net.wedjaa.ansible.vault.crypto.decoders.implementation;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.wedjaa.ansible.vault.crypto.data.Util;
import net.wedjaa.ansible.vault.crypto.data.VaultContent;
import net.wedjaa.ansible.vault.crypto.data.VaultInfo;
import net.wedjaa.ansible.vault.crypto.decoders.implementation.EncryptionKeychain;
import net.wedjaa.ansible.vault.crypto.decoders.inter.CypherInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CypherAES256
implements CypherInterface {
    Logger logger = LoggerFactory.getLogger(CypherAES256.class);
    public static final String CYPHER_ID = "AES256";
    public static final int AES_KEYLEN = 256;
    public static final String CHAR_ENCODING = "UTF-8";
    public static final String KEYGEN_ALGO = "HmacSHA256";
    public static final String CYPHER_KEY_ALGO = "AES";
    public static final String CYPHER_ALGO = "AES/CTR/NoPadding";
    private static final String JDK8_UPF_URL = "http://www.oracle.com/technetwork/java/javase/downloads/jce8-download-2133166.html";
    private static final int SALT_LENGTH = 32;
    public static final int KEYLEN = 32;
    public static final int IVLEN = 16;
    public static final int ITERATIONS = 10000;

    private boolean hasValidAESProvider() {
        boolean canCrypt = false;
        try {
            int maxKeyLen = Cipher.getMaxAllowedKeyLength(CYPHER_ALGO);
            this.logger.debug("Available keylen: {}", (Object)maxKeyLen);
            if (maxKeyLen >= 256) {
                canCrypt = true;
            } else {
                this.logger.warn("JRE doesn't support {} keylength for {}\nInstall unrestricted policy files from:\n{}", 256, CYPHER_KEY_ALGO, JDK8_UPF_URL);
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to check for proper cypher algorithms: {}", (Object)ex.getMessage());
        }
        return canCrypt;
    }

    public byte[] calculateHMAC(byte[] key, byte[] data) throws IOException {
        byte[] computedMac = null;
        try {
            SecretKeySpec hmacKey = new SecretKeySpec(key, KEYGEN_ALGO);
            Mac mac = Mac.getInstance(KEYGEN_ALGO);
            mac.init(hmacKey);
            computedMac = mac.doFinal(data);
        }
        catch (Exception ex) {
            throw new IOException("Error decrypting HMAC hash: " + ex.getMessage());
        }
        return computedMac;
    }

    public boolean verifyHMAC(byte[] hmac, byte[] key, byte[] data) throws IOException {
        boolean matches = false;
        byte[] calculated = this.calculateHMAC(key, data);
        return Arrays.equals(hmac, calculated);
    }

    public int paddingLength(byte[] decrypted) {
        if (decrypted.length == 0) {
            this.logger.debug("Empty decoded text has no padding.");
            return 0;
        }
        this.logger.debug("Padding length: {}", (Object)decrypted[decrypted.length - 1]);
        return decrypted[decrypted.length - 1];
    }

    public byte[] unpad(byte[] decrypted) {
        int length = decrypted.length - this.paddingLength(decrypted);
        return Arrays.copyOfRange(decrypted, 0, length);
    }

    public byte[] pad(byte[] cleartext) throws IOException {
        byte[] padded = null;
        try {
            int blockSize = Cipher.getInstance(CYPHER_ALGO).getBlockSize();
            this.logger.debug("Padding to block size: {}", (Object)blockSize);
            int padding_length = blockSize - cleartext.length % blockSize;
            if (padding_length == 0) {
                padding_length = blockSize;
            }
            padded = Arrays.copyOf(cleartext, cleartext.length + padding_length);
            padded[padded.length - 1] = (byte)padding_length;
        }
        catch (Exception ex) {
            new IOException("Error calculating padding for AES/CTR/NoPadding: " + ex.getMessage());
        }
        return padded;
    }

    public byte[] decryptAES(byte[] cypher, byte[] key, byte[] iv) throws IOException {
        SecretKeySpec keySpec = new SecretKeySpec(key, CYPHER_KEY_ALGO);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        try {
            Cipher cipher = Cipher.getInstance(CYPHER_ALGO);
            cipher.init(2, (Key)keySpec, ivSpec);
            byte[] decrypted = cipher.doFinal(cypher);
            return this.unpad(decrypted);
        }
        catch (Exception ex) {
            throw new IOException("Failed to decrypt data: " + ex.getMessage());
        }
    }

    public byte[] encryptAES(byte[] cleartext, byte[] key, byte[] iv) throws IOException {
        SecretKeySpec keySpec = new SecretKeySpec(key, CYPHER_KEY_ALGO);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        try {
            Cipher cipher = Cipher.getInstance(CYPHER_ALGO);
            cipher.init(1, (Key)keySpec, ivSpec);
            byte[] encrypted = cipher.doFinal(cleartext);
            return encrypted;
        }
        catch (Exception ex) {
            throw new IOException("Failed to encrypt data: " + ex.getMessage());
        }
    }

    public byte[] decrypt(byte[] encryptedData, String password) throws IOException {
        byte[] decrypted = null;
        if (!this.hasValidAESProvider()) {
            throw new IOException("Missing valid AES256 provider - install unrestricted policy profiles.");
        }
        VaultContent vaultContent = new VaultContent(encryptedData);
        byte[] salt = vaultContent.getSalt();
        byte[] hmac = vaultContent.getHmac();
        byte[] cypher = vaultContent.getData();
        this.logger.debug("Salt: {} - {}", (Object)salt.length, (Object)Util.hexit(salt, 100));
        this.logger.debug("HMAC: {} - {}", (Object)hmac.length, (Object)Util.hexit(hmac, 100));
        this.logger.debug("Data: {} - {}", (Object)cypher.length, (Object)Util.hexit(cypher, 100));
        EncryptionKeychain keys = new EncryptionKeychain(salt, password, 32, 16, 10000, KEYGEN_ALGO);
        keys.createKeys();
        byte[] cypherKey = keys.getEncryptionKey();
        this.logger.debug("Key 1: {} - {}", (Object)cypherKey.length, (Object)Util.hexit(cypherKey, 100));
        byte[] hmacKey = keys.getHmacKey();
        this.logger.debug("Key 2: {} - {}", (Object)hmacKey.length, (Object)Util.hexit(hmacKey, 100));
        byte[] iv = keys.getIv();
        this.logger.debug("IV: {} - {}", (Object)iv.length, (Object)Util.hexit(iv, 100));
        if (!this.verifyHMAC(hmac, hmacKey, cypher)) {
            throw new IOException("HMAC Digest doesn't match - possibly it's the wrong password.");
        }
        this.logger.debug("Signature matches - decrypting");
        decrypted = this.decryptAES(cypher, cypherKey, iv);
        this.logger.debug("Decoded:\n{}", (Object)new String(decrypted, CHAR_ENCODING));
        return decrypted;
    }

    public void decrypt(OutputStream decodedStream, byte[] encryptedData, String password) throws IOException {
        decodedStream.write(this.decrypt(encryptedData, password));
    }

    public void encrypt(OutputStream encodedStream, byte[] data, String password) throws IOException {
        encodedStream.write(this.encrypt(data, password));
    }

    public String infoLine() {
        return VaultInfo.vaultInfoForCypher(CYPHER_ID);
    }

    public byte[] encrypt(byte[] data, String password) throws IOException {
        EncryptionKeychain keys = new EncryptionKeychain(32, password, 32, 16, 10000, KEYGEN_ALGO);
        keys.createKeys();
        byte[] cypherKey = keys.getEncryptionKey();
        this.logger.debug("Key 1: {} - {}", (Object)cypherKey.length, (Object)Util.hexit(cypherKey, 100));
        byte[] hmacKey = keys.getHmacKey();
        this.logger.debug("Key 2: {} - {}", (Object)hmacKey.length, (Object)Util.hexit(hmacKey, 100));
        byte[] iv = keys.getIv();
        this.logger.debug("IV: {} - {}", (Object)iv.length, (Object)Util.hexit(iv, 100));
        this.logger.debug("Original data length: {}", (Object)data.length);
        data = this.pad(data);
        this.logger.debug("Padded data length: {}", (Object)data.length);
        byte[] encrypted = this.encryptAES(data, keys.getEncryptionKey(), keys.getIv());
        byte[] hmacHash = this.calculateHMAC(keys.getHmacKey(), encrypted);
        VaultContent vaultContent = new VaultContent(keys.getSalt(), hmacHash, encrypted);
        return vaultContent.toByteArray();
    }
}

