/*
 * Decompiled with CFR 0.152.
 */
package net.wedjaa.ansible.vault.crypto.data;

import java.io.IOException;
import net.wedjaa.ansible.vault.crypto.data.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultContent {
    Logger logger = LoggerFactory.getLogger(VaultContent.class);
    private static final String CHAR_ENCODING = "UTF-8";
    private byte[] salt;
    private byte[] hmac;
    private byte[] data;

    public VaultContent(byte[] encryptedVault) throws IOException {
        byte[][] vaultContents = this.splitData(encryptedVault);
        this.salt = Util.unhex(new String(vaultContents[0], CHAR_ENCODING));
        this.hmac = Util.unhex(new String(vaultContents[1], CHAR_ENCODING));
        this.data = Util.unhex(new String(vaultContents[2], CHAR_ENCODING));
    }

    public VaultContent(byte[] salt, byte[] hmac, byte[] data) {
        this.salt = salt;
        this.hmac = hmac;
        this.data = data;
    }

    public byte[] toByteArray() {
        return this.toString().getBytes();
    }

    public String toString() {
        this.logger.debug("Salt: {} - HMAC: {} - Data: {} - TargetLen: {}", this.salt.length, this.hmac.length, this.data.length, (this.salt.length + this.hmac.length + this.data.length) * 2);
        String saltString = Util.hexit(this.salt);
        this.logger.debug("Salt String Length: {}", (Object)saltString.length());
        String hmacString = Util.hexit(this.hmac);
        this.logger.debug("HMAC String Length: {}", (Object)hmacString.length());
        String dataString = Util.hexit(this.data, -1);
        this.logger.debug("DATA String Length: {}", (Object)dataString.length());
        String complete = saltString + "\n" + hmacString + "\n" + dataString;
        this.logger.debug("Complete: {} \n{}", (Object)complete.length(), (Object)complete);
        String result = Util.hexit(complete.getBytes(), 80);
        this.logger.debug("Result: [{}] {}\n{}", complete.length() * 2, result.length(), result);
        return result;
    }

    private int[] getDataLengths(byte[] encodedData) throws IOException {
        int idx;
        int[] result = new int[3];
        int saltLen = 0;
        for (idx = 0; encodedData[idx] != 10 && idx < encodedData.length; ++idx) {
            ++saltLen;
        }
        if (++idx == encodedData.length) {
            throw new IOException("Malformed data - salt incomplete");
        }
        result[0] = saltLen;
        int hmacLen = 0;
        while (encodedData[idx] != 10 && idx < encodedData.length) {
            ++hmacLen;
            ++idx;
        }
        if (++idx == encodedData.length) {
            throw new IOException("Malformed data - hmac incomplete");
        }
        result[1] = hmacLen;
        int dataLen = 0;
        while (idx < encodedData.length) {
            ++dataLen;
            ++idx;
        }
        result[2] = dataLen;
        return result;
    }

    private byte[][] splitData(byte[] encodedData) throws IOException {
        int[] partsLength = this.getDataLengths(encodedData);
        byte[][] result = new byte[3][];
        int idx = 0;
        int saltIdx = 0;
        result[0] = new byte[partsLength[0]];
        while (encodedData[idx] != 10 && idx < encodedData.length) {
            result[0][saltIdx++] = encodedData[idx++];
        }
        if (++idx == encodedData.length) {
            throw new IOException("Malformed data - salt incomplete");
        }
        int macIdx = 0;
        result[1] = new byte[partsLength[1]];
        while (encodedData[idx] != 10 && idx < encodedData.length) {
            result[1][macIdx++] = encodedData[idx++];
        }
        if (++idx == encodedData.length) {
            throw new IOException("Malformed data - hmac incomplete");
        }
        int dataIdx = 0;
        result[2] = new byte[partsLength[2]];
        while (idx < encodedData.length) {
            result[2][dataIdx++] = encodedData[idx++];
        }
        return result;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getHmac() {
        return this.hmac;
    }

    public byte[] getData() {
        return this.data;
    }
}

